/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.dates.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ILeftCombinator;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatterBuilder;
import org.joda.time.format.PeriodPrinter;

public class LocalizedPeriodPrinter
implements PeriodPrinter {
    private static final String COMMA = ", ";
    private final Map<DurationFieldType, PeriodPrinter> printers = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));

    public LocalizedPeriodPrinter() {
        this.fillPrinters();
    }

    public int calculatePrintedLength(final ReadablePeriod period, final Locale locale) {
        int fieldsToPrint = this.countFieldsToPrint(period, Integer.MAX_VALUE, locale);
        int totalLength = (Integer)Sequence.fromIterable((Iterable)MapSequence.fromMap(this.printers).values()).foldLeft((Object)0, (_FunctionTypes._return_P2_E0)new ILeftCombinator<PeriodPrinter, Integer>(){

            public Integer combine(Integer s, PeriodPrinter it) {
                return it.calculatePrintedLength(period, locale);
            }
        });
        if (fieldsToPrint == 0) {
            return 0;
        }
        if (fieldsToPrint == 1) {
            return totalLength;
        }
        return totalLength + this.getAndSeparator(locale).length() + (fieldsToPrint - 2) * COMMA.length();
    }

    public int countFieldsToPrint(final ReadablePeriod period, final int i, final Locale locale) {
        return (Integer)Sequence.fromIterable((Iterable)MapSequence.fromMap(this.printers).values()).foldLeft((Object)0, (_FunctionTypes._return_P2_E0)new ILeftCombinator<PeriodPrinter, Integer>(){

            public Integer combine(Integer s, PeriodPrinter it) {
                return it.countFieldsToPrint(period, i, locale);
            }
        });
    }

    public void printTo(StringBuffer buffer, ReadablePeriod period, Locale locale) {
        this.buildPrinter(locale, period).printTo(buffer, period, locale);
    }

    public void printTo(Writer writer, ReadablePeriod period, Locale locale) throws IOException {
        this.buildPrinter(locale, period).printTo(writer, period, locale);
    }

    private PeriodPrinter buildPrinter(final Locale locale, final ReadablePeriod period) {
        String andSeparator = this.getAndSeparator(locale);
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        boolean empty = true;
        for (PeriodPrinter printer : Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])period.toPeriod().getFieldTypes())).select((_FunctionTypes._return_P1_E0)new ISelector<DurationFieldType, PeriodPrinter>(){

            public PeriodPrinter select(DurationFieldType it) {
                return (PeriodPrinter)MapSequence.fromMap((Map)LocalizedPeriodPrinter.this.printers).get((Object)it);
            }
        }).where((_FunctionTypes._return_P1_E0)new IWhereFilter<PeriodPrinter>(){

            public boolean accept(PeriodPrinter it) {
                return it.countFieldsToPrint((ReadablePeriod)period.toPeriod(), Integer.MAX_VALUE, locale) > 0;
            }
        })) {
            builder.append(printer, null);
            builder.appendSeparator(COMMA, andSeparator);
            empty = false;
        }
        if (empty) {
            builder.append((PeriodPrinter)MapSequence.fromMap(this.printers).get(Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])period.toPeriod().getFieldTypes())).last()), null);
        }
        return builder.toPrinter();
    }

    private String getAndSeparator(Locale locale) {
        return " " + LocalizedPeriodPrinter.trim_c8giwv_a0a0a0f(((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("internationalization.dates.and", locale, new Object[0])) + " ";
    }

    private void fillPrinters() {
        this.createPrinter(DurationFieldType.years(), "internationalization.dates.year");
        this.createPrinter(DurationFieldType.months(), "internationalization.dates.month");
        this.createPrinter(DurationFieldType.weeks(), "internationalization.dates.week");
        this.createPrinter(DurationFieldType.days(), "internationalization.dates.day");
        this.createPrinter(DurationFieldType.hours(), "internationalization.dates.hour");
        this.createPrinter(DurationFieldType.minutes(), "internationalization.dates.minute");
        this.createPrinter(DurationFieldType.seconds(), "internationalization.dates.second");
        this.createPrinter(DurationFieldType.millis(), "internationalization.dates.millisecond");
    }

    private void createPrinter(DurationFieldType durationFieldType, String localizationId) {
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        builder.append((PeriodPrinter)new FieldPrinter(durationFieldType, localizationId), null);
        MapSequence.fromMap(this.printers).put((Object)durationFieldType, (Object)builder.toPrinter());
    }

    public static String trim_c8giwv_a0a0a0f(String str) {
        return str == null ? null : str.trim();
    }

    private class FieldPrinter
    implements PeriodPrinter {
        private final DurationFieldType fieldType;
        private final String localizationId;

        private FieldPrinter(DurationFieldType fieldType, String localizationId) {
            this.fieldType = fieldType;
            this.localizationId = localizationId;
        }

        public int calculatePrintedLength(ReadablePeriod period, Locale locale) {
            if (this.countFieldsToPrint(period, Integer.MAX_VALUE, locale) > 0) {
                return this.getPresentation(period.get(this.fieldType), locale).length();
            }
            return 0;
        }

        public int countFieldsToPrint(ReadablePeriod period, int i, Locale locale) {
            if (period.get(this.fieldType) > 0) {
                return 1;
            }
            return 0;
        }

        public void printTo(StringBuffer buffer, ReadablePeriod period, Locale locale) {
            buffer.append(this.getPresentation(period.get(this.fieldType), locale));
        }

        public void printTo(Writer writer, ReadablePeriod period, Locale locale) throws IOException {
            writer.append(this.getPresentation(period.get(this.fieldType), locale));
        }

        private String getPresentation(int value, Locale locale) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale(this.localizationId, locale, new Object[]{value});
        }
    }
}

