/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.convert;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import jetbrains.exodus.crypto.convert.ArchiveBackupableFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/exodus/crypto/convert/ArchiveBackupableFactory;", "Lmu/KLogging;", "()V", "separators", "", "newArchiveBackupStrategy", "Ljetbrains/exodus/backup/BackupStrategy;", "archive", "Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "newArchiveIterator", "", "Ljetbrains/exodus/backup/VirtualFileDescriptor;", "newBackupable", "Ljetbrains/exodus/backup/Backupable;", "file", "Ljava/io/File;", "gzip", "", "stream", "Ljava/io/InputStream;", "parseEntryPath", "Lkotlin/Pair;", "", "entryName", "ArchiveEntryFileDescriptor", "xodus-crypto"})
public final class ArchiveBackupableFactory
extends KLogging {
    private static final char[] separators;
    public static final ArchiveBackupableFactory INSTANCE;

    @NotNull
    public final Backupable newBackupable(@NotNull InputStream stream, boolean gzip) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        return new Backupable(gzip, stream){
            final /* synthetic */ boolean $gzip;
            final /* synthetic */ InputStream $stream;

            @NotNull
            public final BackupStrategy getBackupStrategy() {
                ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(this.$gzip ? (InputStream)new GZIPInputStream(this.$stream) : this.$stream));
                Intrinsics.checkExpressionValueIsNotNull((Object)archiveInputStream, (String)"ArchiveStreamFactory().c\u2026       stream\n        }))");
                return ArchiveBackupableFactory.access$newArchiveBackupStrategy(ArchiveBackupableFactory.INSTANCE, archiveInputStream);
            }
            {
                this.$gzip = bl;
                this.$stream = inputStream;
            }
        };
    }

    @NotNull
    public final Backupable newBackupable(@NotNull File file, boolean gzip) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File file2 = file;
        ArchiveBackupableFactory archiveBackupableFactory = this;
        FileInputStream fileInputStream = new FileInputStream(file2);
        return archiveBackupableFactory.newBackupable(fileInputStream, gzip);
    }

    private final BackupStrategy newArchiveBackupStrategy(ArchiveInputStream archive) {
        return new BackupStrategy(archive){
            final /* synthetic */ ArchiveInputStream $archive;

            @NotNull
            public newArchiveBackupStrategy.getContents.1 getContents() {
                return new Iterable<VirtualFileDescriptor>(this){
                    final /* synthetic */ newArchiveBackupStrategy.1 this$0;

                    @NotNull
                    public Iterator<VirtualFileDescriptor> iterator() {
                        return ArchiveBackupableFactory.access$newArchiveIterator(ArchiveBackupableFactory.INSTANCE, this.this$0.$archive);
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }

            public void afterBackup() {
                this.$archive.close();
            }
            {
                this.$archive = $captured_local_variable$0;
            }
        };
    }

    private final Iterator<VirtualFileDescriptor> newArchiveIterator(ArchiveInputStream archive) {
        return new Iterator<VirtualFileDescriptor>(archive){
            @Nullable
            private ArchiveEntry entry;
            final /* synthetic */ ArchiveInputStream $archive;

            @Nullable
            public final ArchiveEntry getEntry() {
                return this.entry;
            }

            public final void setEntry(@Nullable ArchiveEntry archiveEntry) {
                this.entry = archiveEntry;
            }

            public boolean hasNext() {
                if (this.entry == null) {
                    this.entry = this.$archive.getNextEntry();
                }
                return this.entry != null;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public VirtualFileDescriptor next() {
                void path;
                String entryName;
                ArchiveEntry archiveEntry;
                if (this.entry == null) {
                    this.entry = this.$archive.getNextEntry();
                }
                ArchiveEntry archiveEntry2 = this.entry;
                if (archiveEntry2 == null) {
                    throw (Throwable)new NoSuchElementException();
                }
                ArchiveEntry it = archiveEntry = archiveEntry2;
                String string = entryName = it.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entryName");
                Object object = ArchiveBackupableFactory.access$parseEntryPath(ArchiveBackupableFactory.INSTANCE, string);
                String string2 = (String)object.component1();
                String name = (String)object.component2();
                Object it2 = object = new ArchiveEntryFileDescriptor(this.$archive, it, (String)path, name, 0L, 16, null);
                this.entry = null;
                return (VirtualFileDescriptor)object;
            }

            @NotNull
            public Void remove() {
                throw (Throwable)new UnsupportedOperationException();
            }
            {
                this.$archive = $captured_local_variable$0;
            }
        };
    }

    private final Pair<String, String> parseEntryPath(String entryName) {
        String name;
        String path;
        int separatorIndex = StringsKt.lastIndexOfAny$default((CharSequence)entryName, (char[])separators, (int)0, (boolean)false, (int)6, null);
        if (separatorIndex >= 0) {
            String string = entryName;
            int n = 0;
            int n2 = separatorIndex + 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            path = string3;
            string = entryName;
            n = separatorIndex + 1;
            n2 = entryName.length();
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            name = string5;
        } else {
            path = "";
            name = entryName;
        }
        return new Pair((Object)path, (Object)name);
    }

    private ArchiveBackupableFactory() {
    }

    static {
        ArchiveBackupableFactory archiveBackupableFactory;
        INSTANCE = archiveBackupableFactory = new ArchiveBackupableFactory();
        separators = new char[]{'\\', '/'};
    }

    @NotNull
    public static final /* synthetic */ BackupStrategy access$newArchiveBackupStrategy(ArchiveBackupableFactory $this, @NotNull ArchiveInputStream archive) {
        return $this.newArchiveBackupStrategy(archive);
    }

    @NotNull
    public static final /* synthetic */ Iterator access$newArchiveIterator(ArchiveBackupableFactory $this, @NotNull ArchiveInputStream archive) {
        return $this.newArchiveIterator(archive);
    }

    @NotNull
    public static final /* synthetic */ Pair access$parseEntryPath(ArchiveBackupableFactory $this, @NotNull String entryName) {
        return $this.parseEntryPath(entryName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\nH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Ljetbrains/exodus/crypto/convert/ArchiveBackupableFactory$ArchiveEntryFileDescriptor;", "Ljetbrains/exodus/backup/VirtualFileDescriptor;", "archive", "Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "entry", "Lorg/apache/commons/compress/archivers/ArchiveEntry;", "_path", "", "_name", "size", "", "(Lorg/apache/commons/compress/archivers/ArchiveInputStream;Lorg/apache/commons/compress/archivers/ArchiveEntry;Ljava/lang/String;Ljava/lang/String;J)V", "get_name", "()Ljava/lang/String;", "get_path", "getArchive", "()Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "canBeEncrypted", "", "getEntry", "()Lorg/apache/commons/compress/archivers/ArchiveEntry;", "getSize", "()J", "copy", "acceptedSize", "getFile", "Ljava/io/File;", "getFileSize", "getInputStream", "getName", "getPath", "getTimeStamp", "hasContent", "shouldCloseStream", "xodus-crypto"})
    private static final class ArchiveEntryFileDescriptor
    implements VirtualFileDescriptor {
        private final boolean canBeEncrypted;
        @NotNull
        private final ArchiveInputStream archive;
        @NotNull
        private final ArchiveEntry entry;
        @NotNull
        private final String _path;
        @NotNull
        private final String _name;
        private final long size;

        @NotNull
        public String getPath() {
            return this._path;
        }

        @Nullable
        public File getFile() {
            return null;
        }

        @NotNull
        public String getName() {
            return this._name;
        }

        public boolean hasContent() {
            return !this.entry.isDirectory();
        }

        public long getFileSize() {
            return this.size;
        }

        public boolean canBeEncrypted() {
            return this.canBeEncrypted;
        }

        public long getTimeStamp() {
            Date date = this.entry.getLastModifiedDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"entry.lastModifiedDate");
            return date.getTime();
        }

        @NotNull
        public ArchiveInputStream getInputStream() {
            return this.archive;
        }

        public boolean shouldCloseStream() {
            return false;
        }

        @NotNull
        public ArchiveEntryFileDescriptor copy(long acceptedSize) {
            return new ArchiveEntryFileDescriptor(this.archive, this.entry, this._path, this._name, acceptedSize);
        }

        @NotNull
        public final ArchiveInputStream getArchive() {
            return this.archive;
        }

        @NotNull
        public final ArchiveEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final String get_path() {
            return this._path;
        }

        @NotNull
        public final String get_name() {
            return this._name;
        }

        public final long getSize() {
            return this.size;
        }

        public ArchiveEntryFileDescriptor(@NotNull ArchiveInputStream archive, @NotNull ArchiveEntry entry, @NotNull String _path, @NotNull String _name, long size) {
            Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            Intrinsics.checkParameterIsNotNull((Object)_path, (String)"_path");
            Intrinsics.checkParameterIsNotNull((Object)_name, (String)"_name");
            this.archive = archive;
            this.entry = entry;
            this._path = _path;
            this._name = _name;
            this.size = size;
            this.canBeEncrypted = Intrinsics.areEqual((Object)"version", (Object)this._name) ^ true && Intrinsics.areEqual((Object)"xd.lck", (Object)this._name) ^ true;
        }

        public /* synthetic */ ArchiveEntryFileDescriptor(ArchiveInputStream archiveInputStream, ArchiveEntry archiveEntry, String string, String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                l = archiveEntry.getSize();
            }
            this(archiveInputStream, archiveEntry, string, string2, l);
        }
    }
}

