/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.streamciphers;

import jetbrains.exodus.crypto.InitializationVektorKt;
import jetbrains.exodus.crypto.StreamCipher;
import jetbrains.exodus.crypto.StreamCipherProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/exodus/crypto/streamciphers/JBChaChaStreamCipherProvider;", "Ljetbrains/exodus/crypto/StreamCipherProvider;", "()V", "getId", "", "newCipher", "Ljetbrains/exodus/crypto/StreamCipher;", "JBChaChaStreamCipher", "xodus-crypto"})
public final class JBChaChaStreamCipherProvider
extends StreamCipherProvider {
    @NotNull
    public String getId() {
        return "jetbrains.exodus.crypto.streamciphers.JBChaChaStreamCipherProvider";
    }

    @NotNull
    public StreamCipher newCipher() {
        return new JBChaChaStreamCipher(0, 1, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0006\u0010\u0016\u001a\u00020\u000eJ \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/exodus/crypto/streamciphers/JBChaChaStreamCipherProvider$JBChaChaStreamCipher;", "Ljetbrains/exodus/crypto/StreamCipher;", "rounds", "", "(I)V", "index", "keyStream", "", "state", "", "crypt", "", "b", "generateKeyStream", "", "init", "keyBytes", "iv", "", "intToKeyStream", "n", "off", "reset", "updateState", "bs", "count", "Companion", "xodus-crypto"})
    private static final class JBChaChaStreamCipher
    implements StreamCipher {
        private final int[] state;
        private final byte[] keyStream;
        private int index;
        private final int rounds;
        private static final int CHACHA_IV_SIZE = 12;
        private static final int DEFAULT_ROUNDS = 20;
        private static final int STATE_SIZE = 16;
        private static final int[] TAU_SIGMA;
        @Deprecated
        public static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        public void init(@NotNull byte[] keyBytes, long iv) {
            Intrinsics.checkParameterIsNotNull((Object)keyBytes, (String)"keyBytes");
            if (keyBytes.length != 32) {
                throw (Throwable)new IllegalArgumentException("256 bit key is required");
            }
            byte[] ivBytes = InitializationVektorKt.toByteArray(iv, 12);
            int n = 0;
            int n2 = 3;
            while (n <= n2) {
                void i;
                this.state[i] = TAU_SIGMA[i + 4];
                ++i;
            }
            this.updateState(keyBytes, 4, 8);
            this.updateState(ivBytes, 13, 3);
            this.reset();
        }

        public byte crypt(byte b) {
            byte by = this.keyStream[this.index];
            byte out = (byte)(by ^ b);
            JBChaChaStreamCipher jBChaChaStreamCipher = this;
            ++jBChaChaStreamCipher.index;
            if (jBChaChaStreamCipher.index == 64) {
                this.index = 0;
                int[] nArray = this.state;
                nArray[12] = nArray[12] + 1;
                if (this.state[12] == 0) {
                    throw (Throwable)new IllegalStateException("Attempt to increase counter past 2^32.");
                }
                this.generateKeyStream();
            }
            return out;
        }

        public final void reset() {
            this.index = 0;
            this.state[12] = 0;
            this.generateKeyStream();
        }

        private final void generateKeyStream() {
            int x00 = this.state[0];
            int x01 = this.state[1];
            int x02 = this.state[2];
            int x03 = this.state[3];
            int x04 = this.state[4];
            int x05 = this.state[5];
            int x06 = this.state[6];
            int x07 = this.state[7];
            int x08 = this.state[8];
            int x09 = this.state[9];
            int x10 = this.state[10];
            int x11 = this.state[11];
            int x12 = this.state[12];
            int x13 = this.state[13];
            int x14 = this.state[14];
            int x15 = this.state[15];
            int n = this.rounds / 2;
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                x12 = JBChaChaStreamCipher.Companion.rotl16(x12 ^ (x00 += x04));
                x04 = JBChaChaStreamCipher.Companion.rotl12(x04 ^ (x08 += x12));
                x12 = JBChaChaStreamCipher.Companion.rotl8(x12 ^ (x00 += x04));
                x04 = JBChaChaStreamCipher.Companion.rotl7(x04 ^ (x08 += x12));
                x13 = JBChaChaStreamCipher.Companion.rotl16(x13 ^ (x01 += x05));
                x05 = JBChaChaStreamCipher.Companion.rotl12(x05 ^ (x09 += x13));
                x13 = JBChaChaStreamCipher.Companion.rotl8(x13 ^ (x01 += x05));
                x05 = JBChaChaStreamCipher.Companion.rotl7(x05 ^ (x09 += x13));
                x14 = JBChaChaStreamCipher.Companion.rotl16(x14 ^ (x02 += x06));
                x06 = JBChaChaStreamCipher.Companion.rotl12(x06 ^ (x10 += x14));
                x14 = JBChaChaStreamCipher.Companion.rotl8(x14 ^ (x02 += x06));
                x06 = JBChaChaStreamCipher.Companion.rotl7(x06 ^ (x10 += x14));
                x15 = JBChaChaStreamCipher.Companion.rotl16(x15 ^ (x03 += x07));
                x07 = JBChaChaStreamCipher.Companion.rotl12(x07 ^ (x11 += x15));
                x15 = JBChaChaStreamCipher.Companion.rotl8(x15 ^ (x03 += x07));
                x07 = JBChaChaStreamCipher.Companion.rotl7(x07 ^ (x11 += x15));
                x15 = JBChaChaStreamCipher.Companion.rotl16(x15 ^ (x00 += x05));
                x05 = JBChaChaStreamCipher.Companion.rotl12(x05 ^ (x10 += x15));
                x15 = JBChaChaStreamCipher.Companion.rotl8(x15 ^ (x00 += x05));
                x05 = JBChaChaStreamCipher.Companion.rotl7(x05 ^ (x10 += x15));
                x12 = JBChaChaStreamCipher.Companion.rotl16(x12 ^ (x01 += x06));
                x06 = JBChaChaStreamCipher.Companion.rotl12(x06 ^ (x11 += x12));
                x12 = JBChaChaStreamCipher.Companion.rotl8(x12 ^ (x01 += x06));
                x06 = JBChaChaStreamCipher.Companion.rotl7(x06 ^ (x11 += x12));
                x13 = JBChaChaStreamCipher.Companion.rotl16(x13 ^ (x02 += x07));
                x07 = JBChaChaStreamCipher.Companion.rotl12(x07 ^ (x08 += x13));
                x13 = JBChaChaStreamCipher.Companion.rotl8(x13 ^ (x02 += x07));
                x07 = JBChaChaStreamCipher.Companion.rotl7(x07 ^ (x08 += x13));
                x14 = JBChaChaStreamCipher.Companion.rotl16(x14 ^ (x03 += x04));
                x04 = JBChaChaStreamCipher.Companion.rotl12(x04 ^ (x09 += x14));
                x14 = JBChaChaStreamCipher.Companion.rotl8(x14 ^ (x03 += x04));
                x04 = JBChaChaStreamCipher.Companion.rotl7(x04 ^ (x09 += x14));
            }
            this.intToKeyStream(x00 + this.state[0], 0);
            this.intToKeyStream(x01 + this.state[1], 4);
            this.intToKeyStream(x02 + this.state[2], 8);
            this.intToKeyStream(x03 + this.state[3], 12);
            this.intToKeyStream(x04 + this.state[4], 16);
            this.intToKeyStream(x05 + this.state[5], 20);
            this.intToKeyStream(x06 + this.state[6], 24);
            this.intToKeyStream(x07 + this.state[7], 28);
            this.intToKeyStream(x08 + this.state[8], 32);
            this.intToKeyStream(x09 + this.state[9], 36);
            this.intToKeyStream(x10 + this.state[10], 40);
            this.intToKeyStream(x11 + this.state[11], 44);
            this.intToKeyStream(x12 + this.state[12], 48);
            this.intToKeyStream(x13 + this.state[13], 52);
            this.intToKeyStream(x14 + this.state[14], 56);
            this.intToKeyStream(x15 + this.state[15], 60);
        }

        /*
         * WARNING - void declaration
         */
        private final void updateState(byte[] bs, int off, int count) {
            int byteOffset = 0;
            int stateOffset = off;
            int n = count;
            for (int i = 0; i < n; ++i) {
                int it = i;
                int result = 0;
                int n2 = 3;
                boolean bl = false;
                while (n2 >= 0) {
                    void i2;
                    result <<= 8;
                    result |= bs[byteOffset + i2] & 0xFF;
                    --i2;
                }
                n2 = stateOffset;
                stateOffset = n2 + 1;
                this.state[n2] = result;
                byteOffset += 4;
            }
        }

        private final void intToKeyStream(int n, int off) {
            int shifted = n;
            int keyOffset = off;
            int n2 = 4;
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                int it = n3++;
                int n5 = keyOffset;
                keyOffset = n5 + 1;
                this.keyStream[n5] = (byte)shifted;
                shifted >>= 8;
            }
        }

        public JBChaChaStreamCipher(int rounds) {
            this.rounds = rounds;
            this.state = new int[16];
            this.keyStream = new byte[64];
            if (this.rounds <= 0 || (this.rounds & 1) != 0) {
                throw (Throwable)new IllegalArgumentException("'rounds' must be a positive, even number");
            }
        }

        public /* synthetic */ JBChaChaStreamCipher(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 20;
            }
            this(n);
        }

        public JBChaChaStreamCipher() {
            this(0, 1, null);
        }

        static {
            Companion = new Companion(null);
            TAU_SIGMA = Pack.littleEndianToInt((byte[])Strings.toByteArray((String)"expand 16-byte kexpand 32-byte k"), (int)0, (int)8);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/exodus/crypto/streamciphers/JBChaChaStreamCipherProvider$JBChaChaStreamCipher$Companion;", "", "()V", "CHACHA_IV_SIZE", "", "DEFAULT_ROUNDS", "STATE_SIZE", "TAU_SIGMA", "", "kotlin.jvm.PlatformType", "rotl12", "x", "rotl16", "rotl7", "rotl8", "xodus-crypto"})
        private static final class Companion {
            private final int rotl16(int x) {
                return x << 16 | x >>> 16;
            }

            private final int rotl12(int x) {
                return x << 12 | x >>> 20;
            }

            private final int rotl8(int x) {
                return x << 8 | x >>> 24;
            }

            private final int rotl7(int x) {
                return x << 7 | x >>> 25;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

