/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.SortEngine;
import org.jetbrains.annotations.NotNull;

public class InMemoryQuickSortOnInitIterable
extends SortEngine.InMemorySortIterable {
    public InMemoryQuickSortOnInitIterable(@NotNull Iterable<Entity> source, @NotNull Comparator<Entity> comparator) {
        super(source, comparator);
    }

    @Override
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private List<Entity> src;
            private Entity[] tmp;
            private int current;

            @Override
            public boolean hasNext() {
                if (this.src == null) {
                    this.init();
                }
                return this.current < this.src.size();
            }

            @Override
            public Entity next() {
                if (this.src == null) {
                    this.init();
                }
                if (this.current >= this.src.size()) {
                    throw new NoSuchElementException();
                }
                return this.src.get(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void init() {
                this.src = new ArrayList<Entity>();
                for (Entity entity : InMemoryQuickSortOnInitIterable.this.getSrc()) {
                    this.src.add(entity);
                }
                this.tmp = new Entity[this.src.size()];
                this.qsort(0, this.tmp.length - 1);
            }

            public void qsort(int left, int right) {
                if (left >= right) {
                    return;
                }
                Entity median = this.src.get((left + right) / 2);
                int i = left;
                int toRight = 0;
                ArrayList<Entity> medians = new ArrayList<Entity>();
                Comparator<Entity> comparator = InMemoryQuickSortOnInitIterable.this.getComparator();
                while (true) {
                    if (i <= right && comparator.compare(this.src.get(i), median) < 0) {
                        if (toRight + medians.size() > 0) {
                            this.src.set(i - toRight - medians.size(), this.src.get(i));
                        }
                        ++i;
                        continue;
                    }
                    if (i <= right) {
                        Entity entity = this.src.get(i);
                        if (comparator.compare(entity, median) == 0) {
                            medians.add(entity);
                        } else {
                            this.tmp[toRight++] = entity;
                        }
                        ++i;
                    }
                    if (i > right) break;
                }
                int current = i - toRight - medians.size();
                for (Entity e : medians) {
                    this.src.set(current++, e);
                }
                for (int k = 0; k < toRight; ++k) {
                    this.src.set(current++, this.tmp[k]);
                }
                this.qsort(left, right - toRight - medians.size());
                this.qsort(right - toRight + 1, right);
            }
        };
    }
}

