/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.SortEngine;
import org.jetbrains.annotations.NotNull;

public class InMemoryQuickSortTwoSidesIterable
extends SortEngine.InMemorySortIterable {
    public InMemoryQuickSortTwoSidesIterable(@NotNull Iterable<Entity> source, @NotNull Comparator<Entity> comparator) {
        super(source, comparator);
    }

    @Override
    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private List<Entity> src;
            private Entity[] tmp;
            private int current;

            @Override
            public boolean hasNext() {
                if (this.src == null) {
                    this.init();
                }
                return this.current < this.src.size();
            }

            @Override
            public Entity next() {
                if (this.src == null) {
                    this.init();
                }
                if (this.current >= this.src.size()) {
                    throw new NoSuchElementException();
                }
                return this.src.get(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void init() {
                this.src = new ArrayList<Entity>();
                for (Entity entity : InMemoryQuickSortTwoSidesIterable.this.getSrc()) {
                    this.src.add(entity);
                }
                this.tmp = new Entity[this.src.size()];
                this.qsort(0, this.tmp.length - 1);
            }

            public void qsort(int left, int right) {
                int k;
                if (left >= right) {
                    return;
                }
                Entity median = this.src.get((left + right) / 2);
                int i = left;
                int j = right;
                int toRight = 0;
                int toLeft = 0;
                ArrayList<Entity> leftMedians = new ArrayList<Entity>();
                ArrayList<Entity> rightMedians = new ArrayList<Entity>();
                Comparator<Entity> comparator = InMemoryQuickSortTwoSidesIterable.this.getComparator();
                while (true) {
                    if (i <= j && comparator.compare(this.src.get(i), median) < 0) {
                        if (toRight + leftMedians.size() > 0) {
                            this.src.set(i - toRight - leftMedians.size(), this.src.get(i));
                        }
                        ++i;
                        continue;
                    }
                    while (i <= j && comparator.compare(median, this.src.get(j)) < 0) {
                        if (toLeft + rightMedians.size() > 0) {
                            this.src.set(j + toLeft + rightMedians.size(), this.src.get(j));
                        }
                        --j;
                    }
                    if (i <= j) {
                        Entity leftEntity = this.src.get(i);
                        if (comparator.compare(leftEntity, median) == 0) {
                            leftMedians.add(leftEntity);
                        } else {
                            this.tmp[toRight++] = leftEntity;
                        }
                        ++i;
                    }
                    if (i <= j) {
                        Entity rightEntity = this.src.get(j);
                        if (comparator.compare(rightEntity, median) == 0) {
                            rightMedians.add(rightEntity);
                        } else {
                            this.tmp[right - toLeft++] = this.src.get(j);
                        }
                        --j;
                    }
                    if (i > j) break;
                }
                int current = i - toRight - leftMedians.size();
                for (int k2 = right - toLeft + 1; k2 <= right; ++k2) {
                    this.src.set(current++, this.tmp[k2]);
                }
                for (Entity e : leftMedians) {
                    this.src.set(current++, e);
                }
                for (k = rightMedians.size() - 1; k >= 0; --k) {
                    this.src.set(current++, (Entity)rightMedians.get(k));
                }
                for (k = 0; k < toRight; ++k) {
                    this.src.set(current++, this.tmp[k]);
                }
                this.qsort(left, i - toRight - leftMedians.size() + toLeft);
                this.qsort(current - toRight, right);
            }
        };
    }
}

