/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Selector;
import jetbrains.exodus.query.PriorityMapKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001-B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J+\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00028\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0096\u0002J\u0017\u0010'\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000f\u0010)\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u000f\u0010+\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010*J+\u0010,\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00028\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\"R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ljetbrains/exodus/query/PriorityMap;", "E", "Ljava/util/AbstractQueue;", "initialCapacity", "", "comparator", "Ljava/util/Comparator;", "", "", "valueGettter", "Ljetbrains/exodus/entitystore/Selector;", "(ILjava/util/Comparator;Ljetbrains/exodus/entitystore/Selector;)V", "data", "", "[Ljava/lang/Comparable;", "modCount", "queue", "[Ljava/lang/Object;", "<set-?>", "size", "getSize", "()I", "setSize", "(I)V", "add", "", "element", "(Ljava/lang/Object;)Z", "clear", "", "down", "key", "x", "v", "(ILjava/lang/Object;Ljava/lang/Comparable;)V", "grow", "minCapacity", "iterator", "", "offer", "e", "peek", "()Ljava/lang/Object;", "poll", "up", "Itr", "xodus-query"})
public final class PriorityMap<E>
extends AbstractQueue<E> {
    private Object[] queue;
    private Comparable<Object>[] data;
    private int size;
    private int modCount;
    private final Comparator<Comparable<Object>> comparator;
    private final Selector<E> valueGettter;

    public int getSize() {
        return this.size;
    }

    private void setSize(int n) {
        this.size = n;
    }

    private final void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + ((oldCapacity = this.queue.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        if (newCapacity - PriorityMapKt.access$getMaxArraySize$p() > 0) {
            newCapacity = PriorityMapKt.access$hugeCapacity(minCapacity);
        }
        Object[] objectArray = this.queue;
        PriorityMap priorityMap = this;
        Object[] objectArray2 = Arrays.copyOf(objectArray, newCapacity);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] objectArray3 = objectArray2;
        priorityMap.queue = objectArray3;
        objectArray = this.data;
        priorityMap = this;
        Object[] objectArray4 = Arrays.copyOf(objectArray, newCapacity);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray4, (String)"java.util.Arrays.copyOf(this, newSize)");
        objectArray3 = objectArray4;
        priorityMap.data = (Comparable[])objectArray3;
    }

    @Override
    public boolean add(E element) {
        return this.offer(element);
    }

    @Override
    public boolean offer(@Nullable E e) {
        if (e == null) {
            throw (Throwable)new NullPointerException();
        }
        int n = this.modCount;
        this.modCount = n + 1;
        int i = this.size();
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.setSize(i + 1);
        if (i == 0) {
            this.queue[0] = e;
            this.data[0] = this.valueGettter.select(e);
        } else {
            Comparable comparable = this.valueGettter.select(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"valueGettter.select(e)");
            this.up(i, e, comparable);
        }
        return true;
    }

    @Override
    @Nullable
    public E peek() {
        return (E)(this.size() == 0 ? null : this.queue[0]);
    }

    @Override
    public void clear() {
        int i;
        int n = this.modCount;
        this.modCount = n + 1;
        n = 0;
        int n2 = this.size();
        while (n < n2) {
            this.queue[i] = null;
            ++i;
        }
        n2 = this.size();
        for (i = 0; i < n2; ++i) {
            this.data[i] = null;
        }
        this.setSize(0);
    }

    @Override
    @Nullable
    public E poll() {
        if (this.size() == 0) {
            return null;
        }
        PriorityMap priorityMap = this;
        priorityMap.setSize(priorityMap.size() + -1);
        int s = priorityMap.size();
        int n = this.modCount;
        this.modCount = n + 1;
        Object result = this.queue[0];
        Object x = this.queue[s];
        this.queue[s] = null;
        Comparable<Object> v = this.data[s];
        this.data[s] = null;
        if (s != 0) {
            Comparable<Object> comparable = v;
            if (comparable == null) {
                Intrinsics.throwNpe();
            }
            this.down(0, x, comparable);
        }
        return (E)result;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Itr();
    }

    private final void up(int key, E x, Comparable<Object> v) {
        int parent;
        Comparable<Object> ev;
        int k = key;
        while (k > 0 && this.comparator.compare(v, ev = this.data[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = this.queue[parent];
            this.data[k] = ev;
            k = parent;
        }
        this.queue[k] = x;
        this.data[k] = v;
    }

    private final void down(int key, E x, Comparable<Object> v) {
        int k = key;
        int half = this.size() >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Comparable<Object> cv = this.data[child];
            int right = child + 1;
            if (right < this.size() && this.comparator.compare(cv, this.data[right]) > 0) {
                child = right;
                cv = this.data[child];
            }
            if (this.comparator.compare(v, cv) <= 0) break;
            this.data[k] = cv;
            this.queue[k] = this.queue[child];
            k = child;
        }
        this.queue[k] = x;
        this.data[k] = v;
    }

    public PriorityMap(int initialCapacity, @NotNull Comparator<Comparable<Object>> comparator, @NotNull Selector<E> valueGettter) {
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        Intrinsics.checkParameterIsNotNull(valueGettter, (String)"valueGettter");
        this.comparator = comparator;
        this.valueGettter = valueGettter;
        this.queue = initialCapacity <= 0 ? PriorityMapKt.access$getNoQueue$p() : new Object[initialCapacity];
        this.data = initialCapacity <= 0 ? PriorityMapKt.access$getNoData$p() : new Comparable[initialCapacity];
    }

    public static final /* synthetic */ int access$getSize$p(PriorityMap $this) {
        return $this.size();
    }

    public static final /* synthetic */ void access$setSize$p(PriorityMap $this, int n) {
        $this.setSize(n);
    }

    public static final /* synthetic */ void access$setModCount$p(PriorityMap $this, int n) {
        $this.modCount = n;
    }

    public static final /* synthetic */ void access$setQueue$p(PriorityMap $this, @NotNull Object[] objectArray) {
        $this.queue = objectArray;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u000e\u0010\r\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0011"}, d2={"Ljetbrains/exodus/query/PriorityMap$Itr;", "", "(Ljetbrains/exodus/query/PriorityMap;)V", "cursor", "", "expectedModCount", "forgetMeNot", "Ljava/util/ArrayDeque;", "lastRet", "lastRetElt", "Ljava/lang/Object;", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "xodus-query"})
    private final class Itr
    implements Iterator<E>,
    KMutableIterator {
        private int cursor;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot;
        private E lastRetElt;
        private int expectedModCount;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            if (this.cursor < PriorityMap.this.size()) return true;
            if (this.forgetMeNot == null) return false;
            ArrayDeque arrayDeque = this.forgetMeNot;
            if (arrayDeque == null) {
                Intrinsics.throwNpe();
            }
            if (arrayDeque.isEmpty()) return false;
            return true;
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityMap.this.modCount) {
                throw (Throwable)new ConcurrentModificationException();
            }
            if (this.cursor < PriorityMap.this.size()) {
                int index;
                int n = this.cursor;
                this.cursor = n + 1;
                this.lastRet = index = n;
                return PriorityMap.this.queue[index];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                ArrayDeque arrayDeque = this.forgetMeNot;
                if (arrayDeque == null) {
                    Intrinsics.throwNpe();
                }
                Object e = this.lastRetElt = arrayDeque.poll();
                if (e != null) {
                    Object e2;
                    Object it = e2 = e;
                    return it;
                }
            }
            throw (Throwable)new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }

        public Itr() {
            this.expectedModCount = PriorityMap.this.modCount;
        }
    }
}

