/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.Explainer;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.BinaryOperator;
import jetbrains.exodus.query.GetAll;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.OptimizedTreesCache;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Root;
import jetbrains.exodus.query.Sort;
import jetbrains.exodus.query.SortEngine;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.StaticTypedEntityIterable;
import jetbrains.exodus.query.UnaryNode;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeKeepingEntityIterable
extends StaticTypedEntityIterable {
    private static final Logger logger = LoggerFactory.getLogger(TreeKeepingEntityIterable.class);
    private final Iterable<Entity> instance;
    private final NodeBase sourceTree;
    private NodeBase optimizedTree;
    private Sorts sorts;
    private Object origin;
    private String strippedStacktrace;
    String annotatedTree;
    private final boolean isExplainOn;

    public TreeKeepingEntityIterable(@Nullable Iterable<Entity> entityIterable, @NotNull String entityType, @NotNull NodeBase queryTree, @Nullable String leftChildPresentation, @Nullable String rightChildPresentation, @NotNull QueryEngine queryEngine) {
        super(queryEngine);
        String entityIterableType;
        Explainer explainer = queryEngine.getPersistentStore().getExplainer();
        this.isExplainOn = explainer.isExplainOn();
        this.origin = explainer.genOrigin();
        if (this.isExplainOn) {
            this.strippedStacktrace = Explainer.stripStackTrace((Throwable)new Throwable());
        }
        if (entityIterable instanceof StaticTypedEntityIterable && !entityType.equals(entityIterableType = ((StaticTypedEntityIterable)entityIterable).getEntityType()) && Utils.isTypeOf(entityIterableType, entityType, queryEngine.getModelMetaData())) {
            entityType = entityIterableType;
        }
        if (this.isExplainOn) {
            if (queryTree instanceof BinaryOperator && (leftChildPresentation != null || rightChildPresentation != null)) {
                BinaryOperator binaryOperator = (BinaryOperator)queryTree;
                if (leftChildPresentation == null) {
                    leftChildPresentation = binaryOperator.getLeft().toString();
                }
                if (rightChildPresentation == null) {
                    rightChildPresentation = binaryOperator.getRight().toString();
                }
                this.annotatedTree = "at " + this.strippedStacktrace + '\n' + binaryOperator.getClass().getSimpleName() + ('\n' + leftChildPresentation + '\n' + rightChildPresentation).replace("\n", "\n  ");
            } else {
                this.annotatedTree = "at " + this.strippedStacktrace + '\n' + queryTree;
            }
        }
        if (entityIterable instanceof TreeKeepingEntityIterable) {
            TreeKeepingEntityIterable instanceTreeIt = (TreeKeepingEntityIterable)entityIterable;
            NodeBase instanceTree = instanceTreeIt.sourceTree;
            if (queryTree instanceof Sort && ((UnaryNode)queryTree).getChild().equals(NodeFactory.all())) {
                this.sourceTree = queryTree.getClone();
                this.sourceTree.replaceChild(((UnaryNode)this.sourceTree).getChild(), instanceTree.getClone());
                if (this.isExplainOn) {
                    this.annotatedTree = "at " + this.strippedStacktrace + '\n' + this.sourceTree.getClass().getSimpleName() + ("\n" + (instanceTreeIt.annotatedTree != null ? instanceTreeIt.annotatedTree : instanceTree)).replace("\n", "\n  ");
                }
            } else {
                NodeBase nodeBase = this.sourceTree = instanceTree instanceof GetAll ? queryTree : new And(instanceTree.getClone(), queryTree);
                if (this.isExplainOn && !(instanceTree instanceof GetAll)) {
                    this.annotatedTree = "at " + this.strippedStacktrace + "\nAnd" + ("\n" + (instanceTreeIt.annotatedTree != null ? instanceTreeIt.annotatedTree : instanceTree) + '\n' + this.annotatedTree).replace("\n", "\n  ");
                }
            }
            this.instance = instanceTreeIt.instance;
        } else {
            this.instance = entityIterable;
            this.sourceTree = queryTree;
        }
        this.entityType = entityType;
        this.optimizedTree = null;
    }

    public TreeKeepingEntityIterable(@Nullable Iterable<Entity> entityIterable, @NotNull String entityType, @NotNull NodeBase queryTree, @NotNull QueryEngine queryEngine) {
        this(entityIterable, entityType, queryTree, null, null, queryEngine);
    }

    @Override
    public Iterable<Entity> instantiate() {
        Iterable<Entity> result;
        this.optimize();
        if (this.instance == null) {
            result = this.instantiateForWholeHierarchy();
        } else if (this.optimizedTree instanceof GetAll) {
            result = this.instance;
        } else {
            TreeKeepingEntityIterable tkei = new TreeKeepingEntityIterable(null, this.entityType, this.optimizedTree.getClone(), this.queryEngine);
            tkei.optimizedTree = this.optimizedTree;
            result = this.queryEngine.toEntityIterable(this.queryEngine.intersect(this.instance, tkei));
        }
        if (this.sorts != null) {
            result = this.sorts.apply(this.entityType, result, this.queryEngine);
        }
        if (result == null) {
            result = this.instantiateForWholeHierarchy();
        }
        if (this.isExplainOn) {
            EntityIterableBase entityIterable;
            Iterable<Entity> explained = result;
            while (explained instanceof SortEngine.InMemorySortIterable) {
                explained = ((SortEngine.InMemorySortIterable)explained).getSrc();
            }
            if (explained instanceof EntityIterableBase && (entityIterable = ((EntityIterableBase)explained).getSource()) != EntityIterableBase.EMPTY) {
                PersistentEntityStoreImpl store = this.queryEngine.getPersistentStore();
                Explainer explainer = store.getExplainer();
                boolean explainForcedForThread = Explainer.isExplainForcedForThread();
                if (!explainForcedForThread) {
                    explainer.start(this.origin);
                }
                entityIterable.setOrigin(this.origin);
                explainer.explain(this.origin, "initial tree", (Object)this.annotatedTree);
                explainer.explain(this.origin, "optimized tree", (Object)this.optimizedTree);
                if (!explainForcedForThread) {
                    for (Entity entity : result) {
                        explainer.explain(this.origin, "iterable advances");
                    }
                    explainer.log(this.origin);
                }
            }
        }
        return result;
    }

    private Iterable<Entity> instantiateForWholeHierarchy() {
        return this.instantiateForWholeHierarchy(this.entityType, this.optimizedTree);
    }

    private Iterable<Entity> instantiateForWholeHierarchy(String entityType, NodeBase ast) {
        Object result;
        ModelMetaData mmd = this.queryEngine.getModelMetaData();
        EntityMetaData emd = mmd == null ? null : mmd.getEntityMetaData(entityType);
        Object object = result = emd != null && emd.isAbstract() ? EntityIterableBase.EMPTY : ast.getClone().instantiate(entityType, this.queryEngine, mmd);
        if (emd != null && !ast.polymorphic()) {
            for (String subType : emd.getSubTypes()) {
                if (Utils.getUnionSubtypes()) {
                    result = this.queryEngine.unionAdjusted((Iterable<Entity>)result, this.instantiateForWholeHierarchy(subType, ast));
                    continue;
                }
                result = this.queryEngine.concatAdjusted((Iterable<Entity>)result, this.instantiateForWholeHierarchy(subType, ast));
            }
        }
        return this.queryEngine.adjustEntityIterable((Iterable<Entity>)result);
    }

    public void optimize() {
        if (this.optimizedTree == null) {
            OptimizedTreesCache.OptimizedTreeAndSorts optimized;
            boolean sourceCanBeCached = this.sourceTree.canBeCached();
            if (sourceCanBeCached && (optimized = OptimizedTreesCache.get().findOptimized(this.sourceTree)) != null) {
                this.optimizedTree = optimized.getOptimizedTree();
                this.sorts = optimized.getSorts();
            } else {
                long delta;
                long start = System.currentTimeMillis();
                this.sorts = new Sorts();
                Root root = new Root(this.sourceTree.getClone());
                for (OptimizationPlan rules : OptimizationPlan.PLANS) {
                    root.optimize(this.sorts, rules);
                }
                root.cleanSorts(this.sorts);
                this.optimizedTree = root.getChild();
                if (sourceCanBeCached && this.sorts.canBeCached()) {
                    OptimizedTreesCache.get().cacheOptimized(this.sourceTree, this.optimizedTree, this.sorts);
                }
                if ((delta = System.currentTimeMillis() - start) > 1L) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Optimize tree in [" + delta + " ms]");
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("---------------------------------------------------");
                        logger.trace("Source tree: ");
                        logger.trace(this.sourceTree.toString());
                        logger.trace("---------------------------------------------------");
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Optimized tree: ");
                    logger.trace(this.optimizedTree.toString());
                    logger.trace("---------------------------------------------------");
                }
            }
        }
    }

    public Iterable<Entity> getInstance() {
        return this.instance;
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }

    public NodeBase getTree() {
        return this.sourceTree;
    }

    public NodeBase getOptimizedTree() {
        return this.optimizedTree;
    }

    public Sorts getSorts() {
        return this.sorts;
    }
}

