/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.query.metadata.AssociationEndCardinality;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.AssociationEndMetaDataImpl;
import jetbrains.exodus.query.metadata.AssociationEndType;
import jetbrains.exodus.query.metadata.AssociationMetaData;
import jetbrains.exodus.query.metadata.AssociationMetaDataImpl;
import jetbrains.exodus.query.metadata.AssociationType;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.EntityMetaDataImpl;
import jetbrains.exodus.query.metadata.ModelMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMetaDataImpl
implements ModelMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ModelMetaDataImpl.class);
    private static final boolean LOG_RESET = Boolean.getBoolean("jetbrains.exodus.query.metadata.logReset");
    private final Set<EntityMetaData> entityMetaDatas = new HashSet();
    private final Map<String, AssociationMetaData> associationMetaDatas = new ConcurrentHashMap<String, AssociationMetaData>();
    private volatile Map<String, EntityMetaData> typeToEntityMetaDatas = null;

    public void init() {
        this.reset();
        this.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntityMetaDatas(@NotNull Set<EntityMetaData> entityMetaDatas) {
        Set<EntityMetaData> set = this.entityMetaDatas;
        synchronized (set) {
            this.entityMetaDatas.clear();
            this.entityMetaDatas.addAll(entityMetaDatas);
            for (EntityMetaData emd : entityMetaDatas) {
                ((EntityMetaDataImpl)emd).setModelMetaData(this);
            }
            this.reset();
        }
    }

    public void setAssociationMetaDatas(Set<AssociationMetaData> associationMetaDatas) {
        for (AssociationMetaData amd : associationMetaDatas) {
            this.associationMetaDatas.put(((AssociationMetaDataImpl)amd).getFullName(), amd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityMetaData(@NotNull EntityMetaData emd) {
        Set<EntityMetaData> set = this.entityMetaDatas;
        synchronized (set) {
            this.entityMetaDatas.add(emd);
            ((EntityMetaDataImpl)emd).setModelMetaData(this);
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        if (LOG_RESET) {
            logger.info("ModelMetaDataImpl#reset() invoked in thread " + Thread.currentThread(), new Throwable());
        }
        Set<EntityMetaData> set = this.entityMetaDatas;
        synchronized (set) {
            this.typeToEntityMetaDatas = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, EntityMetaData> prepare() {
        HashMap result = this.typeToEntityMetaDatas;
        if (result != null) {
            return result;
        }
        Set<EntityMetaData> set = this.entityMetaDatas;
        synchronized (set) {
            result = this.typeToEntityMetaDatas;
            if (result != null) {
                return result;
            }
            result = new HashMap();
            for (EntityMetaData emd : this.entityMetaDatas) {
                ((EntityMetaDataImpl)emd).reset();
                String type = emd.getType();
                if (result.get(type) != null) {
                    throw new IllegalArgumentException("Duplicate entity [" + type + ']');
                }
                result.put(type, emd);
            }
            this.typeToEntityMetaDatas = result;
            for (EntityMetaData emd : this.entityMetaDatas) {
                EntityMetaDataImpl impl = (EntityMetaDataImpl)emd;
                Set<AssociationEndMetaData> ends = impl.getExternalAssociationEnds();
                if (ends == null) continue;
                for (AssociationEndMetaData aemd : ends) {
                    AssociationEndMetaDataImpl endImpl = (AssociationEndMetaDataImpl)aemd;
                    endImpl.resolve(this, this.associationMetaDatas.get(endImpl.getAssociationMetaDataName()));
                }
            }
            for (EntityMetaData emd : this.entityMetaDatas) {
                HashSet ends = ((EntityMetaDataImpl)emd).getExternalAssociationEnds();
                boolean wasNull = ends == null;
                String superType = emd.getSuperType();
                while (superType != null) {
                    EntityMetaData parent = (EntityMetaData)result.get(superType);
                    Set<AssociationEndMetaData> parentEnds = ((EntityMetaDataImpl)parent).getExternalAssociationEnds();
                    if (parentEnds != null) {
                        if (ends == null) {
                            ends = new HashSet(parentEnds);
                        } else {
                            ends.addAll(parentEnds);
                        }
                    }
                    superType = parent.getSuperType();
                }
                if (!wasNull || ends == null) continue;
                ((EntityMetaDataImpl)emd).setAssociationEnds((Collection<AssociationEndMetaData>)ends);
            }
            for (EntityMetaData emd : this.entityMetaDatas) {
                String superType = emd.getSuperType();
                if (superType != null) {
                    this.addSubTypeToMetaData((Map<String, EntityMetaData>)result, emd, superType);
                }
                for (String iFaceType : emd.getInterfaceTypes()) {
                    this.addSubTypeToMetaData((Map<String, EntityMetaData>)result, emd, iFaceType);
                }
                ArrayList<String> thisAndSuperTypes = new ArrayList<String>();
                EntityMetaData data = emd;
                String t = data.getType();
                do {
                    thisAndSuperTypes.add(t);
                    thisAndSuperTypes.addAll(data.getInterfaceTypes());
                } while ((t = (data = (EntityMetaData)result.get(t)).getSuperType()) != null);
                ((EntityMetaDataImpl)emd).setThisAndSuperTypes(thisAndSuperTypes);
            }
            return result;
        }
    }

    private void addSubTypeToMetaData(Map<String, EntityMetaData> typeToEntityMetaDatas, EntityMetaData emd, String superType) {
        EntityMetaData superEmd = typeToEntityMetaDatas.get(superType);
        if (superEmd == null) {
            throw new IllegalArgumentException("No entity metadata for super type [" + superType + "]");
        }
        ((EntityMetaDataImpl)superEmd).addSubType(emd.getType());
    }

    @Override
    @Nullable
    public EntityMetaData getEntityMetaData(@NotNull String entityType) {
        return this.prepare().get(entityType);
    }

    @Override
    @NotNull
    public Iterable<EntityMetaData> getEntitiesMetaData() {
        return this.prepare().values();
    }

    public boolean hasAssociation(String sourceEntityName, String targetEntityName, String sourceName) {
        return this.associationMetaDatas.containsKey(ModelMetaDataImpl.getUniqueAssociationName(sourceEntityName, targetEntityName, sourceName));
    }

    @Override
    public AssociationMetaData addAssociation(String sourceEntityName, String targetEntityName, AssociationType type, String sourceName, AssociationEndCardinality sourceCardinality, boolean sourceCascadeDelete, boolean sourceClearOnDelete, boolean sourceTargetCascadeDelete, boolean sourceTargetClearOnDelete, String targetName, AssociationEndCardinality targetCardinality, boolean targetCascadeDelete, boolean targetClearOnDelete, boolean targetTargetCascadeDelete, boolean targetTargetClearOnDelete) {
        EntityMetaDataImpl source = (EntityMetaDataImpl)this.getEntityMetaData(sourceEntityName);
        if (source == null) {
            throw new IllegalArgumentException("Can't find entity " + sourceEntityName);
        }
        EntityMetaDataImpl target = (EntityMetaDataImpl)this.getEntityMetaData(targetEntityName);
        if (target == null) {
            throw new IllegalArgumentException("Can't find entity " + targetEntityName);
        }
        AssociationEndType sourceType = null;
        AssociationEndType targetType = null;
        AssociationMetaDataImpl amd = new AssociationMetaDataImpl();
        amd.setType(type);
        String fullName = ModelMetaDataImpl.getUniqueAssociationName(sourceEntityName, targetEntityName, sourceName);
        amd.setFullName(fullName);
        this.associationMetaDatas.put(fullName, amd);
        switch (type) {
            case Directed: {
                sourceType = AssociationEndType.DirectedAssociationEnd;
                break;
            }
            case Undirected: {
                sourceType = AssociationEndType.UndirectedAssociationEnd;
                targetType = AssociationEndType.UndirectedAssociationEnd;
                break;
            }
            case Aggregation: {
                sourceType = AssociationEndType.ParentEnd;
                targetType = AssociationEndType.ChildEnd;
            }
        }
        AssociationEndMetaDataImpl sourceEnd = new AssociationEndMetaDataImpl(amd, sourceName, target, sourceCardinality, sourceType, sourceCascadeDelete, sourceClearOnDelete, sourceTargetCascadeDelete, sourceTargetClearOnDelete);
        this.addAssociationEndMetaDataToEntityTypeSubtree(this.prepare(), source, sourceEnd);
        if (type != AssociationType.Directed) {
            AssociationEndMetaDataImpl targetEnd = new AssociationEndMetaDataImpl(amd, targetName, source, targetCardinality, targetType, targetCascadeDelete, targetClearOnDelete, targetTargetCascadeDelete, targetTargetClearOnDelete);
            this.addAssociationEndMetaDataToEntityTypeSubtree(this.prepare(), target, targetEnd);
        }
        return amd;
    }

    private void addAssociationEndMetaDataToEntityTypeSubtree(Map<String, EntityMetaData> typeToEntityMetaDatas, EntityMetaDataImpl emdi, AssociationEndMetaData aemd) {
        emdi.addAssociationEndMetaData(aemd);
        for (String subType : emdi.getAllSubTypes()) {
            ((EntityMetaDataImpl)typeToEntityMetaDatas.get(subType)).addAssociationEndMetaData(aemd);
        }
    }

    @Override
    public AssociationMetaData removeAssociation(String entityName, String associationName) {
        Map<String, EntityMetaData> typeToEntityMetaDatas = this.prepare();
        EntityMetaDataImpl source = (EntityMetaDataImpl)this.getEntityMetaData(entityName);
        AssociationEndMetaData aemd = this.removeAssociationEndMetaDataFromEntityTypeSubtree(typeToEntityMetaDatas, source, associationName);
        AssociationMetaData amd = aemd.getAssociationMetaData();
        EntityMetaDataImpl target = (EntityMetaDataImpl)aemd.getOppositeEntityMetaData();
        if (amd.getType() != AssociationType.Directed) {
            String oppositeAssociationName = amd.getOppositeEnd(aemd).getName();
            this.removeAssociationEndMetaDataFromEntityTypeSubtree(typeToEntityMetaDatas, target, oppositeAssociationName);
        }
        this.associationMetaDatas.remove(ModelMetaDataImpl.getUniqueAssociationName(entityName, target.getType(), associationName));
        return amd;
    }

    private AssociationEndMetaData removeAssociationEndMetaDataFromEntityTypeSubtree(Map<String, EntityMetaData> typeToEntityMetaDatas, EntityMetaDataImpl emdi, String associationName) {
        AssociationEndMetaData removedEndMetaData = emdi.removeAssociationEndMetaData(associationName);
        for (String subType : emdi.getAllSubTypes()) {
            ((EntityMetaDataImpl)typeToEntityMetaDatas.get(subType)).removeAssociationEndMetaData(associationName);
        }
        return removedEndMetaData;
    }

    private static String getUniqueAssociationName(String sourceEntityName, String targetEntityName, String sourceName) {
        return sourceEntityName + '.' + sourceName + '-' + targetEntityName;
    }
}

