/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.gaprest.doc.model.generator;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.youtrack.gaprest.doc.model.GDoc;
import jetbrains.youtrack.gaprest.doc.model.GEntityTreeKt;
import jetbrains.youtrack.gaprest.doc.model.GEntityType;
import jetbrains.youtrack.gaprest.doc.model.GEntityTypeTreeNode;
import jetbrains.youtrack.gaprest.doc.model.GHttpMethod;
import jetbrains.youtrack.gaprest.doc.model.GMethodInfo;
import jetbrains.youtrack.gaprest.doc.model.GResource;
import jetbrains.youtrack.gaprest.doc.model.GResourceTreeKt;
import jetbrains.youtrack.gaprest.doc.model.GResourceTreeNode;
import jetbrains.youtrack.gaprest.doc.model.GType;
import jetbrains.youtrack.gaprest.doc.model.GapDocStringBuilder;
import jetbrains.youtrack.gaprest.doc.model.GapDocStringBuilderKt;
import jetbrains.youtrack.gaprest.doc.model.ModelCollector;
import jetbrains.youtrack.gaprest.doc.model.generator.GEntityGenerator;
import jetbrains.youtrack.gaprest.doc.model.generator.GResourceGenerator;
import jetbrains.youtrack.gaprest.doc.model.generator.StardustGenerator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00170\n2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/gaprest/doc/model/generator/StardustGenerator;", "Ljetbrains/youtrack/gaprest/doc/model/generator/GEntityGenerator;", "Ljetbrains/youtrack/gaprest/doc/model/generator/GResourceGenerator;", "()V", "generate", "", "types", "", "Ljetbrains/youtrack/gaprest/doc/model/GType;", "resources", "", "Ljetbrains/youtrack/gaprest/doc/model/GResource;", "generatedArtifactsRoot", "", "generateDoc", "resourceTree", "Ljetbrains/youtrack/gaprest/doc/model/GEntityTypeTreeNode;", "dest", "Ljava/io/File;", "Ljetbrains/youtrack/gaprest/doc/model/GResourceTreeNode;", "generateEntityDoc", "node", "generateIndex", "Lkotlin/Pair;", "generateOperationsDoc", "parentResourcePath", "generateResourceDoc", "generateToc", "entityTypeTree", "Companion", "youtrack-gap-doc"})
public final class StardustGenerator
implements GEntityGenerator,
GResourceGenerator {
    public static final Companion Companion = new Companion(null);

    public final void generate(@NotNull Collection<? extends GType> types, @NotNull List<? extends GResource> resources, @NotNull String generatedArtifactsRoot) {
        Iterable $receiver$iv;
        File $receiver$iv$iv;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull((Object)generatedArtifactsRoot, (String)"generatedArtifactsRoot");
        Iterable iterable = $receiver$iv2 = (Iterable)types;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof GEntityType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entityTypes = (List)destination$iv$iv;
        Companion.getLogger().info((Function0)new Function0<String>(entityTypes){
            final /* synthetic */ List $entityTypes;

            @NotNull
            public final String invoke() {
                return "About to generate docs for " + this.$entityTypes.size() + " entity types";
            }
            {
                this.$entityTypes = list;
                super(0);
            }
        });
        File $this$apply = $receiver$iv$iv = new File(generatedArtifactsRoot);
        boolean bl = false;
        if ($this$apply.exists()) {
            if ($this$apply.isDirectory()) {
                FilesKt.deleteRecursively((File)$this$apply);
            } else {
                throw (Throwable)new IllegalArgumentException($this$apply.getAbsolutePath() + " is not a directory");
            }
        }
        Files.createDirectories($this$apply.toPath(), new FileAttribute[0]);
        File dest = $receiver$iv$iv;
        GResourceTreeNode resourceTree = GResourceTreeKt.generateResourceTree(resources);
        GEntityTypeTreeNode entityTypeTree = GEntityTreeKt.generateEntityTree(entityTypes);
        this.generateToc(entityTypeTree, resourceTree, dest);
        this.generateDoc(entityTypeTree, dest);
        Iterable iterable2 = $receiver$iv = (Iterable)this.generateIndex(resourceTree);
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string = (String)it.getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
        this.generateDoc(resourceTree, dest);
    }

    private final void generateDoc(GEntityTypeTreeNode resourceTree, File dest) {
        Function1<GEntityTypeTreeNode, Unit> $fun$dfs$1 = new Function1<GEntityTypeTreeNode, Unit>(this, dest){
            final /* synthetic */ StardustGenerator this$0;
            final /* synthetic */ File $dest;

            public final void invoke(@NotNull GEntityTypeTreeNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                StardustGenerator.access$generateEntityDoc(this.this$0, node, this.$dest);
                Iterable $receiver$iv = node.getChildren();
                for (T element$iv : $receiver$iv) {
                    GEntityTypeTreeNode it = (GEntityTypeTreeNode)element$iv;
                    boolean bl = false;
                    this.invoke(it);
                }
            }
            {
                this.this$0 = stardustGenerator;
                this.$dest = file;
                super(1);
            }
        };
        $fun$dfs$1.invoke(resourceTree);
    }

    private final void generateEntityDoc(GEntityTypeTreeNode node, File dest) {
        Object object;
        GEntityType gEntityType = node.getWrapped();
        if (gEntityType == null) {
            return;
        }
        GEntityType type = gEntityType;
        Object $this$apply = object = new File(dest, this.getHref(type));
        boolean bl = false;
        ((File)$this$apply).createNewFile();
        File file = object;
        $this$apply = object = new FileWriter(file);
        boolean bl2 = false;
        ((Writer)$this$apply).write(this.generateDoc(type));
        ((OutputStreamWriter)$this$apply).close();
    }

    private final List<Pair<String, GResource>> generateIndex(GResourceTreeNode resourceTree) {
        List list;
        generateIndex.1 $fun$append$1 = generateIndex.1.INSTANCE;
        List $this$apply = list = (List)new ArrayList();
        boolean bl = false;
        generateIndex.1.INSTANCE.invoke($this$apply, resourceTree, "");
        return list;
    }

    private final void generateDoc(GResourceTreeNode resourceTree, File dest) {
        Function2<String, GResourceTreeNode, Unit> $fun$dfs$2 = new Function2<String, GResourceTreeNode, Unit>(this, dest){
            final /* synthetic */ StardustGenerator this$0;
            final /* synthetic */ File $dest;

            public final void invoke(@NotNull String parentResourcePath, @NotNull GResourceTreeNode node) {
                Object object;
                block4: {
                    block3: {
                        GResource gResource;
                        Intrinsics.checkParameterIsNotNull((Object)parentResourcePath, (String)"parentResourcePath");
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        StardustGenerator.access$generateResourceDoc(this.this$0, node, parentResourcePath, this.$dest);
                        StardustGenerator.access$generateOperationsDoc(this.this$0, node, parentResourcePath, this.$dest);
                        object = node.getResource();
                        if (object == null) break block3;
                        GResource it = gResource = object;
                        boolean bl = false;
                        object = parentResourcePath + '/' + this.this$0.getRelativePathWithId(it);
                        if (object != null) break block4;
                    }
                    object = parentResourcePath;
                }
                Object resourcePath = object;
                Iterable $receiver$iv = node.getChildren();
                for (T element$iv : $receiver$iv) {
                    GResourceTreeNode it = (GResourceTreeNode)element$iv;
                    boolean bl = false;
                    this.invoke((String)resourcePath, it);
                }
            }
            {
                this.this$0 = stardustGenerator;
                this.$dest = file;
                super(2);
            }
        };
        $fun$dfs$2.invoke("/api", resourceTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateResourceDoc(GResourceTreeNode node, String parentResourcePath, File dest) {
        GResource gResource = node.getResource();
        if (gResource == null) {
            return;
        }
        GResource resource = gResource;
        Object object = new File(dest, this.toResourceId(resource, parentResourcePath) + ".xml");
        File $this$apply = object;
        boolean bl = false;
        $this$apply.createNewFile();
        File resourceFile = object;
        object = new FileWriter(resourceFile);
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)object;
            boolean bl2 = false;
            it.write(this.generateDoc(resource, parentResourcePath, false, node.getUnique()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateOperationsDoc(GResourceTreeNode node, String parentResourcePath, File dest) {
        GResource gResource = node.getResource();
        if (gResource == null) {
            return;
        }
        GResource resource = gResource;
        if (!this.getHasEntityMethods(resource)) {
            return;
        }
        Object object = new File(dest, this.toOperationsId(resource, parentResourcePath) + ".xml");
        File $this$apply = object;
        boolean bl = false;
        $this$apply.createNewFile();
        File operationsFile = object;
        object = new FileWriter(operationsFile);
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)object;
            boolean bl2 = false;
            it.write(this.generateDoc(resource, parentResourcePath, true, node.getUnique()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateToc(GEntityTypeTreeNode entityTypeTree, GResourceTreeNode resourceTree, File dest) {
        boolean $i$f$buildGapDoc = false;
        Object object = new GapDocStringBuilder();
        GapDocStringBuilder $this$buildGapDoc = object;
        boolean bl = false;
        $this$buildGapDoc.unaryPlus("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        $this$buildGapDoc.unaryPlus("<!DOCTYPE topic SYSTEM \"http://helpserver.labs.intellij.net/help/html-entities.dtd\">");
        GapDocStringBuilderKt.productProfile$default($this$buildGapDoc, "ytr", "YouTrack REST API Reference", null, (Function1)new Function1<GapDocStringBuilder, Unit>(this, entityTypeTree, resourceTree){
            final /* synthetic */ StardustGenerator this$0;
            final /* synthetic */ GEntityTypeTreeNode $entityTypeTree$inlined;
            final /* synthetic */ GResourceTreeNode $resourceTree$inlined;
            {
                this.this$0 = stardustGenerator;
                this.$entityTypeTree$inlined = gEntityTypeTreeNode;
                this.$resourceTree$inlined = gResourceTreeNode;
                super(1);
            }

            public final void invoke(@NotNull GapDocStringBuilder $this$productProfile) {
                Intrinsics.checkParameterIsNotNull((Object)$this$productProfile, (String)"$receiver");
                this.this$0.generateEntityToc($this$productProfile, this.$entityTypeTree$inlined);
                this.this$0.generateResourceToc($this$productProfile, this.$resourceTree$inlined);
            }
        }, 4, null);
        String tocBuilder = ((GapDocStringBuilder)object).toString();
        Object $this$apply = object = new File(dest, "ytr.tree");
        boolean bl2 = false;
        ((File)$this$apply).createNewFile();
        Object tocFile = object;
        object = new FileWriter((File)tocFile);
        Throwable throwable = null;
        try {
            FileWriter it = (FileWriter)object;
            boolean bl3 = false;
            it.write(tocBuilder);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public String generateDoc(@NotNull GEntityType $this$generateDoc) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateDoc, (String)"$this$generateDoc");
        return GEntityGenerator.DefaultImpls.generateDoc(this, $this$generateDoc);
    }

    @Override
    @NotNull
    public String generateDoc(@NotNull GResource $this$generateDoc, @NotNull String parentResourcePath, boolean asOperationsContainer, boolean unique) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateDoc, (String)"$this$generateDoc");
        Intrinsics.checkParameterIsNotNull((Object)parentResourcePath, (String)"parentResourcePath");
        return GResourceGenerator.DefaultImpls.generateDoc(this, $this$generateDoc, parentResourcePath, asOperationsContainer, unique);
    }

    @Override
    @NotNull
    public String getId(@NotNull GType $this$id) {
        Intrinsics.checkParameterIsNotNull((Object)$this$id, (String)"$this$id");
        return GEntityGenerator.DefaultImpls.getId(this, $this$id);
    }

    @Override
    @NotNull
    public String getHref(@NotNull GType $this$href) {
        Intrinsics.checkParameterIsNotNull((Object)$this$href, (String)"$this$href");
        return GEntityGenerator.DefaultImpls.getHref(this, $this$href);
    }

    @Override
    @NotNull
    public String getIdPlaceholder(@NotNull GEntityType $this$idPlaceholder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$idPlaceholder, (String)"$this$idPlaceholder");
        return GEntityGenerator.DefaultImpls.getIdPlaceholder(this, $this$idPlaceholder);
    }

    @Override
    public void generateEntityToc(@NotNull GapDocStringBuilder $this$generateEntityToc, @NotNull GEntityTypeTreeNode entityTree) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateEntityToc, (String)"$this$generateEntityToc");
        Intrinsics.checkParameterIsNotNull((Object)entityTree, (String)"entityTree");
        GEntityGenerator.DefaultImpls.generateEntityToc(this, $this$generateEntityToc, entityTree);
    }

    @Override
    public void chapterOfEntity(@NotNull GapDocStringBuilder $this$chapterOfEntity, @NotNull GEntityType entityType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$chapterOfEntity, (String)"$this$chapterOfEntity");
        Intrinsics.checkParameterIsNotNull((Object)entityType, (String)"entityType");
        GEntityGenerator.DefaultImpls.chapterOfEntity(this, $this$chapterOfEntity, entityType);
    }

    @Override
    public void buildDoc(@NotNull GapDocStringBuilder $this$buildDoc, @NotNull Function1<? super GapDocStringBuilder, ? extends Object> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$buildDoc, (String)"$this$buildDoc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        GEntityGenerator.DefaultImpls.buildDoc((GEntityGenerator)this, $this$buildDoc, action);
    }

    @Override
    @NotNull
    public String toCaptionWords(@NotNull String $this$toCaptionWords, boolean lastPlural) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toCaptionWords, (String)"$this$toCaptionWords");
        return GEntityGenerator.DefaultImpls.toCaptionWords(this, $this$toCaptionWords, lastPlural);
    }

    @Override
    @NotNull
    public String toLowerCaseWords(@NotNull String $this$toLowerCaseWords, boolean lastPlural) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toLowerCaseWords, (String)"$this$toLowerCaseWords");
        return GEntityGenerator.DefaultImpls.toLowerCaseWords(this, $this$toLowerCaseWords, lastPlural);
    }

    @Override
    @NotNull
    public String getPlural(@NotNull String $this$plural) {
        Intrinsics.checkParameterIsNotNull((Object)$this$plural, (String)"$this$plural");
        return GEntityGenerator.DefaultImpls.getPlural(this, $this$plural);
    }

    @Override
    @NotNull
    public String withProcessedEntityLinks(@NotNull String $this$withProcessedEntityLinks) {
        Intrinsics.checkParameterIsNotNull((Object)$this$withProcessedEntityLinks, (String)"$this$withProcessedEntityLinks");
        return GEntityGenerator.DefaultImpls.withProcessedEntityLinks(this, $this$withProcessedEntityLinks);
    }

    @Override
    @NotNull
    public List<String> getWords(@NotNull String $this$getWords) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getWords, (String)"$this$getWords");
        return GEntityGenerator.DefaultImpls.getWords(this, $this$getWords);
    }

    @Override
    public void buildDocOr(@NotNull GapDocStringBuilder $this$buildDocOr, @NotNull GDoc gDoc, boolean wrapString, @NotNull Function1<? super GapDocStringBuilder, ? extends Object> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$buildDocOr, (String)"$this$buildDocOr");
        Intrinsics.checkParameterIsNotNull((Object)gDoc, (String)"gDoc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        GEntityGenerator.DefaultImpls.buildDocOr(this, $this$buildDocOr, gDoc, wrapString, action);
    }

    @Override
    public void buildPermissions(@NotNull GapDocStringBuilder $this$buildPermissions, @NotNull Function1<? super GapDocStringBuilder, ? extends Object> action, boolean wrapString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$buildPermissions, (String)"$this$buildPermissions");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        GEntityGenerator.DefaultImpls.buildPermissions(this, $this$buildPermissions, action, wrapString);
    }

    @Override
    public void buildDocOrAddTodo(@NotNull GapDocStringBuilder $this$buildDocOrAddTodo, @NotNull GDoc gDoc) {
        Intrinsics.checkParameterIsNotNull((Object)$this$buildDocOrAddTodo, (String)"$this$buildDocOrAddTodo");
        Intrinsics.checkParameterIsNotNull((Object)gDoc, (String)"gDoc");
        GEntityGenerator.DefaultImpls.buildDocOrAddTodo(this, $this$buildDocOrAddTodo, gDoc);
    }

    @Override
    public void generateResourceToc(@NotNull GapDocStringBuilder $this$generateResourceToc, @NotNull GResourceTreeNode resourceTree) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateResourceToc, (String)"$this$generateResourceToc");
        Intrinsics.checkParameterIsNotNull((Object)resourceTree, (String)"resourceTree");
        GResourceGenerator.DefaultImpls.generateResourceToc(this, $this$generateResourceToc, resourceTree);
    }

    @Override
    @NotNull
    public String getRelativePathWithId(@NotNull GResource $this$relativePathWithId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$relativePathWithId, (String)"$this$relativePathWithId");
        return GResourceGenerator.DefaultImpls.getRelativePathWithId(this, $this$relativePathWithId);
    }

    @Override
    public boolean getHasEntityMethods(@NotNull GResource $this$hasEntityMethods) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasEntityMethods, (String)"$this$hasEntityMethods");
        return GResourceGenerator.DefaultImpls.getHasEntityMethods(this, $this$hasEntityMethods);
    }

    @Override
    @NotNull
    public String toResourceId(@NotNull GResource $this$toResourceId, @NotNull String parentResourcePath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toResourceId, (String)"$this$toResourceId");
        Intrinsics.checkParameterIsNotNull((Object)parentResourcePath, (String)"parentResourcePath");
        return GResourceGenerator.DefaultImpls.toResourceId(this, $this$toResourceId, parentResourcePath);
    }

    @Override
    @NotNull
    public String toOperationsId(@NotNull GResource $this$toOperationsId, @NotNull String parentResourcePath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toOperationsId, (String)"$this$toOperationsId");
        Intrinsics.checkParameterIsNotNull((Object)parentResourcePath, (String)"parentResourcePath");
        return GResourceGenerator.DefaultImpls.toOperationsId(this, $this$toOperationsId, parentResourcePath);
    }

    @Override
    public void chapterOfMethod(@NotNull GapDocStringBuilder $this$chapterOfMethod, @NotNull GMethodInfo methodInfo, @NotNull GResource resource, @NotNull String absolutePath, @Nullable String idPlaceholder, @NotNull String resourceHref) {
        Intrinsics.checkParameterIsNotNull((Object)$this$chapterOfMethod, (String)"$this$chapterOfMethod");
        Intrinsics.checkParameterIsNotNull((Object)methodInfo, (String)"methodInfo");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)absolutePath, (String)"absolutePath");
        Intrinsics.checkParameterIsNotNull((Object)resourceHref, (String)"resourceHref");
        GResourceGenerator.DefaultImpls.chapterOfMethod(this, $this$chapterOfMethod, methodInfo, resource, absolutePath, idPlaceholder, resourceHref);
    }

    @Override
    @NotNull
    public String title(@NotNull GHttpMethod $this$title, @NotNull GType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$title), (String)"$this$title");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return GResourceGenerator.DefaultImpls.title(this, $this$title, type);
    }

    @Override
    @NotNull
    public String getAnchorIn(@NotNull GMethodInfo $this$getAnchorIn, @NotNull GResource resource) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getAnchorIn, (String)"$this$getAnchorIn");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        return GResourceGenerator.DefaultImpls.getAnchorIn(this, $this$getAnchorIn, resource);
    }

    public static final /* synthetic */ void access$generateEntityDoc(StardustGenerator $this, GEntityTypeTreeNode node, File dest) {
        $this.generateEntityDoc(node, dest);
    }

    public static final /* synthetic */ void access$generateResourceDoc(StardustGenerator $this, GResourceTreeNode node, String parentResourcePath, File dest) {
        $this.generateResourceDoc(node, parentResourcePath, dest);
    }

    public static final /* synthetic */ void access$generateOperationsDoc(StardustGenerator $this, GResourceTreeNode node, String parentResourcePath, File dest) {
        $this.generateOperationsDoc(node, parentResourcePath, dest);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/gaprest/doc/model/generator/StardustGenerator$Companion;", "Lmu/KLogging;", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "youtrack-gap-doc"})
    public static final class Companion
    extends KLogging {
        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            ModelCollector modelCollector = new ModelCollector();
            new StardustGenerator().generate(modelCollector.getGTypesHolder().getAllTypes(), modelCollector.getGResources(), args[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

