/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.client.error;

import com.jetbrains.bundle.client.error.ErrorCode;
import com.jetbrains.bundle.client.error.ErrorJSONCreator;
import com.jetbrains.bundle.client.error.ErrorMessageCreator;
import com.jetbrains.bundle.client.model.ErrorJSON;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BundleBackendErrorCode implements ErrorCode
{
    BASE_URL_SHOULD_NOT_CONTAIN_QUERY_PARAMETERS("Base URL should not contain query parameters"),
    MALFORMED_URL("URL is malformed"),
    BASE_URL_CONTEXT_DOES_NOT_MATCH("Current base context is ${currentContext}, it could not be changed to ${newContext} without product restart."),
    INVALID_PATH("Invalid path: ${path}"),
    UNKNOWN_PROPERTY("Property ${property} is not found among updatable bundle properties"),
    UNCHANGEABLE_AT_RUNTIME_PROPERTY("Property ${property} exists, but its update at runtime is not supported"),
    UNEXPECTED("Unexpected error occurred: ${reason}"),
    INVALID_BUNDLE_BACKEND_TOKEN("Invalid bundle backend token"),
    BUNDLE_BACKEND_TOO_MANY_FAILED_AUTHENTICATION_ATTEMPTS("Too many failed authentication attempts was performed"),
    SKIPPING_VALIDATION_IS_NOT_ALLOWED("Skipping validation of property ${property} is not allowed on update");

    private final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");
    private static ErrorJSONCreator errorJSONCreator;
    private String descriptionTemplate;
    private final String[] paramNames;
    private Logger LOG = LoggerFactory.getLogger(this.getClass());

    private BundleBackendErrorCode(String descriptionTemplate) {
        this.descriptionTemplate = descriptionTemplate;
        this.paramNames = this.extractParamNames(descriptionTemplate);
    }

    private String[] extractParamNames(@NotNull String descriptionTemplate) {
        HashSet<String> names = new HashSet<String>();
        Matcher matcher = this.PLACEHOLDER_PATTERN.matcher(descriptionTemplate);
        while (matcher.find()) {
            names.add(matcher.group(1));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String getCode() {
        return this.name();
    }

    public boolean checkErrorType(String code) {
        return code != null && this.name().equals(code);
    }

    public String getDescriptionTemplate() {
        return this.descriptionTemplate;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public boolean checkErrorCode(String errorCode) {
        return this.name().equals(errorCode);
    }

    @Override
    @NotNull
    public String getFormattedMessage(@NotNull Map<String, String> parameters) {
        try {
            int expectedNumOfParams = this.paramNames == null ? 0 : this.paramNames.length;
            int actualNumOfParams = parameters.size();
            if (expectedNumOfParams != actualNumOfParams) {
                throw new IllegalArgumentException(this.name() + " - Wrong number of parameters: expected " + expectedNumOfParams + ", but " + actualNumOfParams + " provided");
            }
            if (this.paramNames != null) {
                for (String name : this.paramNames) {
                    Set<String> actualNames = parameters.keySet();
                    if (actualNames.contains(name)) continue;
                    throw new IllegalArgumentException(this.name() + " - Parameter " + name + "not provided");
                }
            }
            StrSubstitutor sub = new StrSubstitutor(parameters);
            return sub.replace(this.descriptionTemplate);
        }
        catch (Exception e) {
            this.LOG.error("Cannot format error message: {}", (Object)e.getMessage(), (Object)e);
            return this.descriptionTemplate;
        }
    }

    public ErrorJSON toError() {
        return this.toError(Collections.emptyMap());
    }

    public ErrorJSON toError(@NotNull Map<String, String> parameters) {
        return errorJSONCreator.create((ErrorCode)this, (Map)parameters);
    }

    public <T> T toError(ErrorMessageCreator<T> errorMessageCreator) {
        return errorMessageCreator.create(this, Collections.emptyMap());
    }

    public <T> T toError(@NotNull Map<String, String> parameters, ErrorMessageCreator<T> errorMessageCreator) {
        return errorMessageCreator.create(this, parameters);
    }

    static {
        errorJSONCreator = new ErrorJSONCreator();
    }
}

