/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util;

import com.jetbrains.bundle.util.FileModeMapper;
import com.jetbrains.service.util.DeleteFileVisitor;
import com.jetbrains.service.util.SystemUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static void uncompressTarGz(@NotNull Path archive, @NotNull Path destinationDir) throws IOException {
        CompressUtil.uncompressTarGz(archive, destinationDir, null);
    }

    public static void uncompressTarGz(@NotNull Path archive, @NotNull Path destinationDir, @Nullable DirectoryStream.Filter<Path> destPathFilter) throws IOException {
        Files.createDirectories(destinationDir, new FileAttribute[0]);
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(archive.toFile()));
             GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)inputStream);
             CommonsArchiveInputStreamHolder archiveInputStream = new CommonsArchiveInputStreamHolder((ArchiveInputStream)new TarArchiveInputStream((InputStream)gzIn));){
            CompressUtil.extractFromArchive(destinationDir, archiveInputStream, destPathFilter, null);
        }
    }

    public static void uncompressZip(@NotNull Path archive, @NotNull Path destinationDir) throws IOException {
        CompressUtil.uncompressZip(archive, destinationDir, null);
    }

    public static void uncompressZip(@NotNull Path archive, @NotNull Path destinationDir, @Nullable DirectoryStream.Filter<Path> destPathFilter) throws IOException {
        CompressUtil.uncompressZip(archive, destinationDir, destPathFilter, null);
    }

    public static void uncompressZip(@NotNull Path archive, @NotNull Path destinationDir, @Nullable DirectoryStream.Filter<Path> destPathFilter, @Nullable Path relativeTopLevelDirToCut) throws IOException {
        Files.createDirectories(destinationDir, new FileAttribute[0]);
        try (ZipFile zip = new ZipFile(archive.toFile(), "UTF-8");
             CommonsZipFileHolder archiveInputStream = new CommonsZipFileHolder(zip);){
            CompressUtil.extractFromArchive(destinationDir, archiveInputStream, destPathFilter, relativeTopLevelDirToCut);
        }
    }

    public static void uncompressZip(@NotNull InputStream sourceInputStream, @NotNull Path destinationDir, @Nullable DirectoryStream.Filter<Path> destPathFilter, @Nullable Path relativeTopLevelDirToCut) throws IOException {
        CompressUtil.uncompressZip(sourceInputStream, destinationDir, destPathFilter, relativeTopLevelDirToCut, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressZip(@NotNull InputStream sourceInputStream, @NotNull Path destinationDir, @Nullable DirectoryStream.Filter<Path> destPathFilter, @Nullable Path relativeTopLevelDirToCut, boolean restoreFilePermissions) throws IOException {
        if (restoreFilePermissions && !SystemUtil.isWindows()) {
            Path tmpLocation = destinationDir.resolve(UUID.randomUUID().toString());
            try {
                Files.createDirectories(tmpLocation, new FileAttribute[0]);
                Path bundleZipPath = tmpLocation.resolve("tmp.zip");
                Files.copy(sourceInputStream, bundleZipPath, new CopyOption[0]);
                CompressUtil.uncompressZip(bundleZipPath, destinationDir, destPathFilter, relativeTopLevelDirToCut);
            }
            finally {
                Files.walkFileTree(tmpLocation, (FileVisitor<? super Path>)new DeleteFileVisitor());
            }
        }
        Files.createDirectories(destinationDir, new FileAttribute[0]);
        try (BufferedInputStream inputStream = new BufferedInputStream(sourceInputStream);
             CommonsArchiveInputStreamHolder archiveInputStream = new CommonsArchiveInputStreamHolder((ArchiveInputStream)new ZipArchiveInputStream((InputStream)inputStream));){
            CompressUtil.extractFromArchive(destinationDir, archiveInputStream, destPathFilter, relativeTopLevelDirToCut);
        }
    }

    private static void extractFromArchive(Path destinationDir, ArchiveInputStreamHolder archiveInputStream, DirectoryStream.Filter<Path> destPathFilter, Path relativeTopLevelDirToCut) throws IOException {
        ArchiveEntryHolder entry;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            Path entryPath = Paths.get(entry.getName(), new String[0]);
            if (relativeTopLevelDirToCut != null && entryPath.startsWith(relativeTopLevelDirToCut)) {
                entryPath = relativeTopLevelDirToCut.relativize(entryPath);
            }
            Path destinationPath = destinationDir.resolve(entryPath);
            if (entry.isDirectory()) {
                Files.createDirectories(destinationPath, new FileAttribute[0]);
                continue;
            }
            if (destPathFilter != null && !destPathFilter.accept(destinationPath)) continue;
            Path parent = destinationPath.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            entry.extract(destinationPath.toFile());
        }
    }

    public static void compressZip(@NotNull Path archivePath, boolean replaceExisting, @NotNull Map<Path, Path> pathMapping) throws IOException {
        if (pathMapping.size() == 0) {
            return;
        }
        if (Files.exists(archivePath, new LinkOption[0])) {
            if (replaceExisting) {
                Files.delete(archivePath);
            } else {
                throw new FileAlreadyExistsException(archivePath.toAbsolutePath().toString());
            }
        }
        Files.createDirectories(archivePath.getParent(), new FileAttribute[0]);
        try (FileOutputStream fileOutputStream = new FileOutputStream(archivePath.toFile());){
            final ZipArchiveOutputStream archive = new ZipArchiveOutputStream((OutputStream)fileOutputStream);
            for (final Path fromPath : pathMapping.keySet()) {
                final Path relativeToPath = pathMapping.get(fromPath);
                if (relativeToPath.isAbsolute()) {
                    throw new IllegalArgumentException(String.format("Path inside archive must be relative! %s ==> %s", fromPath, relativeToPath));
                }
                if (!Files.exists(fromPath, new LinkOption[0])) {
                    throw new IllegalArgumentException(String.format("Cannot compress, because path does not exist! %s", fromPath));
                }
                Files.walkFileTree(fromPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                        String fileName = relativeToPath.resolve(fromPath.relativize(file).toString()).toString();
                        ZipArchiveEntry entry = new ZipArchiveEntry(file.toFile(), CompressUtil.separatorsToUnix(fileName));
                        archive.putArchiveEntry((ArchiveEntry)entry);
                        try (FileInputStream inputStream = new FileInputStream(file.toFile());){
                            IOUtils.copy((InputStream)inputStream, (OutputStream)archive);
                            archive.closeArchiveEntry();
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path directory, IOException exception) throws IOException {
                        String dirName = relativeToPath.resolve(fromPath.relativize(directory).toString()).toString();
                        archive.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(directory.toFile(), CompressUtil.separatorsToUnix(dirName)));
                        archive.closeArchiveEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            archive.finish();
        }
    }

    public static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static interface ArchiveInputStreamHolder
    extends Closeable {
        public ArchiveEntryHolder getNextEntry() throws IOException;
    }

    public static class CommonsZipFileHolder
    implements ArchiveInputStreamHolder,
    Closeable {
        private final ZipFile zipFile;
        private final Enumeration<ZipArchiveEntry> zipFileEntries;

        private CommonsZipFileHolder(ZipFile zipFile) {
            this.zipFile = zipFile;
            this.zipFileEntries = zipFile.getEntries();
        }

        @Override
        public ArchiveEntryHolder getNextEntry() throws IOException {
            if (this.zipFileEntries.hasMoreElements()) {
                ZipArchiveEntry nextEntry = this.zipFileEntries.nextElement();
                return new CommonsZipArchiveEntryHolder(nextEntry, this.zipFile.getInputStream(nextEntry));
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }
    }

    public static class CommonsArchiveInputStreamHolder
    implements ArchiveInputStreamHolder,
    Closeable {
        private final ArchiveInputStream archiveInputStream;

        private CommonsArchiveInputStreamHolder(ArchiveInputStream archiveInputStream) {
            this.archiveInputStream = archiveInputStream;
        }

        @Override
        public ArchiveEntryHolder getNextEntry() throws IOException {
            ArchiveEntry nextEntry = this.archiveInputStream.getNextEntry();
            return nextEntry != null ? new CommonsArchiveEntryHolder(nextEntry, (InputStream)this.archiveInputStream) : null;
        }

        @Override
        public void close() throws IOException {
            this.archiveInputStream.close();
        }
    }

    static abstract class BaseEntryHolder
    implements ArchiveEntryHolder {
        private final InputStream archiveInputStream;

        private BaseEntryHolder(InputStream archiveInputStream) {
            this.archiveInputStream = archiveInputStream;
        }

        @Override
        public void extract(File destination) throws IOException {
            try (FileOutputStream dest = new FileOutputStream(destination);){
                IOUtils.copy((InputStream)this.archiveInputStream, (OutputStream)dest);
            }
            this.restoreFileMode(destination);
        }

        void restoreFileMode(File destination) throws IOException {
        }
    }

    static class CommonsZipArchiveEntryHolder
    extends BaseEntryHolder {
        private final ZipArchiveEntry archiveEntry;

        private CommonsZipArchiveEntryHolder(ZipArchiveEntry zipArchiveEntry, InputStream stream) {
            super(stream);
            this.archiveEntry = zipArchiveEntry;
        }

        @Override
        public String getName() {
            return this.archiveEntry.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.archiveEntry.isDirectory();
        }

        @Override
        void restoreFileMode(File destination) throws IOException {
            super.restoreFileMode(destination);
            FileModeMapper.map((ArchiveEntry)this.archiveEntry, destination);
        }
    }

    static class CommonsArchiveEntryHolder
    extends BaseEntryHolder {
        private final ArchiveEntry archiveEntry;

        private CommonsArchiveEntryHolder(ArchiveEntry archiveEntry, InputStream archiveInputStream) {
            super(archiveInputStream);
            this.archiveEntry = archiveEntry;
        }

        @Override
        public String getName() {
            return this.archiveEntry.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.archiveEntry.isDirectory();
        }

        @Override
        void restoreFileMode(File destination) throws IOException {
            super.restoreFileMode(destination);
            FileModeMapper.map(this.archiveEntry, destination);
        }
    }

    public static interface ArchiveEntryHolder {
        public String getName();

        public boolean isDirectory();

        public void extract(File var1) throws IOException;
    }
}

