/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.error.OAuthAuthErrorCode;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OAuthClientValidationException
extends OAuthValidationException {
    private static final String DOC_PREFIX = "auth";

    private OAuthClientValidationException(@NotNull OAuthAuthErrorCode code) {
        this(code, null);
    }

    private OAuthClientValidationException(@NotNull OAuthAuthErrorCode code, @Nullable String message) {
        super(code, message, DOC_PREFIX);
    }

    public static OAuthValidationException missingParameter(String parameterName) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Parameter '" + parameterName + "' is required");
    }

    public static OAuthValidationException authRequestDeclined() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "User declined authorization request");
    }

    public static OAuthValidationException userBanned() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "Logged in user is banned");
    }

    public static OAuthValidationException userHasNoLicense(String clientServiceName) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "Logged in user has no license for the service '" + clientServiceName + "'");
    }

    public static OAuthValidationException userEmailIsNotVerified() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "Email of authenticated user is not verified");
    }

    public static OAuthValidationException userDistrusts() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.ACCESS_DENIED, "User doesn't trust application");
    }

    public static OAuthClientValidationException invalidScope(String message) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_SCOPE, message);
    }

    public static OAuthClientValidationException unknownScope(String[] scope2) {
        return OAuthClientValidationException.invalidScope("Scope " + Arrays.toString(scope2) + " doesn't match any Service");
    }

    public static OAuthClientValidationException invalidCSRFCode() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.SERVER_ERROR, "Invalid CSRF token recieved.");
    }

    public static OAuthValidationException cantGiveGuestOfflineAccess() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Unable request offline access for Guest");
    }

    public static OAuthValidationException invalidResponseType(String responseType) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.UNSUPPORTED_RESPONSE_TYPE, "Value of authentication parameter response_type '" + responseType + "' is unsupported");
    }

    public static OAuthValidationException invalidParameter(String parameterName) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Parameter '" + parameterName + "' is invalid");
    }

    public static OAuthClientValidationException unknownService(String serviceId) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REQUEST, "Service with id \"" + serviceId + "\" was not found");
    }

    public static OAuthValidationException serviceHasNoRedirectURI(String clientServiceName, String requestedRedirectURI) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REDIRECT_URI, "Unregistered Redirect URI. Client service '" + clientServiceName + "' is not authorized to request an authorization entity using this method because the service has no registered 'Redirect URIs'. If you have Hub administrator permissions and the URI " + requestedRedirectURI + " does belong to '" + clientServiceName + "', please add this URI to the list of 'Redirect URIs' in the service settings in Hub.");
    }

    public static OAuthValidationException unregisteredRedirectURI(String clientServiceName, String requestedRedirectURI) {
        return new OAuthClientValidationException(OAuthAuthErrorCode.INVALID_REDIRECT_URI, "Unregistered Redirect URI. Client service '" + clientServiceName + "' requests authorization entity for the URI which is not registered in Hub: " + requestedRedirectURI + ". If you have Hub administrator permissions and the suspicious URI does belong to '" + clientServiceName + "', please add this URI to the list of 'Redirect URIs' in the service settings in Hub");
    }

    public static OAuthValidationException loginRequired() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.LOGIN_REQUIRED, "The user is required to be logged in");
    }

    public static OAuthValidationException requestNotSupported() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.REQUEST_NOT_SUPPORTED, "The request parameter not supported");
    }

    public static OAuthValidationException requestURINotSupported() {
        return new OAuthClientValidationException(OAuthAuthErrorCode.REQUEST_URI_NOT_SUPPORTED, "The request_uri parameter not supported");
    }
}

