/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.error.OAuthTokenErrorCode;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OAuthTokenValidationException
extends OAuthValidationException {
    private static final String DOC_PREFIX = "token";

    private OAuthTokenValidationException(@NotNull OAuthTokenErrorCode code) {
        this(code, null);
    }

    private OAuthTokenValidationException(@NotNull OAuthTokenErrorCode code, @Nullable String description) {
        super(code, description, DOC_PREFIX);
    }

    public static OAuthValidationException missingParameter(String parameterName) {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_REQUEST, "Parameter '" + parameterName + "' is required");
    }

    public static OAuthTokenValidationException invalidScope(String message) {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_SCOPE, message);
    }

    public static OAuthTokenValidationException unknownScope(String[] scope2) {
        return OAuthTokenValidationException.invalidScope("Scope " + Arrays.toString(scope2) + " doesn't match any Service");
    }

    public static OAuthValidationException userHasNoLicense(String clientServiceName) {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_SCOPE, "Logged in user has no license for the service '" + clientServiceName + "'");
    }

    public static OAuthValidationException missingAuthHeader() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_CLIENT, "Authorization header was not passed");
    }

    public static OAuthValidationException invalidGrant() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.UNSUPPORTED_GRANT_TYPE);
    }

    public static OAuthValidationException invalidServiceSecret() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Invalid service secret");
    }

    public static OAuthValidationException unknownAuthCode() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Unknown authorization code");
    }

    public static OAuthValidationException invalidAuthCode() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Invalid authorization code");
    }

    public static OAuthValidationException wrongClient() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Refresh token is issued to another client");
    }

    public static OAuthValidationException unknownRefreshToken() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Unknown refresh token");
    }

    public static OAuthValidationException inaccessibleScope() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Requested scope does not match allowed by access token");
    }

    public static OAuthValidationException invalidCredentials() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Invalid resource owner credentials");
    }

    @NotNull
    public static OAuthTokenValidationException userEmailIsNotVerified() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_GRANT, "Email of authenticated user is not verified");
    }

    public static OAuthValidationException untrustedService() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.UNAUTHORIZED_CLIENT, "Service is not verified");
    }

    public static OAuthValidationException invalidAuthHeader(Throwable cause) {
        OAuthTokenValidationException e = new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_CLIENT, "Invalid authorization header");
        e.initCause(cause);
        return e;
    }

    public static OAuthValidationException unknownService(String clientServiceId2) {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.INVALID_CLIENT, "Service with id \"" + clientServiceId2 + "\" was not found");
    }

    @NotNull
    public static OAuthValidationException bannedUser() {
        return new OAuthTokenValidationException(OAuthTokenErrorCode.BANNED_USER);
    }
}

