/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.AccessTokenData;
import java.security.Signature;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\b\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"verifyScope", "", "allowedScopes", "", "", "requiredScope", "([Ljava/lang/String;Ljava/lang/String;)V", "verifyExpiration", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "verifySignature", "publicKeySource", "Lcom/intellij/hub/auth/oauth2/provider/source/DSAPublicKeySource;", "com.intellij.hub.auth"})
@JvmName(name="TokenVerification")
public final class TokenVerification {
    public static final void verifyExpiration(@NotNull AccessToken $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Date checkedAt = new Date();
        Date grantedTill = $receiver.getExpirationDate();
        if (grantedTill.before(checkedAt)) {
            InvalidTokenException invalidTokenException = InvalidTokenException.expired(checkedAt, grantedTill);
            Intrinsics.checkExpressionValueIsNotNull((Object)invalidTokenException, (String)"InvalidTokenException.ex\u2026d(checkedAt, grantedTill)");
            throw (Throwable)invalidTokenException;
        }
    }

    public static final void verifySignature(@NotNull AccessToken $receiver, @NotNull DSAPublicKeySource publicKeySource) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)publicKeySource, (String)"publicKeySource");
        if ($receiver.getKeyVersion() > publicKeySource.getVersion()) {
            publicKeySource.forceUpdate();
        }
        try {
            Signature signature;
            Signature $receiver2 = signature = Signature.getInstance("SHA1withDSA");
            $receiver2.initVerify(publicKeySource.getKey());
            AccessTokenData accessTokenData = $receiver.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)accessTokenData, (String)"data");
            $receiver2.update(accessTokenData.getBytes());
            Signature sig = signature;
            if (!sig.verify($receiver.getSignature())) {
                InvalidTokenException invalidTokenException = InvalidTokenException.invalidTokenSignature();
                Intrinsics.checkExpressionValueIsNotNull((Object)invalidTokenException, (String)"InvalidTokenException.invalidTokenSignature()");
                throw (Throwable)invalidTokenException;
            }
        }
        catch (Exception e) {
            InvalidTokenException invalidTokenException = InvalidTokenException.malformedTokenSignature(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)invalidTokenException, (String)"InvalidTokenException.malformedTokenSignature(e)");
            throw (Throwable)invalidTokenException;
        }
    }

    public static final void verifyScope(@NotNull AccessToken $receiver, @NotNull String requiredScope) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)requiredScope, (String)"requiredScope");
        String[] stringArray = $receiver.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"scope");
        TokenVerification.verifyScope(stringArray, requiredScope);
    }

    public static final void verifyScope(@NotNull String[] allowedScopes, @NotNull String requiredScope) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)allowedScopes, (String)"allowedScopes");
            Intrinsics.checkParameterIsNotNull((Object)requiredScope, (String)"requiredScope");
            for (Object element$iv : (Object[])allowedScopes) {
                String it = (String)element$iv;
                if (!Intrinsics.areEqual((Object)it, (Object)requiredScope)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (bl) {
            InvalidTokenException invalidTokenException = InvalidTokenException.invalidTokenScope(requiredScope, allowedScopes);
            Intrinsics.checkExpressionValueIsNotNull((Object)invalidTokenException, (String)"InvalidTokenException.in\u2026iredScope, allowedScopes)");
            throw (Throwable)invalidTokenException;
        }
    }
}

