/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.consumer;

import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import org.jetbrains.annotations.NotNull;

public interface TokenLoader {
    @NotNull
    public TokenData loadAccessToken(@NotNull BasicAuthToken var1) throws OAuth2TokenLoadException;

    public static final class TokenData {
        private static final int EXPIRATION_GAP = 60000;
        private volatile AccessToken accessToken;
        private final String rawAccessToken;
        private final String refreshToken;
        private final long expirationTime;

        public TokenData(String accessToken, String refreshToken, long expirationTime) {
            if (accessToken == null) {
                throw new IllegalStateException("Hub returned empty response instead of auth token");
            }
            this.rawAccessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expirationTime = expirationTime;
        }

        public AccessToken getAccessToken() {
            if (this.accessToken == null) {
                this.accessToken = AccessToken.decode(this.rawAccessToken);
            }
            return this.accessToken;
        }

        public String getRawAccessToken() {
            return this.rawAccessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public boolean isExpired() {
            return this.expirationTime < System.currentTimeMillis() + 60000L;
        }
    }
}

