/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.error;

import com.intellij.hub.auth.oauth2.error.OAuthError;
import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.core.Error;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum VerifyTokenErrorCode implements OAuthErrorCode
{
    AUTH_HEADER_TYPE_UNKNOWN(400, "invalid_request", "Authorization header is neither Bearer nor Basic"),
    BEARER_EXPECTED(400, "invalid_request", "Authorization header is not Bearer"),
    BASIC_EXPECTED(400, "invalid_request", "Authorization header is not Basic"),
    BASIC_DISABLED(400, "invalid_request", "Basic authentication is disabled. Please use Bearer authentication header"),
    BASIC_TOKEN_MALFORMED(401, "invalid_token", "Unable to decode basic token"),
    TOKEN_MALFORMED(401, "invalid_token", "Token is malformed"),
    TOKEN_DATA_MALFORMED(401, "invalid_token", "Token data part is malformed"),
    TOKEN_VERSION_MALFORMED(401, "invalid_token", "Token version is malformed"),
    TOKEN_SIGNATURE_MALFORMED(401, "invalid_token", "Token signature is malformed"),
    TOKEN_SIGNATURE_INVALID(401, "invalid_token", "Token signature is invalid"),
    TOKEN_EXPIRATION_MALFORMED(401, "invalid_token", "Token expiration time part is malformed"),
    TOKEN_EXPIRED(401, "invalid_token", "Token has expired"),
    TOKEN_SCOPE_MALFORMED(401, "invalid_token", "Token scope part is malformed"),
    TOKEN_SCOPE_INVALID(401, "invalid_token", "Token scope part is invalid"),
    TOKEN_USER_DELETED(401, "invalid_token", "User who owned the access token was deleted"),
    TOKEN_CLIENT_INVALID(401, "invalid_client", "Token client part is invalid"),
    PERMANENT_TOKEN_INVALID(401, "invalid_token", "Permanent token is invalid"),
    PERMANENT_TOKEN_USERNAME_INVALID(401, "invalid_token", "Permanent token username does not match the stored one"),
    PERMANENT_TOKEN_NAME_INVALID(401, "invalid_token", "Permanent token name does not match the stored one"),
    PERMANENT_TOKEN_MALFORMED(401, "invalid_token", "Permanent token is malformed"),
    PERMANENT_TOKEN_USERNAME_MALFORMED(401, "invalid_token", "Permanent token username part is malformed"),
    PERMANENT_TOKEN_NAME_MALFORMED(401, "invalid_token", "Permanent token name part is malformed"),
    TOKEN_OWNER_EMAIL_IS_NOT_VERIFIED(401, "invalid_token", "Email verification is required but token owner has not verified email"),
    TOKEN_OWNER_HAS_NOT_ACCEPTED_EUA(401, "invalid_token", "User agreement consent is required but token owner has not accepted user agreement");

    private int statusCode;
    private String code;
    private String description;

    private VerifyTokenErrorCode(int statusCode, String code) {
        this.code = code;
        this.statusCode = statusCode;
    }

    private VerifyTokenErrorCode(int statusCode, String code, String description) {
        this(statusCode, code);
        this.description = description;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getASCIICode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Error createError() {
        return this.createError(null, null, null);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description) {
        return this.createError(description, null, null);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description, @Nullable URI errorUri) {
        return this.createError(description, null, errorUri);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description, @Nullable String devDescription, @Nullable URI errorUri) {
        return new OAuthError(this, description, devDescription, errorUri);
    }
}

