/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.provider.source;

import com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource;
import com.intellij.hub.auth.oauth2.provider.source.KeyAndVersion;
import com.intellij.hub.auth.oauth2.provider.source.KeyLoadException;
import java.security.interfaces.DSAPublicKey;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDSAPublicKeySource
implements DSAPublicKeySource {
    public static final String KEY_URL = "/oauth2/key";
    private KeyAndVersion cached;

    @Override
    @NotNull
    public DSAPublicKey getKey() {
        return this.getKeyAndVersion().getKey();
    }

    @Override
    public int getVersion() {
        return this.getKeyAndVersion().getVersion();
    }

    @NotNull
    private synchronized KeyAndVersion getKeyAndVersion() {
        if (this.cached == null) {
            this.forceUpdate();
        }
        return this.cached;
    }

    @Override
    public synchronized boolean forceUpdate() {
        KeyAndVersion newKey;
        KeyAndVersion oldKey = this.cached;
        this.cached = newKey = this.loadKey();
        return !newKey.equals(oldKey);
    }

    @NotNull
    protected abstract KeyAndVersion loadKey() throws KeyLoadException;
}

