/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.core.data.uri;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.Nullable;

public class DataURI {
    private static final Pattern DATA_URI_PATTERN = Pattern.compile("data\\:(.+?);base64,(.+)", 34);
    private String mimeType;
    private String base64Content;

    public DataURI(String mimeType, byte[] content) {
        this.mimeType = mimeType;
        this.base64Content = DatatypeConverter.printBase64Binary((byte[])content);
    }

    public DataURI(String mimeType, InputStream content) throws IOException {
        this(mimeType, DataURI.toByteArray(content));
    }

    public DataURI(String dataURI) {
        Matcher matcher = DATA_URI_PATTERN.matcher(dataURI);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad Data URI format: " + dataURI);
        }
        this.mimeType = matcher.group(1);
        this.base64Content = matcher.group(2);
    }

    public String getDataURI() {
        return "data:" + this.mimeType + ";base64," + this.base64Content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getContent() {
        return DatatypeConverter.parseBase64Binary((String)this.base64Content);
    }

    public String getBase64Content() {
        return this.base64Content;
    }

    protected static byte[] toByteArray(InputStream content) throws IOException {
        int l;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((l = content.read(buffer)) >= 0) {
            out.write(buffer, 0, l);
        }
        out.close();
        content.close();
        return out.toByteArray();
    }

    @Nullable
    public static DataURI parse(@Nullable String dataUri) {
        if (dataUri == null || dataUri.length() == 0) {
            return null;
        }
        try {
            return new DataURI(dataUri);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

