/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.core.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.auth.module.core.rest.client.api.CoreAuthModule;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.ThrottlingSettingsJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="coreauthmodule")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=CoreauthmoduleJSON.class)
public class CoreauthmoduleJSON
extends AuthmoduleJSON
implements CoreAuthModule {
    @XmlElement(name="registrationEnabled")
    private Boolean registrationEnabled;
    @XmlElement(name="passwordRestoreEnabled")
    private Boolean passwordRestoreEnabled;
    @XmlElement(name="captchaEnabled")
    private Boolean captchaEnabled;
    @XmlElement(name="captchaPublicKey")
    private String captchaPublicKey;
    @XmlElement(name="captchaPrivateKey")
    private String captchaPrivateKey;
    @XmlElement(name="passwordStrengthPolicy")
    private Integer passwordStrengthPolicy;
    @XmlElement(name="throttlingSettings")
    private ThrottlingSettingsJSON throttlingSettings;

    public CoreauthmoduleJSON() {
    }

    public CoreauthmoduleJSON(@NotNull CoreAuthModule that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        this.setOrdinal(that.getOrdinal());
        this.setAccountsSize(that.getAccountsSize());
        this.setDisabled(that.isDisabled());
        if (that.getAutoJoinGroups() != null) {
            ArrayList<UserGroupJSON> references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getAutoJoinGroups()) {
                UserGroupJSON ref = new UserGroupJSON();
                ref.setId(userGroup.getId());
                references.add(ref);
            }
            this.setAutoJoinGroups(references);
        }
        this.setRegistrationEnabled(that.isRegistrationEnabled());
        this.setPasswordRestoreEnabled(that.isPasswordRestoreEnabled());
        this.setCaptchaEnabled(that.isCaptchaEnabled());
        this.setCaptchaPublicKey(that.getCaptchaPublicKey());
        this.setCaptchaPrivateKey(that.getCaptchaPrivateKey());
        this.setPasswordStrengthPolicy(that.getPasswordStrengthPolicy());
        if (that.getThrottlingSettings() != null) {
            ThrottlingSettingsJSON ref = new ThrottlingSettingsJSON();
            ref.setId(that.getThrottlingSettings().getId());
            this.setThrottlingSettings(ref);
        }
    }

    @Override
    @Nullable
    public Boolean isRegistrationEnabled() {
        return this.registrationEnabled;
    }

    @Override
    @Nullable
    public Boolean isPasswordRestoreEnabled() {
        return this.passwordRestoreEnabled;
    }

    @Override
    @Nullable
    public Boolean isCaptchaEnabled() {
        return this.captchaEnabled;
    }

    @Override
    @Nullable
    public String getCaptchaPublicKey() {
        return this.captchaPublicKey;
    }

    @Override
    @Nullable
    public String getCaptchaPrivateKey() {
        return this.captchaPrivateKey;
    }

    @Override
    @Nullable
    public Integer getPasswordStrengthPolicy() {
        return this.passwordStrengthPolicy;
    }

    @Override
    @Nullable
    public ThrottlingSettingsJSON getThrottlingSettings() {
        return this.throttlingSettings;
    }

    @XmlTransient
    public void setRegistrationEnabled(@Nullable Boolean registrationEnabled) {
        this.registrationEnabled = registrationEnabled;
    }

    @XmlTransient
    public void setPasswordRestoreEnabled(@Nullable Boolean passwordRestoreEnabled) {
        this.passwordRestoreEnabled = passwordRestoreEnabled;
    }

    @XmlTransient
    public void setCaptchaEnabled(@Nullable Boolean captchaEnabled) {
        this.captchaEnabled = captchaEnabled;
    }

    @XmlTransient
    public void setCaptchaPublicKey(@Nullable String captchaPublicKey) {
        this.captchaPublicKey = captchaPublicKey;
    }

    @XmlTransient
    public void setCaptchaPrivateKey(@Nullable String captchaPrivateKey) {
        this.captchaPrivateKey = captchaPrivateKey;
    }

    @XmlTransient
    public void setPasswordStrengthPolicy(@Nullable Integer passwordStrengthPolicy) {
        this.passwordStrengthPolicy = passwordStrengthPolicy;
    }

    @XmlTransient
    public void setThrottlingSettings(@Nullable ThrottlingSettingsJSON throttlingSettings) {
        this.throttlingSettings = throttlingSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CoreAuthModule)) {
            return false;
        }
        CoreAuthModule that = (CoreAuthModule)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static CoreauthmoduleJSON wrap(@NotNull CoreAuthModule that) {
        if (that instanceof CoreauthmoduleJSON) {
            return (CoreauthmoduleJSON)that;
        }
        return new CoreauthmoduleJSON(that);
    }
}

