/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.google.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.auth.module.google.rest.client.api.GoogleAuthModule;
import jetbrains.jetpass.auth.module.rest.client.json.Externaloauth2moduleJSON;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="googleauthmodule")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=GoogleauthmoduleJSON.class)
public class GoogleauthmoduleJSON
extends Externaloauth2moduleJSON
implements GoogleAuthModule {
    @XmlElement(name="newUserRestrictDomain")
    private String newUserRestrictDomain;

    public GoogleauthmoduleJSON() {
    }

    public GoogleauthmoduleJSON(@NotNull GoogleAuthModule that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        this.setOrdinal(that.getOrdinal());
        this.setAccountsSize(that.getAccountsSize());
        this.setDisabled(that.isDisabled());
        if (that.getAutoJoinGroups() != null) {
            ArrayList<UserGroupJSON> references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getAutoJoinGroups()) {
                UserGroupJSON ref = new UserGroupJSON();
                ref.setId(userGroup.getId());
                references.add(ref);
            }
            this.setAutoJoinGroups(references);
        }
        this.setServerUrl(that.getServerUrl());
        this.setConnectionTimeout(that.getConnectionTimeout());
        this.setReadTimeout(that.getReadTimeout());
        this.setAllowedCreateNewUsers(that.isAllowedCreateNewUsers());
        this.setClientId(that.getClientId());
        this.setClientSecret(that.getClientSecret());
        this.setRedirectUri(that.getRedirectUri());
        this.setIconUrl(that.getIconUrl());
        this.setNewUserRestrictDomain(that.getNewUserRestrictDomain());
    }

    @Override
    @Nullable
    public String getNewUserRestrictDomain() {
        return this.newUserRestrictDomain;
    }

    @XmlTransient
    public void setNewUserRestrictDomain(@Nullable String newUserRestrictDomain) {
        this.newUserRestrictDomain = newUserRestrictDomain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoogleAuthModule)) {
            return false;
        }
        GoogleAuthModule that = (GoogleAuthModule)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static GoogleauthmoduleJSON wrap(@NotNull GoogleAuthModule that) {
        if (that instanceof GoogleauthmoduleJSON) {
            return (GoogleauthmoduleJSON)that;
        }
        return new GoogleauthmoduleJSON(that);
    }
}

