/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.auth.module.rest.client.api.ExternalOAuth2Module;
import jetbrains.jetpass.auth.module.rest.client.json.ExternalauthmoduleJSON;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="externaloauth2module")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Externaloauth2moduleJSON.class)
public class Externaloauth2moduleJSON
extends ExternalauthmoduleJSON
implements ExternalOAuth2Module {
    @XmlElement(name="clientId")
    private String clientId;
    @XmlElement(name="clientSecret")
    private String clientSecret;
    @XmlElement(name="redirectUri")
    private String redirectUri;
    @XmlElement(name="iconUrl")
    private String iconUrl;

    public Externaloauth2moduleJSON() {
    }

    public Externaloauth2moduleJSON(@NotNull ExternalOAuth2Module that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        this.setOrdinal(that.getOrdinal());
        this.setAccountsSize(that.getAccountsSize());
        this.setDisabled(that.isDisabled());
        if (that.getAutoJoinGroups() != null) {
            ArrayList<UserGroupJSON> references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getAutoJoinGroups()) {
                UserGroupJSON ref = new UserGroupJSON();
                ref.setId(userGroup.getId());
                references.add(ref);
            }
            this.setAutoJoinGroups(references);
        }
        this.setServerUrl(that.getServerUrl());
        this.setConnectionTimeout(that.getConnectionTimeout());
        this.setReadTimeout(that.getReadTimeout());
        this.setAllowedCreateNewUsers(that.isAllowedCreateNewUsers());
        this.setClientId(that.getClientId());
        this.setClientSecret(that.getClientSecret());
        this.setRedirectUri(that.getRedirectUri());
        this.setIconUrl(that.getIconUrl());
    }

    @Override
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @Nullable
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @XmlTransient
    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    @XmlTransient
    public void setClientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @XmlTransient
    public void setRedirectUri(@Nullable String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @XmlTransient
    public void setIconUrl(@Nullable String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalOAuth2Module)) {
            return false;
        }
        ExternalOAuth2Module that = (ExternalOAuth2Module)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static Externaloauth2moduleJSON wrap(@NotNull ExternalOAuth2Module that) {
        if (that instanceof Externaloauth2moduleJSON) {
            return (Externaloauth2moduleJSON)that;
        }
        return new Externaloauth2moduleJSON(that);
    }
}

