/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.OrderBy;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.SortOrder;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;
import org.jetbrains.annotations.NotNull;

public class BaseFilter<T extends BaseFilter> {
    public static final String SKIP_KEYWORD = "$skip";
    public static final String TOP_KEYWORD = "$top";
    public static final String QUERY_KEYWORD = "query";
    public static final String ORDER_BY_KEYWORD = "orderBy";
    private Integer skip = null;
    private Integer top = null;
    private String query = null;
    private boolean totalRequested = false;
    private List<OrderBy> orderBy = new ArrayList<OrderBy>(3);
    private MultivaluedMap<String, String> queryParameters = new StringKeyIgnoreCaseMultivaluedMap();

    public T skip(int amount) {
        this.skip = amount;
        return (T)this;
    }

    public T top(int amount) {
        this.top = amount;
        return (T)this;
    }

    public T topAll() {
        this.top = -1;
        return (T)this;
    }

    public T requestTotal() {
        this.totalRequested = true;
        return (T)this;
    }

    public boolean isTotalRequested() {
        return this.totalRequested;
    }

    public T query(String value) {
        this.query = value;
        return (T)this;
    }

    public T orderBy(@NotNull String value) {
        return this.orderBy(new OrderBy(value, SortOrder.DEFAULT));
    }

    public T orderBy(@NotNull OrderBy order) {
        this.orderBy.add(order);
        return (T)this;
    }

    protected void add(String paramName, Iterable<Object> values) {
        if (values != null) {
            for (Object value : values) {
                this.queryParameters.add((Object)paramName, (Object)BaseClient.wrapObject(value));
            }
        }
    }

    protected void add(String paramName, Object value) {
        if (paramName != null) {
            this.queryParameters.add((Object)paramName, (Object)BaseClient.wrapObject(value));
        }
    }

    public Integer getSkip() {
        return this.skip;
    }

    public Integer getTop() {
        return this.top;
    }

    public String getQuery() {
        return this.query;
    }

    public List<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public WebTarget apply(WebTarget resource) {
        resource = this.queryParam(resource, SKIP_KEYWORD, this.skip);
        resource = this.queryParam(resource, TOP_KEYWORD, this.top);
        if (this.query != null && this.query.length() > 0) {
            resource = resource.queryParam(QUERY_KEYWORD, new Object[]{BaseClient.wrapObject(this.query)});
        }
        if (!this.orderBy.isEmpty()) {
            StringBuilder o = new StringBuilder();
            for (OrderBy order : this.orderBy) {
                if (o.length() > 0) {
                    o.append(",");
                }
                o.append(order);
            }
            resource = resource.queryParam(ORDER_BY_KEYWORD, new Object[]{BaseClient.wrapObject(o)});
        }
        for (Map.Entry entry : this.queryParameters.entrySet()) {
            resource = resource.queryParam((String)entry.getKey(), ((List)entry.getValue()).toArray());
        }
        return resource;
    }

    private WebTarget queryParam(WebTarget resource, String queryParameterName, Integer value) {
        if (value != null) {
            resource = resource.queryParam(queryParameterName, new Object[]{BaseClient.wrapObject(value)});
        }
        return resource;
    }

    public static BaseFilter<BaseFilter> filter() {
        return new BaseFilter<BaseFilter>();
    }
}

