/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.EnabledFeaturesJSON;
import jetbrains.jetpass.rest.dto.HubFeatureJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HubFeatureClient
extends BaseClient {
    public HubFeatureClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public HubFeatureClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("hubfeatures"), container);
    }

    @NotNull
    public Page getHubFeaturePage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.HubFeature> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @Nullable
    public HubFeatureJSON getHubFeature(@NotNull String hubFeatureId, @Nullable FieldPartial<Partial.HubFeature> partial) {
        return this.get(null, hubFeatureId, partial);
    }

    private HubFeatureJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.HubFeature> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (HubFeatureJSON)this.prepare(resource).get(HubFeatureJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void updateHubFeature(@NotNull String hubFeatureId, @NotNull HubFeatureJSON entity) {
        this.prepare(this.path(hubFeatureId)).post(Entity.json((Object)entity), String.class);
    }

    public EnabledFeaturesJSON enabled(@Nullable List<String> key, @Nullable FieldPartial<Partial.EnabledFeatures> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (key != null) {
            for (String pValue : key) {
                r = r.queryParam("key", new Object[]{BaseClient.wrapObject(pValue)});
            }
        }
        return (EnabledFeaturesJSON)this.prepare(r.path("enabled")).method("GET", (GenericType)new GenericType<EnabledFeaturesJSON>(){});
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<HubFeatureJSON> {
        @XmlElement(name="hubfeatures")
        private List<HubFeatureJSON> hubfeatures;

        @NotNull
        public List<HubFeatureJSON> getHubfeatures() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<HubFeatureJSON> getItems() {
            return this.hubfeatures != null ? this.hubfeatures : new ArrayList(0);
        }
    }
}

