/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ProjectTeamJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTeamClient
extends BaseClient {
    public ProjectTeamClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public ProjectTeamClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("projectteams"), container);
    }

    @NotNull
    public Page getProjectTeamPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.ProjectTeam> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @Nullable
    public ProjectTeamJSON getProjectTeam(@NotNull String projectTeamId, @Nullable FieldPartial<Partial.ProjectTeam> partial) {
        return this.get(null, projectTeamId, partial);
    }

    private ProjectTeamJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.ProjectTeam> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (ProjectTeamJSON)this.prepare(resource).get(ProjectTeamJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void updateProjectTeam(@NotNull String projectTeamId, @NotNull ProjectTeamJSON entity) {
        this.prepare(this.path(projectTeamId)).post(Entity.json((Object)entity), String.class);
    }

    public ProjectTeamJSON absorb(@NotNull String projectTeamId, @NotNull UserGroupJSON[] entity, @NotNull Boolean absorbMembers, @Nullable FieldPartial<Partial.ProjectTeam> partial) {
        WebTarget resource = this.apply(partial);
        WebTarget r = resource.path(projectTeamId).path("absorb");
        if (absorbMembers != null) {
            r = r.queryParam("absorbMembers", new Object[]{absorbMembers});
        }
        return (ProjectTeamJSON)this.prepare(r).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<ProjectTeamJSON>(){});
    }

    @NotNull
    public GroupClient getGroupsClient(@NotNull String projectTeamId) {
        return new GroupClient(this.path(projectTeamId), this.container);
    }

    @NotNull
    public UserClient getUsersClient(@NotNull String projectTeamId) {
        return new UserClient(this.path(projectTeamId), this.container);
    }

    @NotNull
    public OwnUserClient getOwnUsersClient(@NotNull String projectTeamId) {
        return new OwnUserClient(this.path(projectTeamId), this.container);
    }

    @NotNull
    public ProjectRoleClient getProjectrolesClient(@NotNull String projectTeamId) {
        return new ProjectRoleClient(this.path(projectTeamId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class ProjectRoleClient
    extends BaseClient {
        private ProjectRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("projectroles"), container);
        }

        @NotNull
        public Page getProjectRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectRoleJSON addProjectRole(@NotNull ProjectRoleJSON entity, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ProjectRoleJSON.class);
        }

        @NotNull
        public ProjectRoleJSON getProjectRole(@NotNull String id, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial).path(id)).get(ProjectRoleJSON.class);
        }

        public void removeProjectRole(@NotNull String id) {
            this.prepare(this.path(id)).delete(ProjectRoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectRoleJSON> {
            @XmlElement(name="projectroles")
            private List<ProjectRoleJSON> projectroles;

            @NotNull
            public List<ProjectRoleJSON> getProjectroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectRoleJSON> getItems() {
                return this.projectroles != null ? this.projectroles : new ArrayList(0);
            }
        }
    }

    public static class OwnUserClient
    extends BaseClient {
        private OwnUserClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("ownUsers"), container);
        }

        @NotNull
        public Page getUserPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.User> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserJSON addUser(@NotNull UserJSON entity, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserJSON.class);
        }

        @NotNull
        public UserJSON getUser(@NotNull String id, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial).path(id)).get(UserJSON.class);
        }

        public void removeUser(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserJSON> {
            @XmlElement(name="ownUsers")
            private List<UserJSON> users;

            @NotNull
            public List<UserJSON> getUsers() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserJSON> getItems() {
                return this.users != null ? this.users : new ArrayList(0);
            }
        }
    }

    public static class UserClient
    extends BaseClient {
        private UserClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("users"), container);
        }

        @NotNull
        public Page getUserPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.User> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserJSON addUser(@NotNull UserJSON entity, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserJSON.class);
        }

        @NotNull
        public UserJSON getUser(@NotNull String id, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial).path(id)).get(UserJSON.class);
        }

        public void removeUser(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserJSON> {
            @XmlElement(name="users")
            private List<UserJSON> users;

            @NotNull
            public List<UserJSON> getUsers() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserJSON> getItems() {
                return this.users != null ? this.users : new ArrayList(0);
            }
        }
    }

    public static class GroupClient
    extends BaseClient {
        private GroupClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("groups"), container);
        }

        @NotNull
        public Page getGroupPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserGroupJSON addGroup(@NotNull UserGroupJSON entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserGroupJSON.class);
        }

        @NotNull
        public UserGroupJSON getGroup(@NotNull String id, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial).path(id)).get(UserGroupJSON.class);
        }

        public void removeGroup(@NotNull String id) {
            this.removeGroup(id, false);
        }

        public void removeGroup(@NotNull String id, boolean keepUsers) {
            this.prepare(this.path(id).queryParam("keepUsers", new Object[]{keepUsers})).delete(UserGroupJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserGroupJSON> {
            @XmlElement(name="groups")
            private List<UserGroupJSON> groups;

            @NotNull
            public List<UserGroupJSON> getGroups() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserGroupJSON> getItems() {
                return this.groups != null ? this.groups : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<ProjectTeamJSON> {
        @XmlElement(name="projectteams")
        private List<ProjectTeamJSON> projectteams;

        @NotNull
        public List<ProjectTeamJSON> getProjectteams() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<ProjectTeamJSON> getItems() {
            return this.projectteams != null ? this.projectteams : new ArrayList(0);
        }
    }
}

