/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.HeaderItemJSON;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.RoleJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UntrustedRedirectURIJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceClient
extends BaseClient {
    public ServiceClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public ServiceClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("services"), container);
    }

    @NotNull
    public Page getServicePage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Service> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public ServiceJSON createService(@NotNull ServiceJSON entity, @Nullable FieldPartial<Partial.Service> partial) {
        return (ServiceJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ServiceJSON.class);
    }

    @Nullable
    public ServiceJSON getService(@NotNull String serviceId, @Nullable FieldPartial<Partial.Service> partial) {
        return this.get(null, serviceId, partial);
    }

    @Nullable
    public ServiceJSON getServiceByName(@NotNull String name, @Nullable FieldPartial<Partial.Service> partial) {
        return this.get("byname", name, partial);
    }

    private ServiceJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Service> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (ServiceJSON)this.prepare(resource).get(ServiceJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteService(@NotNull String serviceId) {
        WebTarget path = this.path(serviceId);
        this.prepare(path).delete(String.class);
    }

    public void updateService(@NotNull String serviceId, @NotNull ServiceJSON entity) {
        this.prepare(this.path(serviceId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public List<HeaderItemJSON> header(@Nullable FieldPartial<Partial.HeaderItem> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        return (List)this.prepare(r.path("header")).method("GET", (GenericType)new GenericType<List<HeaderItemJSON>>(){});
    }

    public ServiceJSON me(@Nullable FieldPartial<Partial.Service> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        return (ServiceJSON)this.prepare(r.path("me")).method("GET", (GenericType)new GenericType<ServiceJSON>(){});
    }

    @NotNull
    public ProjectRoleClient getProjectrolesClient(@NotNull String serviceId) {
        return new ProjectRoleClient(this.path(serviceId), this.container);
    }

    @NotNull
    public ResourceClient getResourcesClient(@NotNull String serviceId) {
        return new ResourceClient(this.path(serviceId), this.container);
    }

    @NotNull
    public PermissionClient getPermissionsClient(@NotNull String serviceId) {
        return new PermissionClient(this.path(serviceId), this.container);
    }

    @NotNull
    public DefaultRoleClient getDefaultrolesClient(@NotNull String serviceId) {
        return new DefaultRoleClient(this.path(serviceId), this.container);
    }

    @NotNull
    public HeaderVisibleGroupClient getHeadervisiblegroupsClient(@NotNull String serviceId) {
        return new HeaderVisibleGroupClient(this.path(serviceId), this.container);
    }

    @NotNull
    public ViewersClient getViewersClient(@NotNull String serviceId) {
        return new ViewersClient(this.path(serviceId), this.container);
    }

    @NotNull
    public UntrustedRedirectURIClient getUntrustedredirecturisClient(@NotNull String serviceId) {
        return new UntrustedRedirectURIClient(this.path(serviceId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class UntrustedRedirectURIClient
    extends BaseClient {
        private UntrustedRedirectURIClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("untrustedredirecturis"), container);
        }

        @NotNull
        public Page getUntrustedRedirectURIPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.UntrustedRedirectURI> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UntrustedRedirectURIJSON addUntrustedRedirectURI(@NotNull UntrustedRedirectURIJSON entity, @Nullable FieldPartial<Partial.UntrustedRedirectURI> partial) {
            return (UntrustedRedirectURIJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UntrustedRedirectURIJSON.class);
        }

        @NotNull
        public UntrustedRedirectURIJSON getUntrustedRedirectURI(@NotNull String id, @Nullable FieldPartial<Partial.UntrustedRedirectURI> partial) {
            return (UntrustedRedirectURIJSON)this.prepare(this.apply(partial).path(id)).get(UntrustedRedirectURIJSON.class);
        }

        public void removeUntrustedRedirectURI(@NotNull String id) {
            this.prepare(this.path(id)).delete(UntrustedRedirectURIJSON.class);
        }

        public void accept(@NotNull String untrustedRedirectURIId) {
            WebTarget resource = this.apply(null);
            WebTarget r = resource.path(untrustedRedirectURIId);
            this.prepare(r.path("accept")).method("POST");
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UntrustedRedirectURIJSON> {
            @XmlElement(name="untrustedredirecturis")
            private List<UntrustedRedirectURIJSON> untrustedredirecturis;

            @NotNull
            public List<UntrustedRedirectURIJSON> getUntrustedredirecturis() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UntrustedRedirectURIJSON> getItems() {
                return this.untrustedredirecturis != null ? this.untrustedredirecturis : new ArrayList(0);
            }
        }
    }

    public static class ViewersClient
    extends BaseClient {
        private ViewersClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("viewers"), container);
        }

        @NotNull
        public Page getViewersPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.AuthorityHolder> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public AuthorityHolderJSON addViewer(@NotNull AuthorityHolderJSON entity, @Nullable FieldPartial<Partial.AuthorityHolder> partial) {
            return (AuthorityHolderJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), AuthorityHolderJSON.class);
        }

        @NotNull
        public AuthorityHolderJSON getViewer(@NotNull String id, @Nullable FieldPartial<Partial.AuthorityHolder> partial) {
            return (AuthorityHolderJSON)this.prepare(this.apply(partial).path(id)).get(AuthorityHolderJSON.class);
        }

        public void removeViewer(@NotNull String id) {
            this.prepare(this.path(id)).delete(AuthorityHolderJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<AuthorityHolderJSON> {
            @XmlElement(name="viewers")
            private List<AuthorityHolderJSON> viewers;

            @NotNull
            public List<AuthorityHolderJSON> getViewers() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<AuthorityHolderJSON> getItems() {
                return this.viewers != null ? this.viewers : new ArrayList(0);
            }
        }
    }

    public static class HeaderVisibleGroupClient
    extends BaseClient {
        private HeaderVisibleGroupClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("headervisiblegroups"), container);
        }

        @NotNull
        public Page getHeaderVisibleGroupPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserGroupJSON addHeaderVisibleGroup(@NotNull UserGroupJSON entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserGroupJSON.class);
        }

        @NotNull
        public UserGroupJSON getHeaderVisibleGroup(@NotNull String id, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial).path(id)).get(UserGroupJSON.class);
        }

        public void removeHeaderVisibleGroup(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserGroupJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserGroupJSON> {
            @XmlElement(name="headervisiblegroups")
            private List<UserGroupJSON> headervisiblegroups;

            @NotNull
            public List<UserGroupJSON> getHeadervisiblegroups() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserGroupJSON> getItems() {
                return this.headervisiblegroups != null ? this.headervisiblegroups : new ArrayList(0);
            }
        }
    }

    public static class DefaultRoleClient
    extends BaseClient {
        private DefaultRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("defaultroles"), container);
        }

        @NotNull
        public Page getDefaultRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Role> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public RoleJSON addDefaultRole(@NotNull RoleJSON entity, @Nullable FieldPartial<Partial.Role> partial) {
            return (RoleJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), RoleJSON.class);
        }

        @NotNull
        public RoleJSON getDefaultRole(@NotNull String id, @Nullable FieldPartial<Partial.Role> partial) {
            return (RoleJSON)this.prepare(this.apply(partial).path(id)).get(RoleJSON.class);
        }

        public void removeDefaultRole(@NotNull String id) {
            this.prepare(this.path(id)).delete(RoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<RoleJSON> {
            @XmlElement(name="defaultroles")
            private List<RoleJSON> defaultroles;

            @NotNull
            public List<RoleJSON> getDefaultroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<RoleJSON> getItems() {
                return this.defaultroles != null ? this.defaultroles : new ArrayList(0);
            }
        }
    }

    public static class PermissionClient
    extends BaseClient {
        private PermissionClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("permissions"), container);
        }

        @NotNull
        public Page getPermissionPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Permission> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public PermissionJSON addPermission(@NotNull PermissionJSON entity, @Nullable FieldPartial<Partial.Permission> partial) {
            return (PermissionJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), PermissionJSON.class);
        }

        @NotNull
        public PermissionJSON getPermission(@NotNull String id, @Nullable FieldPartial<Partial.Permission> partial) {
            return (PermissionJSON)this.prepare(this.apply(partial).path(id)).get(PermissionJSON.class);
        }

        public void removePermission(@NotNull String id) {
            this.prepare(this.path(id)).delete(PermissionJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<PermissionJSON> {
            @XmlElement(name="permissions")
            private List<PermissionJSON> permissions;

            @NotNull
            public List<PermissionJSON> getPermissions() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<PermissionJSON> getItems() {
                return this.permissions != null ? this.permissions : new ArrayList(0);
            }
        }
    }

    public static class ResourceClient
    extends BaseClient {
        private ResourceClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("resources"), container);
        }

        @NotNull
        public Page getResourcePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Resource> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ResourceJSON addResource(@NotNull ResourceJSON entity, @Nullable FieldPartial<Partial.Resource> partial) {
            return (ResourceJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ResourceJSON.class);
        }

        @NotNull
        public ResourceJSON getResource(@NotNull String id, @Nullable FieldPartial<Partial.Resource> partial) {
            return (ResourceJSON)this.prepare(this.apply(partial).path(id)).get(ResourceJSON.class);
        }

        public void removeResource(@NotNull String id) {
            this.prepare(this.path(id)).delete(ResourceJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ResourceJSON> {
            @XmlElement(name="resources")
            private List<ResourceJSON> resources;

            @NotNull
            public List<ResourceJSON> getResources() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ResourceJSON> getItems() {
                return this.resources != null ? this.resources : new ArrayList(0);
            }
        }
    }

    public static class ProjectRoleClient
    extends BaseClient {
        private ProjectRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("projectroles"), container);
        }

        @NotNull
        public Page getProjectRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectRoleJSON addProjectRole(@NotNull ProjectRoleJSON entity, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ProjectRoleJSON.class);
        }

        @NotNull
        public ProjectRoleJSON getProjectRole(@NotNull String id, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial).path(id)).get(ProjectRoleJSON.class);
        }

        public void removeProjectRole(@NotNull String id) {
            this.prepare(this.path(id)).delete(ProjectRoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectRoleJSON> {
            @XmlElement(name="projectroles")
            private List<ProjectRoleJSON> projectroles;

            @NotNull
            public List<ProjectRoleJSON> getProjectroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectRoleJSON> getItems() {
                return this.projectroles != null ? this.projectroles : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<ServiceJSON> {
        @XmlElement(name="services")
        private List<ServiceJSON> services;

        @NotNull
        public List<ServiceJSON> getServices() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<ServiceJSON> getItems() {
            return this.services != null ? this.services : new ArrayList(0);
        }
    }
}

