/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.filter;

import java.io.IOException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.client.filter.ErrorFilter$WhenMappings;
import jetbrains.jetpass.rest.dto.ErrorJSON;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.glassfish.jersey.client.ClientResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0017\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/client/filter/ErrorFilter;", "Ljavax/ws/rs/client/ClientResponseFilter;", "()V", "createExceptionFromErrorResponse", "Ljavax/ws/rs/WebApplicationException;", "context", "Ljavax/ws/rs/client/ClientResponseContext;", "filter", "", "requestContext", "Ljavax/ws/rs/client/ClientRequestContext;", "responseContext", "jetbrains.jetpass.client.accounts"})
public final class ErrorFilter
implements ClientResponseFilter {
    public void filter(@NotNull ClientRequestContext requestContext, @NotNull ClientResponseContext responseContext) throws IOException {
        WebApplicationException responseException;
        Intrinsics.checkParameterIsNotNull((Object)requestContext, (String)"requestContext");
        Intrinsics.checkParameterIsNotNull((Object)responseContext, (String)"responseContext");
        if (!responseContext.hasEntity()) {
            return;
        }
        Response.Status.Family family = Response.Status.Family.familyOf((int)responseContext.getStatus());
        if ((Intrinsics.areEqual((Object)family, (Object)Response.Status.Family.CLIENT_ERROR) || Intrinsics.areEqual((Object)family, (Object)Response.Status.Family.SERVER_ERROR)) && (responseException = this.createExceptionFromErrorResponse(responseContext)) != null) {
            throw (Throwable)responseException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final WebApplicationException createExceptionFromErrorResponse(ClientResponseContext context) {
        WebApplicationException webApplicationException;
        Response.Status status;
        ErrorJSON entity;
        ErrorJSON errorJSON;
        if (!(context instanceof ClientResponse)) {
            return null;
        }
        try {
            ((ClientResponse)context).bufferEntity();
            errorJSON = (ErrorJSON)((ClientResponse)context).readEntity(ErrorJSON.class);
        }
        catch (Throwable t) {
            return null;
        }
        ErrorJSON errorJSON2 = entity = errorJSON;
        Intrinsics.checkExpressionValueIsNotNull((Object)errorJSON2, (String)"entity");
        String string = errorJSON2.getError_developer_message();
        if (string == null) {
            String string2;
            String string3;
            StringBuilder stringBuilder;
            String t;
            StringBuilder stringBuilder2 = new StringBuilder().append("");
            String string4 = entity.getError_field();
            if (string4 != null) {
                t = string4;
                stringBuilder = stringBuilder2;
                String it = t;
                string3 = "" + it + ' ';
                stringBuilder2 = stringBuilder;
                string2 = string3;
            } else {
                string2 = null;
            }
            t = string2;
            stringBuilder = stringBuilder2;
            String string5 = t;
            if (string5 == null) {
                string5 = "";
            }
            string3 = string5;
            string = stringBuilder.append(string3).append("").append(entity.getError_description()).toString();
        }
        String message = string;
        Response.Status status2 = status = Response.Status.fromStatusCode((int)context.getStatus());
        if (status2 != null) {
            switch (ErrorFilter$WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
                case 1: {
                    webApplicationException = (WebApplicationException)new BadRequestException(message);
                    return webApplicationException;
                }
                case 2: {
                    webApplicationException = (WebApplicationException)new NotAuthorizedException((Object)message, new Object[0]);
                    return webApplicationException;
                }
                case 3: {
                    webApplicationException = (WebApplicationException)((Object)new ForbiddenException(message));
                    return webApplicationException;
                }
                case 4: {
                    webApplicationException = (WebApplicationException)((Object)new NotFoundException(message));
                    return webApplicationException;
                }
                case 5: {
                    webApplicationException = (WebApplicationException)new NotAllowedException(message, new String[0]);
                    return webApplicationException;
                }
                case 6: {
                    webApplicationException = (WebApplicationException)new NotAcceptableException(message);
                    return webApplicationException;
                }
                case 7: {
                    webApplicationException = (WebApplicationException)new NotSupportedException(message);
                    return webApplicationException;
                }
                case 8: {
                    webApplicationException = (WebApplicationException)new InternalServerErrorException(message);
                    return webApplicationException;
                }
                case 9: {
                    webApplicationException = (WebApplicationException)new ServiceUnavailableException(message);
                    return webApplicationException;
                }
            }
        }
        webApplicationException = new WebApplicationException(message);
        return webApplicationException;
    }
}

