/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="authorityHolder")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=AuthorityHolderJSON.class)
public class AuthorityHolderJSON
implements AuthorityHolder {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="projectRoles")
    private List<ProjectRoleJSON> projectRoles;
    @XmlElement(name="transitiveProjectRoles")
    private List<ProjectRoleJSON> transitiveProjectRoles;

    public AuthorityHolderJSON() {
    }

    public AuthorityHolderJSON(@NotNull AuthorityHolder that) {
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setProjectRoles(aggregated);
        }
        if (that.getTransitiveProjectRoles() != null) {
            aggregated = new ArrayList();
            for (ProjectRole projectRole : that.getTransitiveProjectRoles()) {
                aggregated.add((AliasJSON)((Object)new ProjectRoleJSON(projectRole)));
            }
            this.setTransitiveProjectRoles(aggregated);
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Iterable<ProjectRoleJSON> getProjectRoles() {
        return this.projectRoles;
    }

    @Nullable
    public Iterable<ProjectRoleJSON> getTransitiveProjectRoles() {
        return this.transitiveProjectRoles;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = new ArrayList<String>();
        if (aliasIds != null) {
            for (String it : aliasIds) {
                this.aliasIds.add(it);
            }
        }
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = new ArrayList<AliasJSON>();
        if (aliases != null) {
            for (AliasJSON it : aliases) {
                this.aliases.add(it);
            }
        }
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setProjectRoles(@Nullable Iterable<ProjectRoleJSON> projectRoles2) {
        this.projectRoles = new ArrayList<ProjectRoleJSON>();
        if (projectRoles2 != null) {
            for (ProjectRoleJSON it : projectRoles2) {
                this.projectRoles.add(it);
            }
        }
    }

    @XmlTransient
    public void setTransitiveProjectRoles(@Nullable Iterable<ProjectRoleJSON> transitiveProjectRoles) {
        this.transitiveProjectRoles = new ArrayList<ProjectRoleJSON>();
        if (transitiveProjectRoles != null) {
            for (ProjectRoleJSON it : transitiveProjectRoles) {
                this.transitiveProjectRoles.add(it);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorityHolder)) {
            return false;
        }
        AuthorityHolder that = (AuthorityHolder)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static AuthorityHolderJSON wrap(@NotNull AuthorityHolder that) {
        if (that instanceof AuthorityHolderJSON) {
            return (AuthorityHolderJSON)that;
        }
        return new AuthorityHolderJSON(that);
    }
}

