/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.event.LinkChange;
import jetbrains.jetpass.api.event.LinkData;
import jetbrains.jetpass.rest.dto.ChangeJSON;
import jetbrains.jetpass.rest.dto.LinkDataJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="linkChange")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=LinkChangeJSON.class)
public class LinkChangeJSON
extends ChangeJSON
implements LinkChange {
    @XmlElement(name="removedItems")
    private List<String> removedItems;
    @XmlElement(name="removed")
    private List<LinkDataJSON> removed;
    @XmlElement(name="addedItems")
    private List<String> addedItems;
    @XmlElement(name="added")
    private List<LinkDataJSON> added;

    public LinkChangeJSON() {
    }

    public LinkChangeJSON(@NotNull LinkChange that) {
        ArrayList<LinkDataJSON> aggregated;
        this.setFieldName(that.getFieldName());
        this.setFieldType(that.getFieldType());
        this.setRemovedItems(that.getRemovedItems());
        if (that.getRemoved() != null) {
            aggregated = new ArrayList<LinkDataJSON>();
            for (LinkData linkData : that.getRemoved()) {
                aggregated.add(new LinkDataJSON(linkData));
            }
            this.setRemoved(aggregated);
        }
        this.setAddedItems(that.getAddedItems());
        if (that.getAdded() != null) {
            aggregated = new ArrayList();
            for (LinkData linkData : that.getAdded()) {
                aggregated.add(new LinkDataJSON(linkData));
            }
            this.setAdded(aggregated);
        }
    }

    @Override
    @Nullable
    public Iterable<String> getRemovedItems() {
        return this.removedItems;
    }

    @Nullable
    public Iterable<LinkDataJSON> getRemoved() {
        return this.removed;
    }

    @Override
    @Nullable
    public Iterable<String> getAddedItems() {
        return this.addedItems;
    }

    @Nullable
    public Iterable<LinkDataJSON> getAdded() {
        return this.added;
    }

    @XmlTransient
    public void setRemovedItems(@Nullable Iterable<String> removedItems) {
        this.removedItems = new ArrayList<String>();
        if (removedItems != null) {
            for (String it : removedItems) {
                this.removedItems.add(it);
            }
        }
    }

    @XmlTransient
    public void setRemoved(@Nullable Iterable<LinkDataJSON> removed) {
        this.removed = new ArrayList<LinkDataJSON>();
        if (removed != null) {
            for (LinkDataJSON it : removed) {
                this.removed.add(it);
            }
        }
    }

    @XmlTransient
    public void setAddedItems(@Nullable Iterable<String> addedItems) {
        this.addedItems = new ArrayList<String>();
        if (addedItems != null) {
            for (String it : addedItems) {
                this.addedItems.add(it);
            }
        }
    }

    @XmlTransient
    public void setAdded(@Nullable Iterable<LinkDataJSON> added) {
        this.added = new ArrayList<LinkDataJSON>();
        if (added != null) {
            for (LinkDataJSON it : added) {
                this.added.add(it);
            }
        }
    }

    @NotNull
    public static LinkChangeJSON wrap(@NotNull LinkChange that) {
        if (that instanceof LinkChangeJSON) {
            return (LinkChangeJSON)that;
        }
        return new LinkChangeJSON(that);
    }
}

