/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.SMTPSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.KeyStoreJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="smtpSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeName(value="smtp")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=SmtpSettingsJSON.class)
public class SmtpSettingsJSON
extends SettingsJSON
implements SMTPSettings {
    @XmlElement(name="enabled")
    private Boolean enabled;
    @XmlElement(name="host")
    private String host;
    @XmlElement(name="port")
    private Integer port;
    @XmlElement(name="protocol")
    private String protocol;
    @XmlElement(name="from")
    private String from;
    @XmlElement(name="login")
    private String login;
    @XmlElement(name="password")
    private String password;
    @XmlElement(name="passwordDefined")
    private Boolean passwordDefined;
    @XmlElement(name="keyStore")
    private KeyStoreJSON keyStore;

    public SmtpSettingsJSON() {
    }

    public SmtpSettingsJSON(@NotNull SMTPSettings that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setEnabled(that.isEnabled());
        this.setHost(that.getHost());
        this.setPort(that.getPort());
        this.setProtocol(that.getProtocol());
        this.setFrom(that.getFrom());
        this.setLogin(that.getLogin());
        this.setPassword(that.getPassword());
        if (that.getKeyStore() != null) {
            KeyStoreJSON ref = new KeyStoreJSON();
            ref.setId(that.getKeyStore().getId());
            this.setKeyStore(ref);
        }
    }

    @Override
    @Nullable
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    @Nullable
    public String getFrom() {
        return this.from;
    }

    @Override
    @Nullable
    public String getLogin() {
        return this.login;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public Boolean isPasswordDefined() {
        return this.passwordDefined;
    }

    @Override
    @Nullable
    public KeyStoreJSON getKeyStore() {
        return this.keyStore;
    }

    @XmlTransient
    public void setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
    }

    @XmlTransient
    public void setHost(@Nullable String host) {
        this.host = host;
    }

    @XmlTransient
    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    @XmlTransient
    public void setProtocol(@Nullable String protocol) {
        this.protocol = protocol;
    }

    @XmlTransient
    public void setFrom(@Nullable String from) {
        this.from = from;
    }

    @XmlTransient
    public void setLogin(@Nullable String login2) {
        this.login = login2;
    }

    @XmlTransient
    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    @XmlTransient
    public void setPasswordDefined(@Nullable Boolean passwordDefined) {
        this.passwordDefined = passwordDefined;
    }

    @XmlTransient
    public void setKeyStore(@Nullable KeyStoreJSON keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SMTPSettings)) {
            return false;
        }
        SMTPSettings that = (SMTPSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static SmtpSettingsJSON wrap(@NotNull SMTPSettings that) {
        if (that instanceof SmtpSettingsJSON) {
            return (SmtpSettingsJSON)that;
        }
        return new SmtpSettingsJSON(that);
    }
}

