/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.hub_client.util;

import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.HubServiceCheckResult;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidationException;
import com.jetbrains.bundle.util.hub.UpdaterHubServiceException;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleHubClient {
    private static final Logger LOG = LoggerFactory.getLogger(BundleHubClient.class);
    private final String myBundleServiceId;
    private final String myBundleServiceSecret;
    private BaseAccountsClient bundleServiceClient = null;
    private boolean isInternalHub;
    private final HubClientProvider myHubClientProvider;
    private final String myHubUrl;

    BundleHubClient(@NotNull HubClientProvider hubClientProvider, @NotNull String hubUrl, @NotNull String bundleServiceId, @NotNull String bundleServiceSecret, boolean isInternalHub) {
        this.myHubClientProvider = hubClientProvider;
        this.myHubUrl = hubUrl;
        this.myBundleServiceId = bundleServiceId;
        this.myBundleServiceSecret = bundleServiceSecret;
        this.isInternalHub = isInternalHub;
    }

    @Nullable
    public static BundleHubClient getBundleHubClient(@NotNull Properties internalServiceProperties) {
        boolean isInternalHubExistsAndEnabled = PropertiesBasedConfigurationHelper.getHelper().isServiceEnabled((Object)internalServiceProperties, "hub") && PropertiesBasedConfigurationHelper.getHelper().getServices((Object)internalServiceProperties).contains("hub");
        String hubUrl = internalServiceProperties.getProperty("hub-url");
        String bundleServiceId = internalServiceProperties.getProperty("bundle-hub-service-id");
        String bundleServiceSecret = internalServiceProperties.getProperty("bundle-hub-service-secret");
        String additionalKeystorePath = internalServiceProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName());
        String additionalKeystorePassword = internalServiceProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName());
        KeyStore additionalKeyStore = null;
        if (additionalKeystorePath != null) {
            try {
                additionalKeyStore = KeystoreUtil.loadKeyStoreWithoutServerPrivateKey((String)additionalKeystorePath, (String)additionalKeystorePassword);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                LOG.error("Cannot load additional keystore: " + e.getMessage());
            }
        }
        BundleHubClient bundleHubClient = null;
        if (isInternalHubExistsAndEnabled) {
            String externalHubUrl = internalServiceProperties.getProperty(BundleProperty.HUB_URL.getPrefixedName());
            if (externalHubUrl != null) {
                BundleHubClient.getLogger().warn("Bundled Hub service would be used in spite of external Hub URL is set");
            }
            String internalHubUrl = PropertiesBasedConfigurationHelper.getHelper().getInternalHubUrl((Object)internalServiceProperties);
            bundleHubClient = new BundleHubClient(new HubClientProvider(additionalKeyStore, additionalKeystorePassword), internalHubUrl, bundleServiceId, bundleServiceSecret, true);
        } else if (hubUrl != null) {
            bundleHubClient = new BundleHubClient(new HubClientProvider(additionalKeyStore, additionalKeystorePassword), hubUrl, bundleServiceId, bundleServiceSecret, false);
        }
        return bundleHubClient;
    }

    @NotNull
    public static BundleHubClient getBundleHubClient(@NotNull String hubUrl, @NotNull String serviceId, @NotNull String secret, boolean isInternalHub, @NotNull HubClientProvider hubClientProvider) {
        return new BundleHubClient(hubClientProvider, hubUrl, serviceId, secret, isInternalHub);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BundleHubClient.class);
    }

    @NotNull
    public BaseAccountsClient getBundleHubAccountsClient() {
        if (this.bundleServiceClient == null) {
            Boolean canBeUsed;
            HubClient hubClient = this.getHubClient();
            HubServiceCheckResult checkResult = this.checkBundleService();
            if (checkResult.getStatus() == HubServiceCheckResult.Status.CANNOT_CHECK) {
                throw new UpdaterHubServiceException("bundle-hub-configurator", String.format("Can check existence of bundle service in Hub (%s)", hubClient.getBaseUrl()), checkResult);
            }
            Boolean exists = checkResult.exists();
            if (this.isInternalHub && exists != null && !exists.booleanValue()) {
                LOG.debug("Bundle hub service does not exist. Trying to create it...");
                try {
                    ServiceClient clientForServiceCreation = HubUtil.getAnonymousHubServiceClient(hubClient);
                    ServiceJSON serviceJSON = HubUtil.createEmptyVerifiedService(clientForServiceCreation, this.myBundleServiceId, this.myBundleServiceSecret, this.getBundleServiceName(), Collections.emptyList());
                    Boolean isVerified = serviceJSON.isTrusted();
                    LOG.debug("Bundle hub service was created: serviceId = {}, isVerified = {}", (Object)this.myBundleServiceId, (Object)isVerified);
                }
                catch (Exception e) {
                    throw new UpdaterHubServiceException("bundle-hub-configurator", String.format("Bundle hub service does not exists in Hub (%s). Attempt to create it failed: %s", hubClient.getBaseUrl(), e.getMessage()), new HubServiceCheckResult(HubServiceCheckResult.Status.NOT_EXISTS, e));
                }
                checkResult = this.checkBundleService();
                if (checkResult.getStatus() == HubServiceCheckResult.Status.CANNOT_CHECK) {
                    throw new UpdaterHubServiceException("bundle-hub-configurator", String.format("Can check existence of bundle service in Hub (%s) after creation", hubClient.getBaseUrl()), checkResult);
                }
            }
            if ((canBeUsed = checkResult.canBeUsed()) != null && !canBeUsed.booleanValue()) {
                switch (checkResult.getStatus()) {
                    case EXISTS_NOT_VERIFIED: {
                        throw new UpdaterHubServiceException("bundle-hub-configurator", String.format("Bundle service exists in Hub (%s) with id '%s', but not trusted", hubClient.getBaseUrl(), this.myBundleServiceId), checkResult);
                    }
                    case EXISTS_WRONG_SECRET: {
                        throw new UpdaterHubServiceException("bundle-hub-configurator", String.format("Bundle service exists in Hub (%s) with id '%s', but secret is wrong", hubClient.getBaseUrl(), this.myBundleServiceId), checkResult);
                    }
                    case NOT_EXISTS: {
                        throw new UpdaterHubServiceException("bundle-hub-configurator", String.format("Bundle service does not exists in Hub (%s)", hubClient.getBaseUrl()), checkResult);
                    }
                }
                throw new UpdaterHubServiceException("bundle-hub-configurator", String.format("Can not register or use bundle service in Hub (%s)", hubClient.getBaseUrl()), checkResult);
            }
            this.bundleServiceClient = HubUtil.getAccountsClientByIdAndSecret(hubClient, this.myBundleServiceId, this.myBundleServiceSecret);
        }
        return this.bundleServiceClient;
    }

    private String getBundleServiceName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        String dateTime = dateFormat.format(new Date());
        return String.format("Temporary installer service (%s)", dateTime);
    }

    @NotNull
    public ServiceClient getBundleHubServiceClient() {
        return this.getBundleHubAccountsClient().getServiceClient();
    }

    public void deleteBundleHubService() {
        HubUtil.deleteHubService(this.getHubClient(), this.myBundleServiceId, this.myBundleServiceSecret);
    }

    @NotNull
    private HubServiceCheckResult checkBundleService() {
        return HubUtil.checkService(this.getHubClient(), this.myBundleServiceId, this.myBundleServiceSecret);
    }

    public boolean isInternalHub() {
        return this.isInternalHub;
    }

    @NotNull
    public HubClient getHubClient() throws HubUrlValidationException {
        return this.myHubClientProvider.getHubClient(this.myHubUrl);
    }

    public String getHubUrl() {
        return this.myHubUrl;
    }

    public String getBundleServiceId() {
        return this.myBundleServiceId;
    }

    public String getBundleServiceSecret() {
        return this.myBundleServiceSecret;
    }
}

