/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.hub_client.util.validation;

import com.jetbrains.bundle.hub_client.util.validation.CertificateInfo;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalKeystore {
    private final Map<String, CertificateInfo> certificates = new HashMap<String, CertificateInfo>();
    @NotNull
    private final KeyStore keyStore;
    @NotNull
    private final Path keyStorePath;
    @NotNull
    private final String keyStorePassword;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AdditionalKeystore(@NotNull Path keyStorePath, @NotNull String keyStorePassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.loadKeyStore();
    }

    @NotNull
    public static KeyStore loadAsKeystore(@NotNull Properties allProperties) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        Path additionalKeystorePath = Paths.get(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName()), new String[0]);
        String additionalKeystorePassword = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        KeystoreUtil.loadToExistingKeyStore((KeyStore)keyStore, (Path)additionalKeystorePath, (String)additionalKeystorePassword);
        return keyStore;
    }

    public CertificateInfo[] getCertificates() {
        return this.certificates.values().toArray(new CertificateInfo[0]);
    }

    public Set<String> getFingerprints() {
        return this.certificates.keySet();
    }

    public CertificateInfo getCertificate(@NotNull String fingerprint) {
        return this.certificates.get(fingerprint);
    }

    public void setCertificate(@NotNull String fingerprint, @NotNull CertificateInfo info) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Certificate certificate = CertificateInfo.fromPemFormat(info.getBase64Der());
        String realFingerprint = CertificateInfo.getFingerPrint(certificate);
        if (!realFingerprint.equals(fingerprint)) {
            throw new IllegalArgumentException("Finger print does not match certificate! " + fingerprint + " given, but real fingerprint is " + realFingerprint);
        }
        String alias = AdditionalKeystore.generateCertificateAlias(certificate);
        this.keyStore.setCertificateEntry(alias, certificate);
        this.saveKeyStore();
        this.certificates.put(fingerprint, info);
    }

    public static String generateCertificateAlias(@NotNull X509Certificate certificate) {
        return certificate.getIssuerDN().toString() + "-" + certificate.getSerialNumber();
    }

    private void setKeyEntry(@NotNull String alias, @NotNull Key key, @NotNull Certificate[] chain) throws KeyStoreException {
        this.keyStore.setKeyEntry(alias, key, this.keyStorePassword.toCharArray(), chain);
    }

    public void copyKeyEntryFromAnotherKeyStore(@NotNull String alias, @NotNull KeyStore otherKeyStore, @Nullable String otherKeyStorePassword, @NotNull String otherKeyStoreAlias, @Nullable String otherKeyStoreKeyEntriesPassword) throws KeyStoreException, NoSuchAlgorithmException {
        Key key = this.getKeyFromExternalKeyStore(otherKeyStore, otherKeyStorePassword, otherKeyStoreAlias, otherKeyStoreKeyEntriesPassword);
        if (key != null) {
            Certificate[] certs = otherKeyStore.getCertificateChain(otherKeyStoreAlias);
            this.setKeyEntry(alias, key, certs);
        }
    }

    public void removeCertificate(@NotNull String fingerprint) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        CertificateInfo info = this.certificates.get(fingerprint);
        if (info != null) {
            String alias = info.getIssuer() + "-" + info.getSerial();
            this.keyStore.deleteEntry(alias);
            this.saveKeyStore();
            this.certificates.remove(fingerprint);
        }
    }

    private void loadKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeystoreUtil.loadToExistingKeyStore((KeyStore)this.keyStore, (Path)this.keyStorePath, (String)this.keyStorePassword);
        Enumeration<String> aliases = this.keyStore.aliases();
        this.certificates.clear();
        while (aliases.hasMoreElements()) {
            Certificate certificate;
            String alias = aliases.nextElement();
            if (!this.keyStore.isCertificateEntry(alias) || !((certificate = this.keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            CertificateInfo info = new CertificateInfo((X509Certificate)certificate);
            this.certificates.put(info.getFingerprintSHA1(), info);
        }
    }

    public void importKeyStore(@Nullable Path otherKeyStorePath, @Nullable String otherKeyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.importKeyStore(otherKeyStorePath, otherKeyStorePassword, otherKeyStorePassword);
    }

    public void importKeyStore(@Nullable Path otherKeyStorePath, @Nullable String otherKeyStorePassword, @Nullable String otherKeyStoreKeyEntryPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore otherKeyStore;
        if (otherKeyStorePath == null || otherKeyStorePassword == null) {
            return;
        }
        if (!Files.exists(otherKeyStorePath, new LinkOption[0])) {
            return;
        }
        try {
            otherKeyStore = KeystoreUtil.loadKeyStore((Path)otherKeyStorePath, (String)otherKeyStorePassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.logger.debug(String.format("Can not load key store from %s", otherKeyStorePath), (Throwable)e);
            return;
        }
        if (Files.notExists(this.keyStorePath, new LinkOption[0]) && !this.containsKeyEntry(otherKeyStore)) {
            try {
                KeystoreUtil.saveKeyStore((KeyStore)otherKeyStore, (Path)this.keyStorePath, (String)this.keyStorePassword);
                this.loadKeyStore();
                return;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                // empty catch block
            }
        }
        if (!this.keyStorePath.equals(otherKeyStorePath)) {
            this.importKeyStoreEntries(otherKeyStore, otherKeyStorePassword, otherKeyStoreKeyEntryPassword);
            this.saveKeyStore();
        }
    }

    private void importKeyStoreEntries(@NotNull KeyStore otherKeyStore, @NotNull String otherKeyStorePassword, @Nullable String otherKeyStoreKeyEntryPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Enumeration<String> aliases = otherKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (otherKeyStore.isCertificateEntry(alias)) {
                Certificate certificate = otherKeyStore.getCertificate(alias);
                this.keyStore.setCertificateEntry(alias, certificate);
                if (certificate instanceof X509Certificate) {
                    CertificateInfo info = new CertificateInfo((X509Certificate)certificate);
                    this.certificates.put(info.getFingerprintSHA1(), info);
                }
            }
            if (!otherKeyStore.isKeyEntry(alias)) continue;
            this.copyKeyEntryFromAnotherKeyStore(alias, otherKeyStore, otherKeyStorePassword, alias, otherKeyStoreKeyEntryPassword);
        }
    }

    private Key getKeyFromExternalKeyStore(@NotNull KeyStore otherKeyStore, @Nullable String otherKeyStorePassword, @NotNull String alias, @Nullable String otherKeyStoreKeyEntryPassword) throws KeyStoreException, NoSuchAlgorithmException {
        Key key;
        try {
            key = otherKeyStore.getKey(alias, otherKeyStoreKeyEntryPassword != null ? otherKeyStoreKeyEntryPassword.toCharArray() : null);
        }
        catch (UnrecoverableKeyException e) {
            if (otherKeyStoreKeyEntryPassword != null) {
                this.logger.debug(String.format("Key entry with alias %s can not be read with given key entry password", alias), (Throwable)e);
                key = null;
            }
            if (otherKeyStorePassword == null) {
                this.logger.debug(String.format("Key entry with alias %s can not be read without password", alias), (Throwable)e);
                key = null;
            }
            try {
                key = otherKeyStore.getKey(alias, otherKeyStorePassword.toCharArray());
            }
            catch (UnrecoverableKeyException e1) {
                this.logger.debug(String.format("Key entry with alias %s can not be read neither without password nor with keystore password", alias), (Throwable)e1);
                key = null;
            }
        }
        return key;
    }

    private boolean containsKeyEntry(@NotNull KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                return true;
            }
        }
        catch (KeyStoreException ignored) {
            this.logger.debug("failed to iterate through keystore aliases", (Throwable)ignored);
        }
        return false;
    }

    public void saveKeyStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        KeystoreUtil.saveKeyStore((KeyStore)this.keyStore, (Path)this.keyStorePath, (String)this.keyStorePassword);
    }

    @NotNull
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @NotNull
    public Path getKeyStorePath() {
        return this.keyStorePath;
    }

    @NotNull
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }
}

