/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.hub_client.util.validation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateInfo {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private X509Certificate certificate;
    private String base64Der;
    private String fingerprintSHA1;
    private Map<String, String> issuerDetails = new HashMap<String, String>();
    private Map<String, String> subjectDetails = new HashMap<String, String>();

    private CertificateInfo() {
    }

    public CertificateInfo(@NotNull X509Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        this.certificate = certificate;
        this.base64Der = CertificateInfo.toPemFormat(certificate.getEncoded());
        this.updateDetailsAndFingerprint();
    }

    private Map<String, String> extractDetails(String principal) {
        String[] properties = principal.split(",\\s*");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String property : properties) {
            String[] keyValue = property.split("=");
            if (keyValue.length != 2) continue;
            result.put(keyValue[0], keyValue[1]);
        }
        return result;
    }

    public CertificateInfo(@NotNull String certificatePem) throws CertificateException, NoSuchAlgorithmException, IOException {
        this(CertificateInfo.fromPemFormat(certificatePem));
    }

    public static String getFingerPrint(@Nullable X509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (certificate == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = certificate.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CertificateInfo.toHexString(digest);
    }

    public static String toPemFormat(byte[] bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        return "-----BEGIN CERTIFICATE-----\n" + encoder.encodeToString(bytes) + "\n" + END_CERT;
    }

    @NotNull
    public static X509Certificate fromPemFormat(@NotNull String certificatePem) throws IOException, CertificateException {
        return CertificateInfo.fromPemFormat(certificatePem, CertificateFactory.getInstance("X.509"));
    }

    @NotNull
    public static X509Certificate fromPemFormat(@NotNull String certificatePem, @NotNull CertificateFactory factory) throws IOException, CertificateException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(certificatePem.getBytes(StandardCharsets.UTF_8));){
            X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(bis);
            return x509Certificate;
        }
    }

    @NotNull
    public static List<Certificate> parseCertificates(@NotNull List<String> certPemList) throws CertificateException, IOException {
        return CertificateInfo.parseCertificates(certPemList, CertificateFactory.getInstance("X.509"));
    }

    @NotNull
    public static List<Certificate> parseCertificates(@NotNull List<String> certPemList, @NotNull CertificateFactory factory) throws CertificateException, IOException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        for (String certPem : certPemList) {
            certificates.add(CertificateInfo.fromPemFormat(certPem, factory));
        }
        return certificates;
    }

    private static String toHexString(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (byte b : bytes) {
            buf.append(hexDigits[(b & 0xF0) >> 4]);
            buf.append(hexDigits[b & 0xF]);
            if (i != bytes.length - 1) {
                buf.append(':');
            }
            ++i;
        }
        return buf.toString();
    }

    @JsonProperty
    public String getSubject() {
        return this.certificate.getSubjectDN().toString();
    }

    @JsonProperty
    public String getIssuer() {
        return this.certificate.getIssuerDN().toString();
    }

    @JsonProperty
    public Date getValidBefore() {
        return this.certificate.getNotAfter();
    }

    @JsonProperty
    public Date getValidAfter() {
        return this.certificate.getNotBefore();
    }

    @JsonProperty
    public String getFingerprintSHA1() {
        return this.fingerprintSHA1;
    }

    @JsonProperty
    public String getBase64Der() {
        return this.base64Der;
    }

    @JsonProperty
    public BigInteger getSerial() {
        return this.certificate.getSerialNumber();
    }

    @JsonIgnore
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @JsonIgnore
    public void setSubject(String ignore) {
    }

    @JsonIgnore
    public void setIssuer(String ignore) {
    }

    @JsonIgnore
    public void setValidAfter(Date ignore) {
    }

    @JsonIgnore
    public void setValidBefore(Date ignore) {
    }

    @JsonIgnore
    public void setFingerprintSHA1(String ignore) {
    }

    @JsonIgnore
    public void setSerial(BigInteger ignore) {
    }

    public void setBase64Der(String base64Der) throws IOException, CertificateException, NoSuchAlgorithmException {
        this.certificate = CertificateInfo.fromPemFormat(base64Der);
        this.base64Der = base64Der;
        this.updateDetailsAndFingerprint();
    }

    private void updateDetailsAndFingerprint() throws NoSuchAlgorithmException, CertificateEncodingException {
        this.fingerprintSHA1 = CertificateInfo.getFingerPrint(this.certificate);
        this.subjectDetails = this.extractDetails(this.certificate.getSubjectDN().toString());
        this.issuerDetails = this.extractDetails(this.certificate.getIssuerDN().toString());
    }

    @JsonProperty
    public Map<String, String> getIssuerDetails() {
        return this.issuerDetails;
    }

    @JsonIgnore
    public void setIssuerDetails(Map<String, String> issuerDetails) {
        this.issuerDetails = issuerDetails;
    }

    @JsonProperty
    public Map<String, String> getSubjectDetails() {
        return this.subjectDetails;
    }

    @JsonIgnore
    public void setSubjectDetails(Map<String, String> subjectDetails) {
        this.subjectDetails = subjectDetails;
    }
}

