/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.jetty;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.jetty.context.StartupContextProvider;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.contract.service.ConfigurableService;
import com.jetbrains.service.util.contract.service.ConfigurableServiceBase;
import com.jetbrains.service.util.contract.service.context.CommonContextProvider;
import com.jetbrains.service.util.contract.service.context.ConfiguringContextProvider;
import com.jetbrains.service.util.logging.JavaUtilLoggingToSlf4jBridge;
import com.jetbrains.service.util.logging.log4j.LoggingUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JettyServiceBase
implements ConfigurableService {
    private volatile Server myServer;
    private final AtomicReference<Status> myStatus = new AtomicReference<Status>(Status.STARTING);
    private static final long GRACEFUL_STOP_TIMEOUT_MS = 5000L;
    private CommonContextProvider myContextProvider;
    @NotNull
    private ConfigurableServiceBase myConfigurableService = this.createConfigurableService();

    public void start(@NotNull StartupContextProvider contextProvider) throws StartupException {
        this.myContextProvider = contextProvider;
        boolean isLoggingSystemConfigured = LoggingUtil.isConfigured();
        Properties properties = this.getAllProperties();
        try {
            String bundledInProperty = properties.getProperty("bundledin");
            if (bundledInProperty != null) {
                throw new StartupException("This service is configured to be started together with Bundle process. You might start entire product instead of starting this particular service separately.");
            }
            this.beforeStart(properties);
            this.configureLoggingForStarting(properties, isLoggingSystemConfigured, contextProvider);
            this.myConfigurableService.setTempDir(properties);
            this.myServer = this.createServer(properties);
            this.myStatus.set(Status.STARTING);
            this.myServer.start();
            if (!this.myServer.isStarted()) {
                throw new StartupException("Something went wrong. Server not started.");
            }
            this.myStatus.set(Status.RUNNING);
            this.onStarted(properties);
        }
        catch (Throwable ex) {
            throw new StartupException(ex.getMessage(), ex);
        }
        finally {
            this.configureLoggingAfterStarted(properties, isLoggingSystemConfigured, contextProvider);
        }
    }

    protected void beforeStart(@NotNull Properties properties) {
    }

    protected void onStarted(@NotNull Properties properties) {
    }

    private void configureLoggingForStarting(Properties properties, boolean isLoggingSystemConfigured, @NotNull CommonContextProvider contextProvider) {
        JavaUtilLoggingToSlf4jBridge.install();
        if (!isLoggingSystemConfigured) {
            this.setupLogging(properties, contextProvider.isDebugEnabled(), true);
        }
    }

    protected void configureLoggingAfterStarted(Properties properties, boolean isLoggingSystemConfigured, @NotNull StartupContextProvider contextProvider) {
        if (!isLoggingSystemConfigured) {
            this.setupLogging(properties, contextProvider.isDebugEnabled(), false);
        }
    }

    @NotNull
    public StatusDescriptor getStatus() {
        return new StatusDescriptor(this.myStatus.get(), null);
    }

    public AppExitCode shutdown(boolean force, AppExitCode suggestedExitCode) {
        if (this.myServer != null) {
            this.getLogger().info(String.format("Stopping %s", this.myConfigurableService.getServicePresentableName(this.myConfigurableService.getAllProperties(this.getContextProvider()))));
            this.myStatus.set(Status.SHUTTING_DOWN);
            this.myServer.setStopTimeout(force ? 0L : 5000L);
            try {
                this.myServer.stop();
            }
            catch (Throwable e) {
                this.getLogger().error("Could not stop Jetty", e);
            }
            this.myServer = null;
            this.myContextProvider = null;
        }
        return suggestedExitCode;
    }

    @NotNull
    protected abstract Server createServer(Properties var1) throws Exception;

    @NotNull
    protected abstract String getLogFileName(Properties var1);

    private void setupLogging(Properties properties, boolean enableDebugMessages, boolean consoleLogging) {
        String logsDir = this.myConfigurableService.getMandatoryProperty(ServiceProperties.LOGS_DIR_PROPERTY, properties);
        File logPath = new File(logsDir, this.getLogFileName(properties));
        LoggingUtil.setupLogging((boolean)enableDebugMessages, (File)logPath, (boolean)consoleLogging);
    }

    protected final Server getServer() {
        return this.myServer;
    }

    protected final void setInitParameters(Properties properties, ContextHandler contentHandler) {
        for (String propName : properties.stringPropertyNames()) {
            contentHandler.setInitParameter(propName, properties.getProperty(propName));
        }
        contentHandler.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        String gzipEnable = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, "gzip-enable");
        String preCompressedFormats = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, "pre-compressed-formats");
        if (preCompressedFormats != null) {
            contentHandler.setInitParameter("org.eclipse.jetty.servlet.Default.precompressed", preCompressedFormats);
        } else if (Boolean.parseBoolean(gzipEnable)) {
            contentHandler.setInitParameter("org.eclipse.jetty.servlet.Default.precompressed", "true");
        }
        contentHandler.setInitParameter("is-debug-mode", Boolean.valueOf(this.isDebugEnabled()).toString());
    }

    public void configure(@NotNull ConfiguringContextProvider contextProvider) {
        this.myConfigurableService.configure(contextProvider);
    }

    @NotNull
    protected ConfigurableServiceBase createConfigurableService() {
        return new ConfigurableServiceBase();
    }

    @NotNull
    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    protected final CommonContextProvider getContextProvider() {
        if (this.myContextProvider == null) {
            throw new RuntimeException("ContextProvider has not been initialized yet");
        }
        return this.myContextProvider;
    }

    @NotNull
    protected File getServiceHome() {
        return this.getContextProvider().getServiceHome();
    }

    protected boolean isDebugEnabled() {
        return this.getContextProvider().isDebugEnabled();
    }

    @NotNull
    protected String getServicePresentableName(@NotNull Properties serviceProperties) {
        return this.myConfigurableService.getMandatoryProperty("presentation-service-name", serviceProperties);
    }

    @NotNull
    public Properties getAllProperties() {
        return this.myConfigurableService.getAllProperties(this.getContextProvider());
    }

    @NotNull
    public final String getMandatoryProperty(@NotNull String propertyName, @NotNull Properties properties) {
        return this.myConfigurableService.getMandatoryProperty(propertyName, properties);
    }

    @NotNull
    protected ConfigurableServiceBase getConfigurableService() {
        return this.myConfigurableService;
    }
}

