/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.servlet.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public interface InvalidationPolicy {
    public boolean isModified();

    public long lastModified();

    public static class SimpleInvalidationPolicy
    implements InvalidationPolicy {
        private final URL url;
        private volatile long lastModified;

        public SimpleInvalidationPolicy(URL url) throws FileNotFoundException {
            this.url = url;
            File file = this.getFileIfModified(-1L);
            if (file == null) {
                throw new FileNotFoundException("File not found or invalid. Path " + url.toString());
            }
            this.lastModified = file.lastModified();
        }

        @Override
        public boolean isModified() {
            long lastModified = this.lastModified;
            return this.lastModified() != lastModified;
        }

        @Override
        public long lastModified() {
            long lastModified = this.lastModified;
            File file = this.getFileIfModified(lastModified);
            if (file != null) {
                this.lastModified = lastModified = file.lastModified();
            }
            return lastModified;
        }

        protected File getFileIfModified(long since) {
            URI uri;
            try {
                uri = this.url.toURI();
            }
            catch (URISyntaxException e) {
                return null;
            }
            File file = new File(uri);
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                return null;
            }
            if (file.lastModified() <= since) {
                return null;
            }
            return file;
        }
    }

    public static class NeverInvalidationPolicy
    implements InvalidationPolicy {
        private static final long LAST_MODIFIED = System.currentTimeMillis();

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public long lastModified() {
            return LAST_MODIFIED;
        }
    }
}

