/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.cmd;

import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.cmd.DefaultProcessExecutor;
import com.jetbrains.service.util.cmd.ExecutionContext;
import com.jetbrains.service.util.cmd.ExecutionResult;
import com.jetbrains.service.util.cmd.LogStreamThread;
import com.jetbrains.service.util.cmd.ProcessExecutor;
import com.jetbrains.service.util.cmd.WaitThread;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdUtil {
    private static final String CMD_EXTENSION = ".cmd";
    private static final String BAT_EXTENSION = ".bat";
    private static final String SH_EXTENSION = ".sh";
    private static final int DEFAULT_MAX_COMMAND_EXECUTION_TIME_MS = 300000;
    private static final int DEFAULT_WAIT_FOR_OUTPUT_MS = 200;
    private static final boolean DEFAULT_LOG_OUTPUT_TO_CONSOLE = true;
    private static final boolean DEFAULT_LOG_ERROR_TO_CONSOLE = true;
    private static final boolean DEFAULT_COLLECT_OUTPUT = true;
    private static final Logger LOG = LoggerFactory.getLogger(CmdUtil.class);

    @NotNull
    public static String buildCommand(@NotNull String cmd, @NotNull Collection<String> commandArguments) {
        CommandLine commandLine = new CommandLine(cmd);
        commandLine.addArguments(commandArguments.toArray(new String[commandArguments.size()]));
        return commandLine.toString();
    }

    @NotNull
    public static ExecutionResult executeCommandWithExitCode(@NotNull String scriptName, Path directory, @Nullable String cmdCaller, List<String> commandArguments, List<String> additionalArguments) {
        return CmdUtil.executeCommandWithExitCode(scriptName, directory, cmdCaller, commandArguments, additionalArguments, null);
    }

    @Deprecated
    @NotNull
    public static ExecutionResult executeCommandWithExitCode(@NotNull String scriptName, Path directory, @Nullable String cmdCaller, List<String> commandArguments, List<String> additionalArguments, int executionTimeout, int outputWaitTimeout, boolean logOutputToConsole) {
        ExecutionContext context = new ExecutionContext();
        context.put(ExecutionContext.Param.executionTimeoutInMillis, executionTimeout);
        context.put(ExecutionContext.Param.outputWaitTimeoutInMillis, outputWaitTimeout);
        context.put(ExecutionContext.Param.logOutputToConsole, logOutputToConsole);
        return CmdUtil.executeCommandWithExitCode(scriptName, directory, cmdCaller, commandArguments, additionalArguments, context);
    }

    @NotNull
    public static ExecutionResult executeCommandWithExitCode(@NotNull String scriptName, Path directory, @Nullable String cmdCaller, List<String> commandArguments, @NotNull List<String> additionalArguments, ExecutionContext context) {
        DefaultProcessExecutor processBuilder = new DefaultProcessExecutor(scriptName, directory, commandArguments, additionalArguments);
        return CmdUtil.executeCommandWithExitCode(cmdCaller, context, processBuilder);
    }

    @NotNull
    public static ExecutionResult executeCommandWithExitCode(@Nullable String cmdCaller, ExecutionContext context, ProcessExecutor processExecutor) {
        int executionTimeout = context != null ? context.get(ExecutionContext.Param.executionTimeoutInMillis, 300000) : 300000;
        int outputWaitTimeout = context != null ? context.get(ExecutionContext.Param.outputWaitTimeoutInMillis, 200) : 200;
        boolean logOutputToConsole = context != null ? context.get(ExecutionContext.Param.logOutputToConsole, true) : true;
        boolean logErrorToConsole = context != null ? context.get(ExecutionContext.Param.logErrorToConsole, true) : true;
        boolean collectOutput = context != null ? context.get(ExecutionContext.Param.collectOutput, true) : true;
        String commandLineStringRepresentation = CmdUtil.commandToString(processExecutor.getCommandLine());
        LOG.debug("Executing " + commandLineStringRepresentation + " in directory [" + processExecutor.getWorkDirectory() + "]");
        try {
            Process p = processExecutor.start();
            String outputPrefix = cmdCaller != null && !cmdCaller.trim().isEmpty() ? cmdCaller + ": " : "";
            LogStreamThread errLogger = new LogStreamThread(p.getErrorStream(), logErrorToConsole, outputPrefix, collectOutput);
            errLogger.setName("ErrLoggerFor:" + cmdCaller);
            errLogger.start();
            LogStreamThread outLogger = new LogStreamThread(p.getInputStream(), logOutputToConsole, outputPrefix, collectOutput);
            outLogger.setName("OutLoggerFor:" + cmdCaller);
            outLogger.start();
            p.getOutputStream().close();
            WaitThread waitThread = new WaitThread(p);
            waitThread.setName("Wait:" + cmdCaller);
            waitThread.start();
            waitThread.join(executionTimeout);
            if (waitThread.isAlive()) {
                p.destroy();
                waitThread.join(executionTimeout);
                if (waitThread.isAlive()) {
                    throw new RuntimeException("Unable to kill process (in timeout state): " + commandLineStringRepresentation);
                }
                throw new StatusException("Timeout running process: " + commandLineStringRepresentation);
            }
            errLogger.join(outputWaitTimeout);
            outLogger.join(outputWaitTimeout);
            errLogger.setInterruptFlag();
            outLogger.setInterruptFlag();
            errLogger.join();
            outLogger.join();
            if (waitThread.isInterruptedFlagSet()) {
                throw new StatusException("Wait Thread was interrupted: " + commandLineStringRepresentation);
            }
            if (errLogger.isFailed()) {
                throw new StatusException("Err Logger failed: " + commandLineStringRepresentation);
            }
            if (outLogger.isFailed()) {
                throw new StatusException("Out Input Thread failed: " + commandLineStringRepresentation);
            }
            ExecutionResult executionResult = new ExecutionResult(waitThread.getExitCode(), outLogger.getOutputString(), errLogger.getOutputString());
            LOG.debug(String.format("Command [%s] exited with code %s and output: [%s]%s", commandLineStringRepresentation, executionResult.exitCode, executionResult.myCommandOutput, !executionResult.myCommandError.isEmpty() ? "," + System.lineSeparator() + "error: [" + executionResult.myCommandError + "]" : ""));
            return executionResult;
        }
        catch (IOException e) {
            throw new StatusException("Error executing command " + commandLineStringRepresentation + ": " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new StatusException("Interrupted execution of " + commandLineStringRepresentation, e);
        }
    }

    @NotNull
    public static String commandToString(List<String> commandLine) {
        return "[" + ConfiguratorUtils.join(commandLine, ", ") + "]";
    }

    static CommandLine constructCommandLine(String scriptName) {
        CommandLine commandLine;
        if (SystemUtil.isWindows()) {
            commandLine = new CommandLine("cmd");
            commandLine.addArguments(new String[]{"/C", scriptName});
        } else {
            commandLine = new CommandLine(scriptName);
        }
        return commandLine;
    }

    @NotNull
    public static String getScriptName(Path workingDirectory, String basename) {
        if (SystemUtil.isWindows()) {
            String patchedBaseName = basename.replace('/', File.separatorChar);
            String cmdName = patchedBaseName + CMD_EXTENSION;
            Path cmdScript = workingDirectory.resolve(cmdName);
            if (Files.isReadable(cmdScript)) {
                return cmdName;
            }
            String batName = patchedBaseName + BAT_EXTENSION;
            Path batScript = workingDirectory.resolve(batName);
            if (Files.isReadable(batScript)) {
                return batName;
            }
        } else {
            String shName = basename + SH_EXTENSION;
            Path shScript = workingDirectory.resolve(shName);
            if (Files.isReadable(shScript)) {
                return shName;
            }
        }
        throw new StatusException("Unable to find script " + basename + " under " + workingDirectory + " with standard extensions");
    }

    public static class CommandLine {
        private final String executable;
        private Vector<String> arguments = new Vector();

        CommandLine(@NotNull String executable) {
            this.executable = this.cleanExecutable(executable);
        }

        private String cleanExecutable(@NotNull String executable) {
            if (executable.trim().length() == 0) {
                throw new IllegalArgumentException("Executable can not be empty");
            }
            return executable.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }

        CommandLine addArguments(@Nullable String[] arguments) {
            if (arguments == null) {
                return this;
            }
            for (String argument : arguments) {
                this.addArgument(argument);
            }
            return this;
        }

        void addArgument(String argument) {
            if (argument == null) {
                return;
            }
            this.arguments.add(argument);
        }

        @NotNull
        String[] toStrings() {
            String[] result = new String[this.arguments.size() + 1];
            result[0] = this.executable;
            System.arraycopy(this.arguments.toArray(new String[this.arguments.size()]), 0, result, 1, result.length - 1);
            return result;
        }

        public String toString() {
            return CmdUtil.commandToString(Arrays.asList(this.toStrings()));
        }
    }
}

