/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.ssl;

import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.properties.ServiceConfigurationHelper;
import com.jetbrains.service.util.ssl.CompositeX509KeyManager;
import com.jetbrains.service.util.ssl.CompositeX509TrustManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeystoreUtil {
    public static final String SERVER_CERT_ADDITIONAL_KEYSTORE_ALIAS = "secureKeyStoreAlias";

    @NotNull
    public static SSLContext buildSSLContext(@NotNull String additionalKeyStorePath, @Nullable String additionalKeystorePassword) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        KeyStore additionalKeyStore = KeystoreUtil.loadKeyStoreWithoutServerPrivateKey(additionalKeyStorePath, additionalKeystorePassword);
        CompositeX509KeyManager compositeX509KeyManager = additionalKeystorePassword != null ? KeystoreUtil.buildCompositeKeyManager(additionalKeyStore, additionalKeystorePassword, null) : KeystoreUtil.buildCompositeKeyManager(null, null, null);
        CompositeX509TrustManager compositeX509TrustManager = KeystoreUtil.buildCompositeTrustManager(new KeyStore[]{additionalKeyStore, null});
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(new KeyManager[]{compositeX509KeyManager}, new TrustManager[]{compositeX509TrustManager}, null);
        return context;
    }

    @Nullable
    public static <T> SSLContext buildSSLContext(@NotNull ServiceConfigurationHelper<T> propertiesHelper, @NotNull T properties) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        String additionalKeyStorePath = propertiesHelper.getServiceProperty(properties, BundleProperty.ADDITIONAL_KEYSTORE_PATH.getPrefixedName());
        if (additionalKeyStorePath != null) {
            String keyStorePassword = propertiesHelper.getServiceProperty(properties, BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getPrefixedName());
            return KeystoreUtil.buildSSLContext(additionalKeyStorePath, keyStorePassword);
        }
        return null;
    }

    @NotNull
    public static KeyStore loadKeyStoreWithoutServerPrivateKey(@NotNull String keyStorePathAsString, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeystoreUtil.loadKeyStore(Paths.get(keyStorePathAsString, new String[0]), storePassword);
        KeystoreUtil.removeServerPrivateKey(keyStore);
        return keyStore;
    }

    @NotNull
    public static KeyStore removeServerPrivateKey(@NotNull KeyStore keyStore) throws KeyStoreException {
        for (String alias : Collections.list(keyStore.aliases())) {
            if (alias == null || !alias.equalsIgnoreCase(SERVER_CERT_ADDITIONAL_KEYSTORE_ALIAS) || !keyStore.isKeyEntry(alias)) continue;
            Certificate[] certs = keyStore.getCertificateChain(alias);
            keyStore.deleteEntry(alias);
            if (certs == null) continue;
            for (int i = 0; i < certs.length; ++i) {
                keyStore.setCertificateEntry(alias + i, certs[i]);
            }
        }
        return keyStore;
    }

    @NotNull
    public static KeyStore loadKeyStore(@NotNull Path keyStorePath, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        KeystoreUtil.loadToExistingKeyStore(keyStore, keyStorePath, storePassword);
        return keyStore;
    }

    public static void loadToExistingKeyStore(@NotNull KeyStore keyStore, @NotNull Path keyStorePath, @Nullable String storePassword) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (!Files.exists(keyStorePath, new LinkOption[0])) {
            keyStore.load(null, null);
        } else {
            try (FileInputStream fis = new FileInputStream(keyStorePath.toFile());){
                char[] password = storePassword != null ? storePassword.toCharArray() : null;
                keyStore.load(fis, password);
            }
        }
    }

    public static void saveKeyStore(@NotNull KeyStore keyStore, @NotNull String keyStorePathAsString, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeystoreUtil.saveKeyStore(keyStore, Paths.get(keyStorePathAsString, new String[0]), storePassword);
    }

    public static void saveKeyStore(@NotNull KeyStore keyStore, @NotNull Path keyStorePath, @Nullable String storePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Path keystoreParentPath = keyStorePath.getParent();
        if (keystoreParentPath != null && Files.notExists(keystoreParentPath, new LinkOption[0])) {
            Files.createDirectories(keystoreParentPath, new FileAttribute[0]);
        }
        char[] password = storePassword != null ? storePassword.toCharArray() : null;
        try (FileOutputStream out = new FileOutputStream(keyStorePath.toFile());){
            keyStore.store(out, password);
        }
    }

    @NotNull
    public static CompositeX509TrustManager buildCompositeTrustManager(@NotNull KeyStore[] keyStores) throws NoSuchAlgorithmException, KeyStoreException {
        ArrayList<X509TrustManager> managers = new ArrayList<X509TrustManager>();
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        X509TrustManager jvmTrustManager = KeystoreUtil.getTrustManager(defaultAlgorithm, null);
        managers.add(jvmTrustManager);
        for (KeyStore keyStore : keyStores) {
            if (keyStore == null) continue;
            managers.add(KeystoreUtil.getTrustManager(defaultAlgorithm, keyStore));
        }
        return new CompositeX509TrustManager(managers.toArray(new X509TrustManager[0]));
    }

    @NotNull
    public static CompositeX509KeyManager buildCompositeKeyManager(@Nullable KeyStore additionalKeyStore, @Nullable String additionalKeyStorePassword, @Nullable KeyStore temporaryKeyStore) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        ArrayList<X509KeyManager> managers = new ArrayList<X509KeyManager>();
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        X509KeyManager jvmKeyManager = KeystoreUtil.getKeyManager(defaultAlgorithm, null, null);
        managers.add(jvmKeyManager);
        if (temporaryKeyStore != null) {
            managers.add(KeystoreUtil.getKeyManager(KeyManagerFactory.getDefaultAlgorithm(), temporaryKeyStore, additionalKeyStorePassword));
        }
        if (additionalKeyStore != null && additionalKeyStorePassword != null) {
            managers.add(KeystoreUtil.getKeyManager(KeyManagerFactory.getDefaultAlgorithm(), additionalKeyStore, additionalKeyStorePassword));
        }
        return new CompositeX509KeyManager(managers.toArray(new X509KeyManager[0]));
    }

    @Nullable
    public static X509KeyManager getKeyManager(@NotNull String algorithm, @Nullable KeyStore keystore, @Nullable String keyPassword) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManager[] keyManagers;
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        char[] password = keyPassword != null ? keyPassword.toCharArray() : null;
        factory.init(keystore, password);
        for (KeyManager keyManager : keyManagers = factory.getKeyManagers()) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        return null;
    }

    @Nullable
    public static X509TrustManager getTrustManager(@NotNull String algorithm, @Nullable KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustManagers;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(keystore);
        for (TrustManager trustManager : trustManagers = factory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }
}

