/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.links.persistent;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeImpl;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeRegisterUtil;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeService;
import jetbrains.charisma.links.persistent.LinkAssociationsCache;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityAdapter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IssueLinkPrototypeAuditListener
extends EntityAdapter<Entity> {
    private static final Log securityLog = LogFactory.getLog((String)"security");

    public void addedSync(Entity added) {
        IssueLinkPrototypeRegisterUtil.registerPrototype(added);
        securityLog.info((Object)("issue link prototype " + ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)added, (String)"IssueLinkPrototype")).getNameWithIdAndRoles(added) + " created"));
        ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).refresh();
        super.addedSync(added);
    }

    public void updatedSync(Entity old, Entity current) {
        if (EntityOperations.hasChangesExcepting((TransientEntity)((TransientEntity)old), (String[])new String[0])) {
            securityLog.info((Object)("issue link prototype " + ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)old, (String)"IssueLinkPrototype")).getNameWithIdAndRoles(old) + " changed to " + ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)current, (String)"IssueLinkPrototype")).getNameWithIdAndRoles(current)));
        }
        ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).refresh();
        super.updatedAsync(old, current);
    }

    public void removedSyncAfterConstraints(Entity removed) {
        securityLog.info((Object)("issue link prototype " + ((IssueLinkPrototypeImpl)DnqUtils.getPersistentClassInstance((Entity)removed, (String)"IssueLinkPrototype")).getNameWithIdAndRoles(removed) + " removed"));
        super.removedSyncBeforeFlush(removed);
        ((IssueLinkPrototypeService)ServiceLocator.getBean((String)"issueLinkPrototypeService")).clearIssueLinks(removed);
        IssueLinkPrototypeRegisterUtil.unRegisterPrototype(removed);
    }

    public void removedSync(Entity removed) {
        ((LinkAssociationsCache)ServiceLocator.getBean((String)"linkAssociationsCache")).refresh();
        super.removedSync(removed);
    }
}

