/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.Arrays;
import java.util.Map;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.CentralManager;

public class ConfigurationUtil {
    public static final String TEST_MODE = "jetbrains.youtrack.testMode";
    private static final String SUPPORT_EMAIL_PROPERTY = "jetbrains.youtrack.support.email";
    private static final String HOSTED_SUPPORT_EMAIL_DEFAULT = "youtrack-incloud-support@jetbrains.com";
    private static final String SUPPORT_EMAIL_DEFAULT = "youtrack-feedback@jetbrains.com";
    public static final int MAX_TIMEOUT_FOR_HOSTED_YOUTRACK = 60;
    public static String FILE_UPLOAD_UPPER_LIMIT = "jetbrains.youtrack.fileUploadUpperLimit";
    protected static Log log = LogFactory.getLog(ConfigurationUtil.class);

    public static void parseConfiguration(final Map<String, String> params) {
        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

            public void invoke() {
                Entity nc = (Entity)ServiceLocator.getBean((String)"notificationsConfig");
                for (ConfigurationParameter cp : Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])ConfigurationParameter.values()))) {
                    try {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Apply config parameter [" + Arrays.toString(cp.getKey()) + "]"));
                        }
                        cp.apply(params, nc);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"Error appling config parameter", (Throwable)e);
                    }
                }
                ConfigurationUtil.validateSmtpConfig(nc);
                ConfigurationUtil.validateJabberConfig(nc);
            }
        });
    }

    public static void validateJabberConfig(Entity nc) {
        if (!(!((Boolean)PrimitiveAssociationSemantics.get((Entity)nc, (String)"enableJabber", Boolean.class, null)).booleanValue() || ConfigurationUtil.isYoutrackHosted() && ((Boolean)PrimitiveAssociationSemantics.get((Entity)nc, (String)"defaultJabber", Boolean.class, null)).booleanValue())) {
            if (ConfigurationUtil.isEmpty_z2negs_a0a0a0b((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberServer", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_server_is_required", new Object[0]));
            }
            if (ConfigurationUtil.isEmpty_z2negs_a0b0a0b((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberLogin", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_from_is_required", new Object[0]));
            }
            if (ConfigurationUtil.isEmpty_z2negs_a0c0a0b((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberPassword", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_password_is_required", new Object[0]));
            }
            if ((Integer)PrimitiveAssociationSemantics.get((Entity)nc, (String)"jabberPort", Integer.class, null) <= 0) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Jabber_port_is_required", new Object[0]));
            }
        }
    }

    public static void validateSmtpConfig(Entity nc) {
        if (!(!((Boolean)PrimitiveAssociationSemantics.get((Entity)nc, (String)"enableSmtp", Boolean.class, null)).booleanValue() || ConfigurationUtil.isYoutrackHosted() && ((Boolean)PrimitiveAssociationSemantics.get((Entity)nc, (String)"defaultSmtp", Boolean.class, null)).booleanValue())) {
            if (ConfigurationUtil.isEmpty_z2negs_a0a0a0c((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"smtpHost", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.SMTP_host_is_required", new Object[0]));
            }
            if (ConfigurationUtil.isEmpty_z2negs_a0b0a0c((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"smtpFrom", String.class, null))) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.SMTP_from_is_required", new Object[0]));
            }
            if ((Integer)PrimitiveAssociationSemantics.get((Entity)nc, (String)"smtpPort", Integer.class, null) <= 0) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.SMTP_port_is_required", new Object[0]));
            }
        }
    }

    public static void validateBaseUrl(Entity nc) {
        if (ConfigurationUtil.isEmpty_z2negs_a0a0d((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"baseUrl", String.class, null))) {
            throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Base_URL_must_be_not_empty", new Object[0]));
        }
        if (((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"baseUrl", String.class, null)).endsWith("/") || ((String)PrimitiveAssociationSemantics.get((Entity)nc, (String)"baseUrl", String.class, null)).endsWith("\\")) {
            throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConfigurationUtil.Base_URL_can_t_end_with_a_slash", new Object[0]));
        }
    }

    public static boolean isYoutrackHosted() {
        return Boolean.getBoolean("jetbrains.youtrack.hosted");
    }

    public static String getSupportEmail() {
        String supportEmail = ConfigurationUtil.isYoutrackHosted() ? HOSTED_SUPPORT_EMAIL_DEFAULT : SUPPORT_EMAIL_DEFAULT;
        supportEmail = System.getProperty(SUPPORT_EMAIL_PROPERTY, supportEmail);
        return supportEmail;
    }

    public static String getSupportUrl() {
        StringBuilder sb = new StringBuilder("http://www.jetbrains.com/support/youtrack?version=");
        sb.append(((CentralManager)ServiceLocator.getBean((String)"centralManager")).getAppicationVersion());
        if (ConfigurationUtil.isYoutrackHosted()) {
            sb.append("&hostedInstance=" + PrimitiveAssociationSemantics.getBlobAsString((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"domain"));
        }
        return sb.toString();
    }

    public static boolean isTestMode() {
        return Boolean.getBoolean(TEST_MODE);
    }

    public static void setTestMode(boolean testMode) {
        System.setProperty(TEST_MODE, testMode + "");
    }

    public static boolean isEmpty_z2negs_a0a0a0b(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0b0a0b(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0c0a0b(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0a0a0c(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0b0a0c(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_z2negs_a0a0d(String str) {
        return str == null || str.length() == 0;
    }
}

