/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.misc;

import java.io.IOException;
import java.io.InputStream;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOrderedEntitiesIterator<T extends Entity>
extends EntityIteratorBase
implements PropertyValueIterator {
    private static ThreadLocal<_FunctionTypes._void_P1_E0<? super Long>> NUMBER_OF_ORDERED_CALLBACK;
    private long nextId = -2L;
    private Long currentValue;
    private int entityTypeId;
    protected InputStream is;

    public AbstractOrderedEntitiesIterator(EntityIterableBase iterable, InputStream is, int entityTypeId) {
        super(iterable);
        this.entityTypeId = entityTypeId;
        this.is = is;
    }

    public final void remove() {
        throw new UnsupportedOperationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AbstractOrderedEntitiesIterator.Elements_removal_not_supported", new Object[0]));
    }

    private void storeNextId() {
        try {
            this.nextId = this.gimmeNextId();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract long gimmeNextId() throws IOException;

    public boolean shouldBeDisposed() {
        return true;
    }

    public boolean dispose() {
        boolean tbd = super.dispose();
        if (tbd) {
            try {
                this.is.close();
                return true;
            }
            catch (IOException e) {
                throw new ExodusException((Throwable)e);
            }
        }
        return tbd;
    }

    public final boolean skip(int i) {
        if (i < 0) {
            throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AbstractOrderedEntitiesIterator.Only_non-negative_argument_is_allowed", new Object[0]));
        }
        if (i > 0) {
            try {
                this.doSkip(i - 1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.storeNextId();
        }
        return this.hasNextImpl();
    }

    @Nullable
    public Comparable currentValue() {
        return this.currentValue;
    }

    protected abstract void doSkip(int var1) throws IOException;

    @Nullable
    protected EntityId nextIdImpl() throws ExodusException {
        PersistentEntityId id = new PersistentEntityId(this.entityTypeId, this.nextId);
        this.currentValue = this.nextId;
        this.storeNextId();
        return id;
    }

    protected boolean hasNextImpl() throws ExodusException {
        if (this.nextId == -2L) {
            this.storeNextId();
        }
        if (this.nextId == -1L) {
            this.currentValue = null;
            return false;
        }
        return true;
    }
}

