/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.SimplePropertyValidationException;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class BadCharsException
extends SimplePropertyValidationException {
    private String restrictedChars;

    public BadCharsException(TransientEntity entity, String propertyName, String displayPropertyName, String restrictedChars) {
        super(BadCharsException.buildMessage(displayPropertyName, restrictedChars), BadCharsException.buildMessage(displayPropertyName, restrictedChars), entity, propertyName);
        this.restrictedChars = restrictedChars;
    }

    public String getRestrictedChars() {
        return this.restrictedChars;
    }

    private static String buildMessage(String displayPropertyName, String restrictedChars) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < restrictedChars.length(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append('\"').append(restrictedChars.charAt(i)).append('\"');
        }
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("BadCharsException.{name}_shouldn_t_contain_characters_{list_of_characters}{amount_of_characters_for_plurality}", new Object[]{displayPropertyName, builder.toString(), restrictedChars.length()});
    }
}

