/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;

public class Base64Attach {
    protected static Log log = LogFactory.getLog(Base64Attach.class);
    private final byte[] content;
    private final String name;
    private final String mimeType;

    private Base64Attach(byte[] content, String name, String mimeType) {
        this.content = content;
        this.name = name;
        this.mimeType = mimeType;
    }

    public long getSize() {
        return this.content.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.content);
    }

    public String getName() {
        return this.name;
    }

    public String toBase64String() {
        String value = new String(Base64.encodeBase64((byte[])this.content));
        if (value == null) {
            return null;
        }
        String prefix = "data:";
        String separator = ";base64,";
        StringBuilder builder = new StringBuilder("data:");
        builder.append(this.mimeType);
        builder.append(";base64,");
        builder.append(value);
        return builder.toString();
    }

    @Nullable
    public static Base64Attach createFromString(@Nullable String base64String) {
        if (base64String == null) {
            return null;
        }
        Tuples._2<String, byte[]> data = Base64Attach.splitToMimeTypeAndContent(base64String);
        if (data == null) {
            return null;
        }
        String name = ((String)data._0()).replaceAll("/", ".");
        return new Base64Attach((byte[])data._1(), name, (String)data._0());
    }

    @Nullable
    public static Base64Attach createFromIssueAttachment(Entity attachment) {
        InputStream content = PrimitiveAssociationSemantics.getBlob((Entity)attachment, (String)"content");
        if (content == null) {
            return null;
        }
        return Base64Attach.createFromStream(content, (String)PrimitiveAssociationSemantics.get((Entity)attachment, (String)"name", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)attachment, (String)"mimeType", String.class, null));
    }

    public static Base64Attach createFromStream(InputStream stream, String name, String mimetype) {
        try {
            return new Base64Attach(IOUtils.toByteArray((InputStream)stream), name, mimetype);
        }
        catch (IOException exception) {
            return null;
        }
    }

    @Nullable
    private static Tuples._2<String, byte[]> splitToMimeTypeAndContent(String base64) {
        String[] splittedData = base64.split(",");
        if (splittedData.length < 2) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Incorrect format of base64 string");
            }
            return null;
        }
        String mimeType = splittedData[0].startsWith("data:") ? splittedData[0].substring(5) : splittedData[0];
        int cutIndex = mimeType.lastIndexOf(59);
        if (cutIndex > -1) {
            mimeType = mimeType.substring(0, cutIndex);
        }
        try {
            return MultiTuple.from((Object)mimeType, (Object)Base64.decodeBase64((String)splittedData[splittedData.length - 1]));
        }
        catch (IllegalArgumentException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can not decode base64 to blob", (Throwable)ex);
            }
            return null;
        }
    }
}

