/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.charisma.event.EventMarker;
import jetbrains.charisma.persistent.UserActionJob;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobHandler;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IRightCombinator;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.backports.LinkedList;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.youtrack.api.application.RuleEngine;
import jetbrains.youtrack.core.persistent.IssueImpl;
import org.jetbrains.annotations.NotNull;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

public class UserActionJobContainer {
    private final Object synchObject = new Object();
    private final Map<Object, Map<String, UserActionJob>> jobs = new ConcurrentHashMap<Object, Map<String, UserActionJob>>();
    private final Map<String, UserActionJob> globalJobs = new ConcurrentHashMap<String, UserActionJob>();
    private final Map<Object, Map<String, UserActionJob>> dependency = new ConcurrentHashMap<Object, Map<String, UserActionJob>>();
    private final EntityReleaseHandlersContainer entityReleaseHandlersContainer = new EntityReleaseHandlersContainer();
    private String currentJobName = null;
    private final JobProcessor jobProcessor;

    public UserActionJobContainer(JobProcessor jobProcessor) {
        this.jobProcessor = jobProcessor;
    }

    public void addOrReplaceTransactionSafeSilentTransactionalJobOnBehalfOf(final @NotNull Entity user, final Runnable nonTransactionalAction, final String actionName, final Entity ... param) {
        final BeanContainer beanContainer = WebLocalScope.getContainer();
        ((PersistentEntityStore)ServiceLocator.getBean((String)"persistentEntityStore")).getEnvironment().executeTransactionSafeTask(new Runnable(){

            @Override
            public void run() {
                BeanContainer oldContainer = WebLocalScope.getContainerDontCreate();
                try {
                    WebLocalScope.setLocalBeanContainer((BeanContainer)beanContainer);
                    UserActionJobContainer.this.getOrCreateSilentTransactionalJobOnBehalfOf(user, nonTransactionalAction, actionName, param);
                }
                finally {
                    if (oldContainer != null) {
                        WebLocalScope.setLocalBeanContainer((BeanContainer)oldContainer);
                    } else {
                        WebLocalScope.removeLocalBeanContainer();
                    }
                }
            }
        });
    }

    public UserActionJob getOrCreateSilentTransactionalJobOnBehalfOf(final @NotNull Entity owner, final Runnable nonTransactionalAction, String actionName, Entity ... param) {
        return this.getOrCreateUserActionJob(new UserActionJob(new Runnable(){

            @Override
            public void run() {
                try {
                    ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).addIgnoreThread();
                    ((EventMarker)ServiceLocator.getBean((String)"systemApplyEventMarker")).add();
                    IssueImpl.setUpdateEnabled((boolean)false);
                    IssueImpl.setDuplicatesProcessingEnabled((boolean)false);
                    try {
                        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setTemporaryServerPrincipal((Object)owner);
                        _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                            public void invoke() {
                                nonTransactionalAction.run();
                            }
                        });
                    }
                    finally {
                        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetTemporaryServerPrincipal();
                    }
                }
                finally {
                    IssueImpl.setDuplicatesProcessingEnabled((boolean)true);
                    IssueImpl.setUpdateEnabled((boolean)true);
                    ((EventMarker)ServiceLocator.getBean((String)"systemApplyEventMarker")).remove();
                    ((RuleEngine)ServiceLocator.getBean((String)"ruleEngine")).removeIgnoreThread();
                }
            }
        }, actionName), actionName, param);
    }

    public UserActionJob getOrCreateJob(Runnable action, String actionName, Entity ... param) {
        return this.getOrCreateUserActionJob(new UserActionJob(action, actionName), actionName, param);
    }

    public UserActionJob getOrCreateJobWithDelay(Runnable action, String actionName, long delay, Entity ... param) {
        return this.getOrCreateUserActionJobWithDelay(new UserActionJob(action, actionName), actionName, delay, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserActionJob getOrCreateUserActionJob(UserActionJob actionJob, String actionName, Entity ... param) {
        Object object = this.synchObject;
        synchronized (object) {
            UserActionJob result = this.retrieveUserActionJob(actionJob, actionName, param);
            this.jobProcessor.queue((Job)result);
            return result;
        }
    }

    public boolean isFinished() {
        return this.jobProcessor.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserActionJob getOrCreateUserActionJobWithDelay(UserActionJob actionJob, String actionName, long delay, Entity ... param) {
        Object object = this.synchObject;
        synchronized (object) {
            UserActionJob result = this.retrieveUserActionJob(actionJob, actionName, param);
            this.jobProcessor.queueIn((Job)result, delay);
            return result;
        }
    }

    private UserActionJob retrieveUserActionJob(UserActionJob actionJob, final String actionName, Entity ... param) {
        ConcurrentHashMap<String, UserActionJob> jobMap;
        Iterable<Object> ids;
        final String id = this.getIdSuffix(param);
        Iterable<Object> iterable = ids = id == null || id.length() == 0 ? null : this.getIdSuffixes(param);
        if (param.length == 0) {
            jobMap = this.globalJobs;
        } else {
            jobMap = (ConcurrentHashMap<String, UserActionJob>)MapSequence.fromMap(this.jobs).get((Object)id);
            if (jobMap == null) {
                jobMap = new ConcurrentHashMap<String, UserActionJob>();
                MapSequence.fromMap(this.jobs).put((Object)id, jobMap);
            }
        }
        UserActionJob result = jobMap.get(actionName);
        if (result != null) {
            return result;
        }
        actionJob.setId(actionName + id);
        result = actionJob;
        jobMap.put(actionName, result);
        this.registerDependency(ids, actionName, result);
        result.registerJobFinishedHandler(new JobHandler(){

            public void handle(Job p0) {
                UserActionJobContainer.this.currentJobName = null;
                UserActionJobContainer.this.removeJob(id == null || id.length() == 0 ? null : id, ids, actionName);
            }
        });
        result.registerJobStartingHandler(new JobHandler(){

            public void handle(Job p0) {
                UserActionJobContainer.this.currentJobName = actionName;
            }
        });
        return result;
    }

    public boolean hasNotFinishedJobForParams(Entity ... params) {
        return this.getNotFinishedJobForParams(params) != null;
    }

    public UserActionJob getNotFinishedJobForParams(Entity ... params) {
        String idSuffix;
        Map<String, UserActionJob> foundJobs;
        if (params.length >= 0 && (foundJobs = this.jobs.get(idSuffix = this.getIdSuffix(params))) != null) {
            for (UserActionJob job : CollectionSequence.fromCollection(foundJobs.values())) {
                if (job.getState() == UserActionJob.State.FINISHED) continue;
                return job;
            }
        }
        return null;
    }

    public boolean hasNotFinishedJobForEntity(Entity param) {
        String idSuffix;
        Map<String, UserActionJob> dependentJobs;
        if (param != null && (dependentJobs = this.dependency.get(idSuffix = this.getIdSuffix(param))) != null) {
            for (UserActionJob job : CollectionSequence.fromCollection(dependentJobs.values())) {
                if (job.getState() == UserActionJob.State.FINISHED) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, UserActionJob> getJobsForParams(Entity ... params) {
        if (params.length == 0) {
            return this.globalJobs;
        }
        Map<String, UserActionJob> foundJobs = this.jobs.get(this.getIdSuffix(params));
        if (foundJobs == null) {
            return Collections.emptyMap();
        }
        return foundJobs;
    }

    private String getIdSuffix(Entity ... param) {
        return ((StringBuilder)Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])param)).foldRight((Object)new StringBuilder(), (_FunctionTypes._return_P2_E0)new IRightCombinator<Entity, StringBuilder>(){

            public StringBuilder combine(Entity it, StringBuilder s) {
                return s.append('-').append(EntityOperations.equals((Entity)it, null) ? "" : it.toIdString());
            }
        })).toString();
    }

    private Iterable<Object> getIdSuffixes(Entity ... param) {
        IListSequence ids = ListSequence.fromList(new ArrayList());
        for (Entity p : param) {
            if (p == null) continue;
            ListSequence.fromList((List)ids).addElement((Object)("-" + p.toIdString()));
        }
        return ids;
    }

    private void registerDependency(Iterable<Object> ids, String actionName, UserActionJob job) {
        for (Object id : Sequence.fromIterable(ids)) {
            ConcurrentHashMap dependentJobs = (ConcurrentHashMap)MapSequence.fromMap(this.dependency).get(id);
            if (dependentJobs == null) {
                dependentJobs = new ConcurrentHashMap();
                MapSequence.fromMap(this.dependency).put(id, dependentJobs);
            }
            MapSequence.fromMap((Map)dependentJobs).put((Object)actionName, (Object)job);
        }
    }

    private void unregisterDependency(Iterable<Object> ids, String actionName) {
        if (ids == null) {
            return;
        }
        for (Object id : Sequence.fromIterable(ids)) {
            Map dependentJobs = (Map)MapSequence.fromMap(this.dependency).get(id);
            MapSequence.fromMap((Map)dependentJobs).removeKey((Object)actionName);
            if (!MapSequence.fromMap((Map)dependentJobs).isEmpty()) continue;
            this.entityReleaseHandlersContainer.notifyReleaseHandlers(id);
            this.dependency.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJob(Object id, Iterable<Object> ids, String actionName) {
        Object object = this.synchObject;
        synchronized (object) {
            if (id == null) {
                this.globalJobs.remove(actionName);
            } else {
                Map<String, UserActionJob> jobMap = this.jobs.get(id);
                jobMap.remove(actionName);
                if (jobMap.isEmpty()) {
                    this.jobs.remove(id);
                }
                this.unregisterDependency(ids, actionName);
            }
        }
    }

    public String getCurrentJobName() {
        return this.currentJobName;
    }

    public boolean hasJobs() {
        for (Map map : CollectionSequence.fromCollection(this.jobs.values())) {
            if (map.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalJobs() {
        return !this.globalJobs.isEmpty();
    }

    public boolean hasGlobalJob(String jobName) {
        return this.globalJobs.containsKey(jobName);
    }

    public void registerEntityReleaseHandler(Entity entity, Runnable handler) {
        this.entityReleaseHandlersContainer.registerEntityReleaseHandler(entity, handler);
    }

    public void unregisterEntityReleaseHandler(Runnable handler) {
        this.entityReleaseHandlersContainer.unregisterEntityReleaseHandler(handler);
    }

    public class EntityReleaseHandlersContainer {
        private final Map<Object, List<Runnable>> releaseHandlers = MapSequence.fromMap(new HashMap());
        private final Map<Runnable, String> handlerIds = MapSequence.fromMap(new HashMap());

        public synchronized void registerEntityReleaseHandler(Entity entity, Runnable handler) {
            String id = UserActionJobContainer.this.getIdSuffix(new Entity[]{entity});
            MapSequence.fromMap(this.handlerIds).put((Object)handler, (Object)id);
            List handlers = (List)MapSequence.fromMap(this.releaseHandlers).get((Object)id);
            if (handlers == null) {
                handlers = ListSequence.fromList((List)new LinkedList());
                MapSequence.fromMap(this.releaseHandlers).put((Object)id, (Object)handlers);
            }
            ListSequence.fromList((List)handlers).addElement((Object)handler);
        }

        public synchronized void unregisterEntityReleaseHandler(Runnable handler) {
            String id = (String)MapSequence.fromMap(this.handlerIds).get((Object)handler);
            List handlers = (List)MapSequence.fromMap(this.releaseHandlers).get((Object)id);
            if (handlers != null) {
                ListSequence.fromList((List)handlers).removeElement((Object)handler);
            }
        }

        public synchronized void notifyReleaseHandlers(Object id) {
            List handlers = (List)MapSequence.fromMap(this.releaseHandlers).get(id);
            if (handlers != null) {
                for (Runnable handler : ListSequence.fromList((List)handlers)) {
                    handler.run();
                }
            }
        }
    }
}

