/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.UserImpl;
import org.jetbrains.annotations.Nullable;

public interface UserFilterService {
    public Iterable<Entity> search(String var1);

    public Iterable<Entity> search(String var1, @Nullable Iterable<Entity> var2);

    public Entity searchGreedyByLogin(String var1);

    public static enum RenderStyle {
        VISIBLE_NAME_LOGIN_EMAIL{

            @Override
            public String render(Entity user) {
                return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getVisibleNameWithLoginAndEmail(user);
            }
        }
        ,
        ME_VISIBLE_NAME_LOGIN{

            @Override
            public String render(Entity user) {
                return EntityOperations.equals((Entity)user, (Object)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()) ? this.me(user) : this.visibleNameWithLogin(user);
            }
        }
        ,
        ME_VISIBLE_NAME{

            @Override
            public String render(Entity user) {
                return EntityOperations.equals((Entity)user, (Object)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get()) ? this.me(user) : ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getVisibleName(user);
            }
        };


        public String render(Entity user) {
            return (String)PrimitiveAssociationSemantics.get((Entity)user, (String)"login", String.class, (Object)"<no user>");
        }

        public String me(Entity user) {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UserFilterService.me_{0}", new Object[]{((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getVisibleName(user)});
        }

        public String visibleNameWithLogin(Entity user) {
            return ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user, (String)"User")).getVisibleNameWithLogin(user);
        }
    }
}

