/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Locale;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.And;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.txn._Txn;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.application.ApplicationState;
import jetbrains.youtrack.api.application.ApplicationStateListener;
import jetbrains.youtrack.core.persistent.UserImpl;
import jetbrains.youtrack.core.security.DefaultPermissionScheme;
import jetbrains.youtrack.core.security.DefaultRole;
import jetbrains.youtrack.core.security.Security;

public class UserService
implements ApplicationStateListener {
    private static final String DEFAULT_ROOT_PASSWORD = "root";

    public void init() {
        final DefaultPermissionScheme dps = new DefaultPermissionScheme();
        Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])DefaultRole.values())).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<DefaultRole>(){

            public void visit(DefaultRole it) {
                dps.addPermissionGroup(it);
            }
        });
        Locale serverLocale = ((ApplicationMetaDataImpl)DnqUtils.getPersistentClassInstance((Entity)((Entity)ServiceLocator.getBean((String)"applicationMetaData")), (String)"ApplicationMetaData")).getLocaleData((Entity)ServiceLocator.getBean((String)"applicationMetaData"));
        dps.addUser("guest", "guest", ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale("youtrack.user.guest.name", serverLocale, new Object[0]), null, false);
        String rootLogin = ConfigurationParameter.getParameter("jetbrains.youtrack.root.login", DEFAULT_ROOT_PASSWORD);
        ((Security)ServiceLocator.getBean((String)"security")).initPermissionScheme(dps);
        ((Security)ServiceLocator.getBean((String)"security")).createRoot(rootLogin, DEFAULT_ROOT_PASSWORD, rootLogin);
    }

    public void restoreRoot(String password) {
        ((Security)ServiceLocator.getBean((String)"security")).restoreRoot(DEFAULT_ROOT_PASSWORD, password);
    }

    public Entity checkGuest() {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)"guest"))));
    }

    public Entity getGuest() {
        return ((Security)ServiceLocator.getBean((String)"security")).getGuest();
    }

    public boolean isGuest(Entity user) {
        return user != null && EntityOperations.equals((Entity)this.getGuest(), (Object)user);
    }

    public Entity getRoot() {
        return ((Security)ServiceLocator.getBean((String)"security")).getRoot();
    }

    public Entity loginUserUsingCookies(String login, String hashedPassword) {
        if (UserService.eq_rpaq79_a0a0g(login, "guest")) {
            return this.getGuest();
        }
        if (login == null || login.length() == 0 || hashedPassword == null || hashedPassword.length() == 0) {
            return null;
        }
        Entity u = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new And((NodeBase)new PropertyEqual("login", (Comparable)((Object)login)), (NodeBase)new PropertyEqual("password", (Comparable)((Object)hashedPassword)))));
        if (!EntityOperations.equals((Entity)u, null) && ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)u, (String)"User")).isBanned(u)) {
            return null;
        }
        return u;
    }

    public void changed(ApplicationState newState) {
        if (newState == ApplicationState.HUB_INTEGRATION_STARTED && Boolean.getBoolean("jetbrains.charisma.restoreRootPassword")) {
            _Txn.run((_FunctionTypes._void_P0_E0)new _FunctionTypes._void_P0_E0(){

                public void invoke() {
                    UserService.this.restoreRoot(UserService.DEFAULT_ROOT_PASSWORD);
                }
            });
        }
    }

    private static boolean eq_rpaq79_a0a0g(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

