/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.database.exceptions;

import java.util.Set;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.EntityFieldHandler;
import jetbrains.exodus.entitystore.EntityId;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/database/exceptions/OrphanChildException;", "Ljetbrains/exodus/database/exceptions/DataIntegrityViolationException;", "entity", "Ljetbrains/exodus/database/TransientEntity;", "parents", "", "", "(Ljetbrains/exodus/database/TransientEntity;Ljava/util/Set;)V", "entityFieldHandler", "Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "getEntityFieldHandler", "()Ljetbrains/exodus/database/exceptions/EntityFieldHandler;", "relatesTo", "", "fieldIdentity", "", "dnq-open-api"})
public class OrphanChildException
extends DataIntegrityViolationException {
    @NotNull
    private final EntityFieldHandler entityFieldHandler;
    private final Set<String> parents;

    @Override
    @NotNull
    public EntityFieldHandler getEntityFieldHandler() {
        return this.entityFieldHandler;
    }

    @Override
    public boolean relatesTo(@NotNull TransientEntity entity, @Nullable Object fieldIdentity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return super.relatesTo(entity, fieldIdentity) && CollectionsKt.contains((Iterable)this.parents, (Object)fieldIdentity);
    }

    public OrphanChildException(@NotNull TransientEntity entity, @NotNull Set<String> parents) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull(parents, (String)"parents");
        super("Entity [" + entity + "] has no parent, but should have.", null, entity, 2, null);
        this.parents = parents;
        EntityId entityId = entity.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"entity.id");
        this.entityFieldHandler = new EntityFieldHandler(entityId, (String)CollectionsKt.first((Iterable)this.parents));
    }
}

