/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.teamsys.dnq.database;

import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.ConstraintsUtil;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.TransientEntityUtilKt;
import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.NamedKLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0007J\u001e\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J#\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0014H\u0007J#\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0018\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u0019\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007J-\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0001\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/teamsys/dnq/database/EntityOperations;", "", "()V", "logger", "Lmu/KLogger;", "equals", "", "e1", "Ljetbrains/exodus/entitystore/Entity;", "e2", "getElement", "entities", "", "i", "", "hasChanges", "e", "Ljetbrains/exodus/database/TransientEntity;", "properties", "", "", "(Ljetbrains/exodus/database/TransientEntity;[Ljava/lang/String;)Z", "property", "hasChangesExcepting", "isNew", "isRemoved", "remove", "", "callDestructorPhase", "processed", "", "remove$dnq_transient_store", "dnq-transient-store"})
public final class EntityOperations {
    private static final KLogger logger;
    public static final EntityOperations INSTANCE;

    @JvmStatic
    public static final void remove(@Nullable Entity e) {
        EntityOperations.remove$dnq_transient_store(e, true, (Set)new HashSet());
        EntityOperations.remove$dnq_transient_store(e, false, (Set)new HashSet());
    }

    @JvmStatic
    public static final void remove$dnq_transient_store(@Nullable Entity e, boolean callDestructorPhase, @NotNull Set<Entity> processed) {
        EntityMetaData entityMetaData;
        Intrinsics.checkParameterIsNotNull(processed, (String)"processed");
        if (e == null || ((TransientEntity)e).isRemoved()) {
            return;
        }
        TransientEntity txnEntity = TransientEntityUtilKt.reattachTransient$default(e, null, 1, null);
        if (processed.contains(txnEntity)) {
            return;
        }
        TransientEntityStore store = txnEntity.getStore();
        ModelMetaData modelMetaData = store.getModelMetaData();
        if (modelMetaData != null && (entityMetaData = modelMetaData.getEntityMetaData(txnEntity.getType())) != null) {
            if (callDestructorPhase) {
                BasePersistentClassImpl basePersistentClassImpl = TransientEntityUtilKt.getPersistentClassInstance(txnEntity);
                if (basePersistentClassImpl != null) {
                    basePersistentClassImpl.destructor((Entity)txnEntity);
                }
            }
            processed.add((Entity)txnEntity);
            TransientStoreSession storeSession = TransientEntityUtilKt.getThreadSessionOrThrow(store);
            ConstraintsUtil.processOnDeleteConstraints(storeSession, txnEntity, entityMetaData, modelMetaData, callDestructorPhase, processed);
        }
        if (!callDestructorPhase && !txnEntity.isRemoved()) {
            txnEntity.delete();
        }
    }

    @JvmStatic
    public static final boolean isRemoved(@Nullable Entity e) {
        return e == null ? true : TransientStoreUtil.isRemoved(e);
    }

    @JvmStatic
    public static final boolean isNew(@Nullable Entity e) {
        Entity entity = e;
        return entity != null && (entity = TransientEntityUtilKt.reattachTransient$default(entity, null, 1, null)) != null ? entity.isNew() : false;
    }

    @JvmStatic
    public static final boolean equals(@Nullable Entity e1, @Nullable Object e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null) {
            return false;
        }
        if (!(e1 instanceof TransientEntity)) {
            return false;
        }
        return Intrinsics.areEqual((Object)e1, (Object)e2);
    }

    @JvmStatic
    @Deprecated(message="Slow method. For TestCases only")
    @NotNull
    public static final Entity getElement(@NotNull Iterable<? extends Entity> entities, int i) {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        logger.warn((Function0)getElement.1.INSTANCE);
        return (Entity)CollectionsKt.elementAt(entities, (int)i);
    }

    @JvmStatic
    public static final boolean hasChanges(@NotNull TransientEntity e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return TransientEntityUtilKt.reattach$default(e, null, 1, null).hasChanges();
    }

    @JvmStatic
    public static final boolean hasChanges(@NotNull TransientEntity e, @NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        return TransientEntityUtilKt.reattach$default(e, null, 1, null).hasChanges(property);
    }

    @JvmStatic
    public static final boolean hasChanges(@NotNull TransientEntity e, @NotNull String[] properties) {
        boolean bl;
        block1: {
            String[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
            TransientEntity entity = TransientEntityUtilKt.reattach$default(e, null, 1, null);
            for (String element$iv : $receiver$iv = properties) {
                String it = element$iv;
                if (!entity.hasChanges(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean hasChangesExcepting(@NotNull TransientEntity e, @NotNull String[] properties) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        TransientEntity entity = TransientEntityUtilKt.reattach$default(e, null, 1, null);
        return entity.hasChangesExcepting(properties);
    }

    private EntityOperations() {
    }

    static {
        EntityOperations entityOperations;
        INSTANCE = entityOperations = new EntityOperations();
        String string = EntityOperations.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EntityOperations::class.java.name");
        logger = new NamedKLogging(string).getLogger();
    }
}

