/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.xodus.browser.web;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.xodus.browser.web.DBSummary;
import jetbrains.xodus.browser.web.DatabaseException;
import jetbrains.xodus.browser.web.Services;
import jetbrains.xodus.browser.web.WebApplication;
import jetbrains.xodus.browser.web.db.DatabaseService;
import jetbrains.xodus.browser.web.db.StoreService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ljetbrains/xodus/browser/web/PersistentWebApplication;", "Ljetbrains/xodus/browser/web/WebApplication;", "databaseService", "Ljetbrains/xodus/browser/web/db/DatabaseService;", "(Ljetbrains/xodus/browser/web/db/DatabaseService;)V", "allServices", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljetbrains/xodus/browser/web/Services;", "getAllServices", "()Ljava/util/concurrent/ConcurrentHashMap;", "getDatabaseService", "()Ljetbrains/xodus/browser/web/db/DatabaseService;", "start", "", "stop", "db", "Ljetbrains/xodus/browser/web/DBSummary;", "tryStartServices", "", "silent", "entity-browser-app"})
public class PersistentWebApplication
implements WebApplication {
    @NotNull
    private final ConcurrentHashMap<String, Services> allServices;
    @NotNull
    private final DatabaseService databaseService;

    @NotNull
    public ConcurrentHashMap<String, Services> getAllServices() {
        return this.allServices;
    }

    @Override
    public void start() {
        this.getDatabaseService().start();
        Iterable $this$forEach$iv = this.getDatabaseService().all();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DBSummary it = (DBSummary)element$iv;
            boolean bl = false;
            boolean started = this.tryStartServices(it, true);
            this.getDatabaseService().markStarted(it.getUuid(), started);
        }
    }

    @Override
    public boolean tryStartServices(@NotNull DBSummary db, boolean silent) {
        StoreService service;
        block5: {
            StoreService storeService;
            Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
            if (((ConcurrentHashMap)this.getAllServices()).containsKey(db.getUuid())) {
                return true;
            }
            try {
                storeService = new StoreService(db);
            }
            catch (DatabaseException e) {
                if (!silent) {
                    throw (Throwable)e;
                }
                storeService = null;
            }
            catch (Exception e) {
                storeService = null;
            }
            StoreService storeService2 = service = storeService;
            if (storeService2 == null) break block5;
            storeService = storeService2;
            boolean bl = false;
            boolean bl2 = false;
            StoreService it = storeService;
            boolean bl3 = false;
            Map map = this.getAllServices();
            String string2 = db.getUuid();
            Services services = new Services(it, null, 2, null);
            boolean bl4 = false;
            map.put(string2, services);
            this.getDatabaseService().markStarted(db.getUuid(), true);
        }
        return service != null;
    }

    @Override
    public void stop(@NotNull DBSummary db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Services services = (Services)((ConcurrentHashMap)this.getAllServices()).get(db.getUuid());
        if (services != null) {
            Services services2 = services;
            boolean bl = false;
            boolean bl2 = false;
            Services it = services2;
            boolean bl3 = false;
            it.stop();
            this.getDatabaseService().markStarted(db.getUuid(), false);
        }
        ((ConcurrentHashMap)this.getAllServices()).remove(db.getUuid());
    }

    @Override
    public void stop() {
        this.getDatabaseService().stop();
    }

    @Override
    @NotNull
    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    public PersistentWebApplication(@NotNull DatabaseService databaseService2) {
        Intrinsics.checkParameterIsNotNull((Object)databaseService2, (String)"databaseService");
        this.databaseService = databaseService2;
        this.allServices = new ConcurrentHashMap();
    }

    @Override
    public boolean isReadonly() {
        return WebApplication.DefaultImpls.isReadonly(this);
    }
}

