/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.xodus.browser.web.db;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.crypto.InvalidCipherParametersException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.io.WatchingFileDataReaderWriterProvider;
import jetbrains.xodus.browser.web.ChangeSummary;
import jetbrains.xodus.browser.web.ChangeSummaryAction;
import jetbrains.xodus.browser.web.DBSummary;
import jetbrains.xodus.browser.web.DatabaseException;
import jetbrains.xodus.browser.web.EntityLink;
import jetbrains.xodus.browser.web.EntityNotFoundException;
import jetbrains.xodus.browser.web.EntityProperty;
import jetbrains.xodus.browser.web.EntityType;
import jetbrains.xodus.browser.web.EntityView;
import jetbrains.xodus.browser.web.LinkChangeSummaryAction;
import jetbrains.xodus.browser.web.LinkPager;
import jetbrains.xodus.browser.web.Named;
import jetbrains.xodus.browser.web.NotFoundException;
import jetbrains.xodus.browser.web.PropertiesChangeSummaryAction;
import jetbrains.xodus.browser.web.SearchPager;
import jetbrains.xodus.browser.web.TransformationsKt;
import jetbrains.xodus.browser.web.db.EntityBulkJob;
import jetbrains.xodus.browser.web.db.Job;
import jetbrains.xodus.browser.web.db.StoreService;
import jetbrains.xodus.browser.web.db.StoreServiceKt;
import jetbrains.xodus.browser.web.search.SmartSearchKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\u00020\u0001:\u0001<B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0011\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eJ\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u000eJ\u0018\u0010\u001e\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010$\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J'\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H(0*H\u0002\u00a2\u0006\u0002\u0010+J\u0014\u0010,\u001a\u0004\u0018\u00010\u000e2\b\u0010-\u001a\u0004\u0018\u00010\u000eH\u0002J&\u0010.\u001a\u00020/2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\fJ(\u00103\u001a\u0002042\u0006\u0010\u0015\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u00010\u000e2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\fJ\u0006\u00106\u001a\u00020\u0018J'\u00107\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H(0*H\u0002\u00a2\u0006\u0002\u0010+J\u0016\u00108\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&J\u0014\u00109\u001a\u00020\u0018*\u00020 2\u0006\u0010:\u001a\u00020;H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ljetbrains/xodus/browser/web/db/StoreService;", "", "store", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "isReadonly", "", "(Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;Z)V", "dbSummary", "Ljetbrains/xodus/browser/web/DBSummary;", "(Ljetbrains/xodus/browser/web/DBSummary;)V", "()Z", "addType", "", "type", "", "allTypes", "", "Ljetbrains/xodus/browser/web/EntityType;", "()[Ljetbrains/xodus/browser/web/EntityType;", "deleteEntitiesJob", "Ljetbrains/xodus/browser/web/db/Job;", "typeId", "term", "deleteEntity", "", "id", "getBlob", "Ljava/io/InputStream;", "blobName", "getBlobString", "getEntity", "Ljetbrains/xodus/browser/web/EntityView;", "Ljetbrains/exodus/entitystore/Entity;", "t", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "getEntityOrStub", "newEntity", "vo", "Ljetbrains/xodus/browser/web/ChangeSummary;", "readonly", "T", "call", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "safeTrim", "value", "searchEntity", "Ljetbrains/xodus/browser/web/LinkPager;", "linkName", "offset", "pageSize", "searchType", "Ljetbrains/xodus/browser/web/SearchPager;", "q", "stop", "transactional", "updateEntity", "applyValues", "property", "Ljetbrains/xodus/browser/web/EntityProperty;", "Companion", "entity-browser-app"})
public final class StoreService {
    private final PersistentEntityStoreImpl store;
    private final boolean isReadonly;
    public static final Companion Companion = new Companion(null);

    public final boolean isReadonly() {
        return this.isReadonly;
    }

    /*
     * WARNING - void declaration
     */
    public final void stop() {
        void count;
        boolean proceed = true;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 1;
        while (proceed && count.element <= 10) {
            try {
                Companion.getLogger().info((Function0)new Function0<String>((Ref.IntRef)count){
                    final /* synthetic */ Ref.IntRef $count;

                    @NotNull
                    public final String invoke() {
                        return "trying to close persistent store. attempt " + this.$count.element;
                    }
                    {
                        this.$count = intRef;
                        super(0);
                    }
                });
                this.store.close();
                proceed = false;
                Companion.getLogger().info("persistent store closed");
            }
            catch (RuntimeException e) {
                Companion.getLogger().error((Throwable)e, (Function0)stop.2.INSTANCE);
                int n = count.element;
                count.element = n + 1;
            }
        }
    }

    public final int addType(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return ((Number)this.transactional((Function1)new Function1<PersistentStoreTransaction, Integer>(this, type){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ String $type;

            public final int invoke(@NotNull PersistentStoreTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StoreService.access$getStore$p(this.this$0).getEntityTypeId(it, this.$type, true);
            }
            {
                this.this$0 = storeService;
                this.$type = string2;
                super(1);
            }
        })).intValue();
    }

    @NotNull
    public final EntityType[] allTypes() {
        return (EntityType[])this.readonly(allTypes.1.INSTANCE);
    }

    @NotNull
    public final SearchPager searchType(int typeId, @Nullable String q, int offset, int pageSize) {
        return (SearchPager)this.readonly((Function1)new Function1<PersistentStoreTransaction, SearchPager>(this, typeId, q, offset, pageSize){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ int $typeId;
            final /* synthetic */ String $q;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $pageSize;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SearchPager invoke(@NotNull PersistentStoreTransaction t) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                String string2 = StoreService.access$getStore$p(this.this$0).getEntityType(t, this.$typeId);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"store.getEntityType(t, typeId)");
                String type = string2;
                EntityIterable result = SmartSearchKt.smartSearch(this.$q, type, this.$typeId, (StoreTransaction)t);
                long totalCount = result.size();
                EntityIterable entityIterable = result.skip(this.$offset).take(this.$pageSize);
                Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable, (String)"result.skip(offset).take(pageSize)");
                Iterable $this$map$iv = (Iterable)entityIterable;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Entity entity = (Entity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    EntityView entityView = TransformationsKt.asView((Entity)v2);
                    collection.add(entityView);
                }
                List items = (List)destination$iv$iv;
                return new SearchPager(CollectionsKt.toList((Iterable)items), totalCount);
            }
            {
                this.this$0 = storeService;
                this.$typeId = n;
                this.$q = string2;
                this.$offset = n2;
                this.$pageSize = n3;
                super(1);
            }
        });
    }

    @NotNull
    public final LinkPager searchEntity(@NotNull String id2, @NotNull String linkName, int offset, int pageSize) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        return (LinkPager)this.readonly((Function1)new Function1<PersistentStoreTransaction, LinkPager>(this, id2, linkName, offset, pageSize){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ String $linkName;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $pageSize;

            @NotNull
            public final LinkPager invoke(@NotNull PersistentStoreTransaction t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                return TransformationsKt.linkView(StoreService.access$getEntity(this.this$0, this.$id, t), this.$linkName, this.$offset, this.$pageSize);
            }
            {
                this.this$0 = storeService;
                this.$id = string2;
                this.$linkName = string3;
                this.$offset = n;
                this.$pageSize = n2;
                super(1);
            }
        });
    }

    @NotNull
    public final EntityView newEntity(int typeId, @NotNull ChangeSummary vo) {
        Intrinsics.checkParameterIsNotNull((Object)vo, (String)"vo");
        Object t = this.transactional((Function1)new Function1<PersistentStoreTransaction, String>(this, typeId, vo){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ int $typeId;
            final /* synthetic */ ChangeSummary $vo;

            @NotNull
            public final String invoke(@NotNull PersistentStoreTransaction t) {
                EntityProperty it;
                Named named;
                boolean bl;
                boolean bl2;
                ChangeSummaryAction it2;
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                String string2 = StoreService.access$getStore$p(this.this$0).getEntityType(t, this.$typeId);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"store.getEntityType(t, typeId)");
                String type = string2;
                PersistentEntity persistentEntity = t.newEntity(type);
                Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntity, (String)"t.newEntity(type)");
                PersistentEntity entity = persistentEntity;
                Iterable $this$forEach$iv = this.$vo.getProperties();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it2 = (PropertiesChangeSummaryAction)element$iv;
                    boolean bl3 = false;
                    if ((EntityProperty)it2.getNewValue() == null) continue;
                    bl2 = false;
                    bl = false;
                    it = named;
                    boolean bl4 = false;
                    StoreService.access$applyValues(this.this$0, (Entity)entity, it);
                }
                $this$forEach$iv = this.$vo.getLinks();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it2 = (LinkChangeSummaryAction)element$iv;
                    boolean bl5 = false;
                    if ((EntityLink)it2.getNewValue() == null) continue;
                    bl2 = false;
                    bl = false;
                    it = named;
                    boolean bl6 = false;
                    Entity link = StoreService.access$getEntity(this.this$0, ((EntityLink)((Object)it)).getId(), t);
                    entity.addLink(((EntityLink)((Object)it)).getName(), link);
                }
                return entity.getId().toString();
            }
            {
                this.this$0 = storeService;
                this.$typeId = n;
                this.$vo = changeSummary;
                super(1);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"transactional { t ->\n   \u2026y.id.toString()\n        }");
        String entityId2 = (String)t;
        return this.getEntity(entityId2);
    }

    @NotNull
    public final InputStream getBlob(@NotNull String id2, @NotNull String blobName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)blobName, (String)"blobName");
        return (InputStream)this.readonly((Function1)new Function1<PersistentStoreTransaction, InputStream>(this, id2, blobName){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ String $blobName;

            @NotNull
            public final InputStream invoke(@NotNull PersistentStoreTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Entity entity = StoreService.access$getEntity(this.this$0, this.$id, it);
                InputStream inputStream = entity.getBlob(this.$blobName);
                if (inputStream == null) {
                    throw (Throwable)new NotFoundException("there is no blob " + this.$blobName);
                }
                return inputStream;
            }
            {
                this.this$0 = storeService;
                this.$id = string2;
                this.$blobName = string3;
                super(1);
            }
        });
    }

    @NotNull
    public final String getBlobString(@NotNull String id2, @NotNull String blobName) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)blobName, (String)"blobName");
        return (String)this.readonly((Function1)new Function1<PersistentStoreTransaction, String>(this, id2, blobName){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ String $blobName;

            @NotNull
            public final String invoke(@NotNull PersistentStoreTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Entity entity = StoreService.access$getEntity(this.this$0, this.$id, it);
                String string2 = entity.getBlobString(this.$blobName);
                if (string2 == null) {
                    throw (Throwable)new NotFoundException("there is no blob " + this.$blobName);
                }
                return string2;
            }
            {
                this.this$0 = storeService;
                this.$id = string2;
                this.$blobName = string3;
                super(1);
            }
        });
    }

    private final void applyValues(@NotNull Entity $receiver, EntityProperty property) {
        property.setValue(this.safeTrim(property.getValue()));
        Comparable<?> value = TransformationsKt.string2value(property);
        if (value != null) {
            $receiver.setProperty(property.getName(), value);
        }
    }

    @NotNull
    public final EntityView updateEntity(@NotNull String id2, @NotNull ChangeSummary vo) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)vo, (String)"vo");
        this.transactional((Function1)new Function1<PersistentStoreTransaction, String>(this, id2, vo){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ ChangeSummary $vo;

            @NotNull
            public final String invoke(@NotNull PersistentStoreTransaction t) {
                Named newValue;
                ChangeSummaryAction it;
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                Entity entity = StoreService.access$getEntity(this.this$0, this.$id, t);
                Iterable $this$forEach$iv = this.$vo.getProperties();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (PropertiesChangeSummaryAction)element$iv;
                    boolean bl = false;
                    newValue = (EntityProperty)it.getNewValue();
                    if (newValue == null) {
                        entity.deleteProperty(it.getName());
                        continue;
                    }
                    StoreService.access$applyValues(this.this$0, entity, (EntityProperty)newValue);
                }
                $this$forEach$iv = this.$vo.getLinks();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Entity linked;
                    it = (LinkChangeSummaryAction)element$iv;
                    boolean bl = false;
                    newValue = (EntityLink)it.getNewValue();
                    EntityLink oldValue = ((LinkChangeSummaryAction)it).getOldValue();
                    if (((LinkChangeSummaryAction)it).getTotallyRemoved()) {
                        entity.deleteLinks(it.getName());
                        continue;
                    }
                    if (newValue == null) {
                        if (oldValue == null) continue;
                        linked = StoreService.access$getEntityOrStub(this.this$0, oldValue.getId(), t);
                        entity.deleteLink(it.getName(), linked);
                        continue;
                    }
                    linked = StoreService.access$getEntity(this.this$0, ((EntityLink)newValue).getId(), t);
                    entity.addLink(it.getName(), linked);
                }
                return this.$id;
            }
            {
                this.this$0 = storeService;
                this.$id = string2;
                this.$vo = changeSummary;
                super(1);
            }
        });
        return this.getEntity(id2);
    }

    @NotNull
    public final EntityView getEntity(@NotNull String id2) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        return (EntityView)this.transactional((Function1)new Function1<PersistentStoreTransaction, EntityView>(this, id2){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ String $id;

            @NotNull
            public final EntityView invoke(@NotNull PersistentStoreTransaction t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                Entity entity = StoreService.access$getEntity(this.this$0, this.$id, t);
                return TransformationsKt.asView(entity);
            }
            {
                this.this$0 = storeService;
                this.$id = string2;
                super(1);
            }
        });
    }

    public final void deleteEntity(@NotNull String id2) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        this.transactional((Function1)new Function1<PersistentStoreTransaction, Boolean>(this, id2){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ String $id;

            public final boolean invoke(@NotNull PersistentStoreTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Entity entity = StoreService.access$getEntity(this.this$0, this.$id, it);
                return entity.delete();
            }
            {
                this.this$0 = storeService;
                this.$id = string2;
                super(1);
            }
        });
    }

    @NotNull
    public final Job deleteEntitiesJob(int typeId, @Nullable String term) {
        return new EntityBulkJob(this, typeId, term, (PersistentEntityStore)this.store){
            final /* synthetic */ StoreService this$0;
            final /* synthetic */ int $typeId;
            final /* synthetic */ String $term;

            public void doAction(@NotNull Entity $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.delete();
            }

            @NotNull
            public EntityIterable getAffectedEntities() {
                return (EntityIterable)StoreServiceKt.transactional((PersistentEntityStore)StoreService.access$getStore$p(this.this$0), (Function1)new Function1<PersistentStoreTransaction, EntityIterable>(this){
                    final /* synthetic */ deleteEntitiesJob.1 this$0;

                    @NotNull
                    public final EntityIterable invoke(@NotNull PersistentStoreTransaction it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String string2 = StoreService.access$getStore$p(this.this$0.this$0).getEntityType(this.this$0.$typeId);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"store.getEntityType(typeId)");
                        String type = string2;
                        return SmartSearchKt.smartSearch(this.this$0.$term, type, this.this$0.$typeId, (StoreTransaction)it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }

            @NotNull
            public String toString() {
                return "Bulk delete entities job for type " + this.$typeId + " and query '" + this.$term + '\'';
            }
            {
                this.this$0 = $outer;
                this.$typeId = $captured_local_variable$1;
                this.$term = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
    }

    private final Entity getEntity(String id2, PersistentStoreTransaction t) {
        try {
            PersistentEntity persistentEntity = t.getEntity(PersistentEntityId.toEntityId((CharSequence)id2));
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntity, (String)"t.getEntity(PersistentEntityId.toEntityId(id))");
            return (Entity)persistentEntity;
        }
        catch (RuntimeException e) {
            Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(id2){
                final /* synthetic */ String $id;

                @NotNull
                public final String invoke() {
                    return "entity not found by '" + this.$id + '\'';
                }
                {
                    this.$id = string2;
                    super(0);
                }
            });
            throw (Throwable)new EntityNotFoundException(e, id2);
        }
    }

    private final Entity getEntityOrStub(String id2, PersistentStoreTransaction t) {
        PersistentEntity persistentEntity;
        EntityId entityId2 = PersistentEntityId.toEntityId((CharSequence)id2);
        try {
            PersistentEntity persistentEntity2 = t.getEntity(entityId2);
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntity2, (String)"t.getEntity(entityId)");
            persistentEntity = persistentEntity2;
        }
        catch (EntityRemovedInDatabaseException e) {
            Companion.getLogger().info((Function0)new Function0<String>(id2){
                final /* synthetic */ String $id;

                @NotNull
                public final String invoke() {
                    return "entity not found by '" + this.$id + "'. using stub";
                }
                {
                    this.$id = string2;
                    super(0);
                }
            });
            EntityId entityId3 = entityId2;
            if (entityId3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.PersistentEntityId");
            }
            persistentEntity = new PersistentEntity(this.store, (PersistentEntityId)entityId3);
        }
        return (Entity)persistentEntity;
    }

    private final String safeTrim(String value) {
        if (value == null) {
            return null;
        }
        String $this$trim$iv = value;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        CharSequence charSequence = trimmed;
        boolean bl = false;
        return charSequence.length() == 0 ? null : trimmed;
    }

    private final <T> T transactional(Function1<? super PersistentStoreTransaction, ? extends T> call) {
        return StoreServiceKt.transactional((PersistentEntityStore)this.store, call);
    }

    private final <T> T readonly(Function1<? super PersistentStoreTransaction, ? extends T> call) {
        return StoreServiceKt.readonly((PersistentEntityStore)this.store, call);
    }

    public StoreService(@NotNull PersistentEntityStoreImpl store, boolean isReadonly) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        this.store = store;
        this.isReadonly = isReadonly;
    }

    public StoreService(@NotNull DBSummary dbSummary) {
        Intrinsics.checkParameterIsNotNull((Object)dbSummary, (String)"dbSummary");
        try {
            PersistentEntityStoreImpl persistentEntityStoreImpl;
            PersistentEntityStoreImpl persistentEntityStoreImpl2;
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            boolean bl = false;
            boolean bl2 = false;
            EnvironmentConfig it = environmentConfig;
            boolean bl3 = false;
            it.setEnvIsReadonly(dbSummary.isReadonly());
            if (dbSummary.isWatchReadonly() && dbSummary.isReadonly()) {
                it.setLogDataReaderWriterProvider(WatchingFileDataReaderWriterProvider.class.getName());
            }
            if (dbSummary.isEncrypted()) {
                String initialization;
                String string2;
                try {
                    Long l;
                    String string3 = dbSummary.getEncryptionIV();
                    if (string3 != null) {
                        string2 = string3;
                        boolean bl4 = false;
                        l = Long.parseLong(string2);
                    } else {
                        l = null;
                    }
                    string2 = l;
                }
                catch (Exception e) {
                    throw (Throwable)new InvalidCipherParametersException();
                }
                String string4 = initialization = string2;
                if (string4 == null) {
                    throw (Throwable)new InvalidCipherParametersException();
                }
                it.setCipherBasicIV(((Long)((Object)string4)).longValue());
                it.setCipherKey(dbSummary.getEncryptionKey());
                Object object = dbSummary.getEncryptionProvider();
                if (object == null || (object = object.getCipherIds()) == null || (object = (String)CollectionsKt.first((List)object)) == null) {
                    throw (Throwable)new InvalidCipherParametersException();
                }
                it.setCipherId((String)object);
            }
            EnvironmentConfig config = environmentConfig;
            Environment environment = Environments.newInstance((String)dbSummary.getLocation(), (EnvironmentConfig)config);
            String string5 = dbSummary.getKey();
            StoreService storeService = this;
            bl2 = false;
            boolean bl5 = false;
            String it2 = string5;
            boolean bl6 = false;
            if (it2 == null) {
                PersistentEntityStoreImpl persistentEntityStoreImpl3 = PersistentEntityStores.newInstance((Environment)environment);
                persistentEntityStoreImpl2 = persistentEntityStoreImpl3;
                Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityStoreImpl3, (String)"PersistentEntityStores.newInstance(environment)");
            } else {
                PersistentEntityStoreImpl persistentEntityStoreImpl4 = PersistentEntityStores.newInstance((Environment)environment, (String)it2);
                persistentEntityStoreImpl2 = persistentEntityStoreImpl4;
                Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityStoreImpl4, (String)"PersistentEntityStores.n\u2026Instance(environment, it)");
            }
            storeService.store = persistentEntityStoreImpl = persistentEntityStoreImpl2;
            Environment environment2 = this.store.getEnvironment();
            Intrinsics.checkExpressionValueIsNotNull((Object)environment2, (String)"store.environment");
            EnvironmentConfig environmentConfig2 = environment2.getEnvironmentConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig2, (String)"store.environment.environmentConfig");
            this.isReadonly = environmentConfig2.getEnvIsReadonly();
        }
        catch (InvalidCipherParametersException e) {
            final String msg = "It seems that store encrypted with another parameters";
            Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return msg;
                }
            });
            throw (Throwable)new DatabaseException("Database is ciphered with different/unknown cipher parameters");
        }
        catch (RuntimeException e) {
            final String msg = "Can't get valid Xodus entity store location and store key. Check the configuration";
            Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return msg;
                }
            });
            throw (Throwable)new IllegalStateException(msg, e);
        }
    }

    public static final /* synthetic */ PersistentEntityStoreImpl access$getStore$p(StoreService $this) {
        return $this.store;
    }

    public static final /* synthetic */ Entity access$getEntity(StoreService $this, String id2, PersistentStoreTransaction t) {
        return $this.getEntity(id2, t);
    }

    public static final /* synthetic */ void access$applyValues(StoreService $this, Entity $receiver, EntityProperty property) {
        $this.applyValues($receiver, property);
    }

    public static final /* synthetic */ Entity access$getEntityOrStub(StoreService $this, String id2, PersistentStoreTransaction t) {
        return $this.getEntityOrStub(id2, t);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/xodus/browser/web/db/StoreService$Companion;", "Lmu/KLogging;", "()V", "entity-browser-app"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

