/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.xodus.browser.web.resources;

import io.ktor.application.ApplicationCall;
import io.ktor.features.BadRequestException;
import jetbrains.xodus.browser.web.DBSummary;
import jetbrains.xodus.browser.web.NotFoundException;
import jetbrains.xodus.browser.web.WebApplication;
import jetbrains.xodus.browser.web.WebApplicationKt;
import jetbrains.xodus.browser.web.db.JobsService;
import jetbrains.xodus.browser.web.db.StoreService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0014\u001a\u00020\u0015*\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00020\r*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Ljetbrains/xodus/browser/web/resources/ResourceSupport;", "", "webApp", "Ljetbrains/xodus/browser/web/WebApplication;", "(Ljetbrains/xodus/browser/web/WebApplication;)V", "getWebApp", "()Ljetbrains/xodus/browser/web/WebApplication;", "db", "Ljetbrains/xodus/browser/web/DBSummary;", "Lio/ktor/application/ApplicationCall;", "getDb", "(Lio/ktor/application/ApplicationCall;)Ljetbrains/xodus/browser/web/DBSummary;", "jobsService", "Ljetbrains/xodus/browser/web/db/JobsService;", "getJobsService", "(Lio/ktor/application/ApplicationCall;)Ljetbrains/xodus/browser/web/db/JobsService;", "storeService", "Ljetbrains/xodus/browser/web/db/StoreService;", "getStoreService", "(Lio/ktor/application/ApplicationCall;)Ljetbrains/xodus/browser/web/db/StoreService;", "assertEditable", "", "entity-browser-app"})
public class ResourceSupport {
    @NotNull
    private final WebApplication webApp;

    @NotNull
    public final DBSummary getDb(@NotNull ApplicationCall $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string2 = $receiver.getParameters().get("uuid");
        if (string2 == null) {
            throw (Throwable)new NotFoundException("database not found");
        }
        String uuid = string2;
        DBSummary dBSummary = this.webApp.getDatabaseService().find(uuid);
        if (dBSummary == null) {
            throw (Throwable)new NotFoundException("database not found");
        }
        return dBSummary;
    }

    @NotNull
    public final JobsService getJobsService(@NotNull ApplicationCall $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string2 = $receiver.getParameters().get("uuid");
        if (string2 == null) {
            throw (Throwable)new NotFoundException("database not found");
        }
        String uuid = string2;
        return WebApplicationKt.servicesOf(this.webApp, uuid).getJobsService();
    }

    @NotNull
    public final StoreService getStoreService(@NotNull ApplicationCall $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string2 = $receiver.getParameters().get("uuid");
        if (string2 == null) {
            throw (Throwable)new NotFoundException("database service not found");
        }
        String uuid = string2;
        return WebApplicationKt.servicesOf(this.webApp, uuid).getStoreService();
    }

    public final void assertEditable(@NotNull ApplicationCall $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string2 = $receiver.getParameters().get("uuid");
        if (string2 == null) {
            throw (Throwable)new NotFoundException("database service not found");
        }
        String uuid = string2;
        if (WebApplicationKt.servicesOf(this.webApp, uuid).getStoreService().isReadonly()) {
            throw (Throwable)new BadRequestException("store is readonly", null, 2, null);
        }
    }

    @NotNull
    public final WebApplication getWebApp() {
        return this.webApp;
    }

    public ResourceSupport(@NotNull WebApplication webApp) {
        Intrinsics.checkParameterIsNotNull((Object)webApp, (String)"webApp");
        this.webApp = webApp;
    }
}

