/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.xodus.browser.web.search;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.xodus.browser.web.search.ParseException;
import jetbrains.xodus.browser.web.search.SearchQueryException;
import jetbrains.xodus.browser.web.search.SearchTerm;
import jetbrains.xodus.browser.web.search.SearchTermKt;
import jetbrains.xodus.browser.web.search.SmartSearchQueryParser;
import jetbrains.xodus.browser.web.search.TokenMgrError;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002\u001a(\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a(\u0010\f\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0006\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u0006\u00a8\u0006\u0015"}, d2={"orEmpty", "Ljetbrains/exodus/entitystore/EntityIterable;", "f", "Lkotlin/Function0;", "searchByTerms", "term", "", "type", "typeId", "", "t", "Ljetbrains/exodus/entitystore/StoreTransaction;", "smartSearch", "toEntityId", "Ljetbrains/exodus/entitystore/EntityId;", "value", "newParser", "Ljetbrains/xodus/browser/web/search/SmartSearchQueryParser;", "parse", "", "Ljetbrains/xodus/browser/web/search/SearchTerm;", "entity-browser-app"})
public final class SmartSearchKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final EntityIterable smartSearch(@Nullable String term, @NotNull String type, int typeId, @NotNull StoreTransaction t) {
        EntityIterable entityIterable;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                if (term == null) break block7;
                CharSequence $this$trim$iv = term;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                boolean bl = false;
                if (!($this$trim$iv.length() == 0)) break block8;
            }
            EntityIterable entityIterable2 = t.getAll(type);
            entityIterable = entityIterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable2, (String)"t.getAll(type)");
            return entityIterable;
        }
        EntityId entityId2 = SmartSearchKt.toEntityId(typeId, term);
        if (entityId2 != null) {
            entityIterable = SmartSearchKt.orEmpty((Function0<? extends EntityIterable>)((Function0)new Function0<EntityIterable>(t, entityId2){
                final /* synthetic */ StoreTransaction $t;
                final /* synthetic */ EntityId $entityId;

                @NotNull
                public final EntityIterable invoke() {
                    EntityIterable entityIterable = this.$t.getSingletonIterable(this.$t.getEntity(this.$entityId));
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable, (String)"t.getSingletonIterable(t.getEntity(entityId))");
                    return entityIterable;
                }
                {
                    this.$t = storeTransaction;
                    this.$entityId = entityId2;
                    super(0);
                }
            }));
            return entityIterable;
        }
        entityIterable = SmartSearchKt.searchByTerms(term, type, typeId, t);
        return entityIterable;
    }

    /*
     * WARNING - void declaration
     */
    private static final EntityIterable searchByTerms(String term, String type, int typeId, StoreTransaction t) {
        EntityIterable entityIterable;
        try {
            void $this$mapTo$iv$iv;
            List<SearchTerm> termStream = SmartSearchKt.parse(term);
            Iterable $this$map$iv = termStream;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SearchTerm searchTerm = (SearchTerm)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                EntityIterable entityIterable2 = it.search(t, type, typeId);
                collection.add(entityIterable2);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void it2;
                EntityIterable $i$f$mapTo2 = (EntityIterable)iterator$iv.next();
                EntityIterable it1 = (EntityIterable)accumulator$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it1.intersect((EntityIterable)it2), (String)"it1.intersect(it2)");
            }
            entityIterable = (EntityIterable)accumulator$iv;
        }
        catch (ParseException ex) {
            throw (Throwable)new SearchQueryException(ex);
        }
        catch (TokenMgrError ex) {
            throw (Throwable)new SearchQueryException(ex);
        }
        catch (SearchQueryException ex) {
            throw (Throwable)ex;
        }
        catch (RuntimeException ex) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"EntityIterableBase.EMPTY");
            entityIterable = (EntityIterable)entityIterableBase;
        }
        return entityIterable;
    }

    private static final EntityIterable orEmpty(Function0<? extends EntityIterable> f) {
        try {
            return (EntityIterable)f.invoke();
        }
        catch (RuntimeException e) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"EntityIterableBase.EMPTY");
            return (EntityIterable)entityIterableBase;
        }
    }

    private static final EntityId toEntityId(int typeId, String value) {
        if (SearchTermKt.toLongOrNull(value) != null) {
            long l;
            String string2 = value;
            int n = typeId;
            boolean bl = false;
            long l2 = l = Long.parseLong(string2);
            int n2 = n;
            return (EntityId)new PersistentEntityId(n2, l2);
        }
        return null;
    }

    @NotNull
    public static final SmartSearchQueryParser newParser(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            byte[] byArray;
            String string2 = $receiver;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray2 = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray = byArray2;
            InputStream inputStream = new ByteArrayInputStream(byArray3);
            return new SmartSearchQueryParser(inputStream);
        }
        catch (RuntimeException e) {
            throw (Throwable)new IllegalStateException(e);
        }
    }

    @NotNull
    public static final List<SearchTerm> parse(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            List<SearchTerm> list = SmartSearchKt.newParser($receiver).parse();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"this.newParser().parse()");
            return list;
        }
        catch (ParseException e) {
            throw (Throwable)new IllegalStateException(e);
        }
    }
}

